/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import libcore.io.Streams;

public class CipherOutputStream
extends FilterOutputStream {
    private final Cipher cipher;

    public CipherOutputStream(OutputStream os, Cipher c) {
        super(os);
        this.cipher = c;
    }

    protected CipherOutputStream(OutputStream os) {
        this(os, new NullCipher());
    }

    public void write(int b) throws IOException {
        Streams.writeSingleByte(this, b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        byte[] result = this.cipher.update(b, off, len);
        if (result != null) {
            this.out.write(result);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        try {
            block6: {
                try {
                    byte[] result;
                    if (this.cipher != null && (result = this.cipher.doFinal()) != null) {
                        this.out.write(result);
                    }
                    if (this.out == null) break block6;
                    this.out.flush();
                }
                catch (BadPaddingException e) {
                    throw new IOException(e.getMessage());
                }
                catch (IllegalBlockSizeException e) {
                    throw new IOException(e.getMessage());
                }
            }
            Object var4_2 = null;
            if (this.out == null) return;
            this.out.close();
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (this.out == null) throw throwable;
            this.out.close();
            throw throwable;
        }
    }
}

