/*
 * Decompiled with CFR 0.152.
 */
package javax.obex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.Authenticator;
import javax.obex.ClientOperation;
import javax.obex.HeaderSet;
import javax.obex.ObexHelper;
import javax.obex.ObexSession;
import javax.obex.ObexTransport;
import javax.obex.Operation;
import javax.obex.PrivateInputStream;

public final class ClientSession
extends ObexSession {
    private boolean mOpen;
    private boolean mObexConnected;
    private byte[] mConnectionId = null;
    private int maxPacketSize = 256;
    private boolean mRequestActive;
    private final InputStream mInput;
    private final OutputStream mOutput;

    public ClientSession(ObexTransport trans) throws IOException {
        this.mInput = trans.openInputStream();
        this.mOutput = trans.openOutputStream();
        this.mOpen = true;
        this.mRequestActive = false;
    }

    public HeaderSet connect(HeaderSet header) throws IOException {
        this.ensureOpen();
        if (this.mObexConnected) {
            throw new IOException("Already connected to server");
        }
        this.setRequestActive();
        int totalLength = 4;
        byte[] head = null;
        if (header != null) {
            if (header.nonce != null) {
                this.mChallengeDigest = new byte[16];
                System.arraycopy(header.nonce, 0, this.mChallengeDigest, 0, 16);
            }
            head = ObexHelper.createHeader(header, false);
            totalLength += head.length;
        }
        byte[] requestPacket = new byte[totalLength];
        requestPacket[0] = 16;
        requestPacket[1] = 0;
        requestPacket[2] = -1;
        requestPacket[3] = -2;
        if (head != null) {
            System.arraycopy(head, 0, requestPacket, 4, head.length);
        }
        if (requestPacket.length + 3 > 65534) {
            throw new IOException("Packet size exceeds max packet size");
        }
        HeaderSet returnHeaderSet = new HeaderSet();
        this.sendRequest(128, requestPacket, returnHeaderSet, null);
        if (returnHeaderSet.responseCode == 160) {
            this.mObexConnected = true;
        }
        this.setRequestInactive();
        return returnHeaderSet;
    }

    public Operation get(HeaderSet header) throws IOException {
        HeaderSet head;
        if (!this.mObexConnected) {
            throw new IOException("Not connected to the server");
        }
        this.setRequestActive();
        this.ensureOpen();
        if (header == null) {
            head = new HeaderSet();
        } else {
            head = header;
            if (head.nonce != null) {
                this.mChallengeDigest = new byte[16];
                System.arraycopy(head.nonce, 0, this.mChallengeDigest, 0, 16);
            }
        }
        if (this.mConnectionId != null) {
            head.mConnectionID = new byte[4];
            System.arraycopy(this.mConnectionId, 0, head.mConnectionID, 0, 4);
        }
        return new ClientOperation(this.maxPacketSize, this, head, true);
    }

    public void setConnectionID(long id2) {
        if (id2 < 0L || id2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Connection ID is not in a valid range");
        }
        this.mConnectionId = ObexHelper.convertToByteArray(id2);
    }

    public HeaderSet delete(HeaderSet header) throws IOException {
        Operation op = this.put(header);
        op.getResponseCode();
        HeaderSet returnValue = op.getReceivedHeader();
        op.close();
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet disconnect(HeaderSet header) throws IOException {
        if (!this.mObexConnected) {
            throw new IOException("Not connected to the server");
        }
        this.setRequestActive();
        this.ensureOpen();
        byte[] head = null;
        if (header != null) {
            if (header.nonce != null) {
                this.mChallengeDigest = new byte[16];
                System.arraycopy(header.nonce, 0, this.mChallengeDigest, 0, 16);
            }
            if (this.mConnectionId != null) {
                header.mConnectionID = new byte[4];
                System.arraycopy(this.mConnectionId, 0, header.mConnectionID, 0, 4);
            }
            if ((head = ObexHelper.createHeader(header, false)).length + 3 > this.maxPacketSize) {
                throw new IOException("Packet size exceeds max packet size");
            }
        } else if (this.mConnectionId != null) {
            head = new byte[5];
            head[0] = -53;
            System.arraycopy(this.mConnectionId, 0, head, 1, 4);
        }
        HeaderSet returnHeaderSet = new HeaderSet();
        this.sendRequest(129, head, returnHeaderSet, null);
        ClientSession clientSession = this;
        synchronized (clientSession) {
            this.mObexConnected = false;
            this.setRequestInactive();
        }
        return returnHeaderSet;
    }

    public long getConnectionID() {
        if (this.mConnectionId == null) {
            return -1L;
        }
        return ObexHelper.convertToLong(this.mConnectionId);
    }

    public Operation put(HeaderSet header) throws IOException {
        HeaderSet head;
        if (!this.mObexConnected) {
            throw new IOException("Not connected to the server");
        }
        this.setRequestActive();
        this.ensureOpen();
        if (header == null) {
            head = new HeaderSet();
        } else {
            head = header;
            if (head.nonce != null) {
                this.mChallengeDigest = new byte[16];
                System.arraycopy(head.nonce, 0, this.mChallengeDigest, 0, 16);
            }
        }
        if (this.mConnectionId != null) {
            head.mConnectionID = new byte[4];
            System.arraycopy(this.mConnectionId, 0, head.mConnectionID, 0, 4);
        }
        return new ClientOperation(this.maxPacketSize, this, head, false);
    }

    public void setAuthenticator(Authenticator auth) throws IOException {
        if (auth == null) {
            throw new IOException("Authenticator may not be null");
        }
        this.mAuthenticator = auth;
    }

    public HeaderSet setPath(HeaderSet header, boolean backup, boolean create) throws IOException {
        HeaderSet headset;
        if (!this.mObexConnected) {
            throw new IOException("Not connected to the server");
        }
        this.setRequestActive();
        this.ensureOpen();
        int totalLength = 2;
        byte[] head = null;
        if (header == null) {
            headset = new HeaderSet();
        } else {
            headset = header;
            if (headset.nonce != null) {
                this.mChallengeDigest = new byte[16];
                System.arraycopy(headset.nonce, 0, this.mChallengeDigest, 0, 16);
            }
        }
        if (headset.nonce != null) {
            this.mChallengeDigest = new byte[16];
            System.arraycopy(headset.nonce, 0, this.mChallengeDigest, 0, 16);
        }
        if (this.mConnectionId != null) {
            headset.mConnectionID = new byte[4];
            System.arraycopy(this.mConnectionId, 0, headset.mConnectionID, 0, 4);
        }
        if ((totalLength += (head = ObexHelper.createHeader(headset, false)).length) > this.maxPacketSize) {
            throw new IOException("Packet size exceeds max packet size");
        }
        int flags = 0;
        if (backup) {
            ++flags;
        }
        if (!create) {
            flags |= 2;
        }
        byte[] packet = new byte[totalLength];
        packet[0] = (byte)flags;
        packet[1] = 0;
        if (headset != null) {
            System.arraycopy(head, 0, packet, 2, head.length);
        }
        HeaderSet returnHeaderSet = new HeaderSet();
        this.sendRequest(133, packet, returnHeaderSet, null);
        this.setRequestInactive();
        return returnHeaderSet;
    }

    public synchronized void ensureOpen() throws IOException {
        if (!this.mOpen) {
            throw new IOException("Connection closed");
        }
    }

    synchronized void setRequestInactive() {
        this.mRequestActive = false;
    }

    private synchronized void setRequestActive() throws IOException {
        if (this.mRequestActive) {
            throw new IOException("OBEX request is already being performed");
        }
        this.mRequestActive = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sendRequest(int opCode, byte[] head, HeaderSet header, PrivateInputStream privateInput) throws IOException {
        if (head != null && head.length + 3 > 65534) {
            throw new IOException("header too large ");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write((byte)opCode);
        if (head == null) {
            out.write(0);
            out.write(3);
        } else {
            out.write((byte)(head.length + 3 >> 8));
            out.write((byte)(head.length + 3));
            out.write(head);
        }
        this.mOutput.write(out.toByteArray());
        this.mOutput.flush();
        header.responseCode = this.mInput.read();
        int length = this.mInput.read() << 8 | this.mInput.read();
        if (length > 65534) {
            throw new IOException("Packet received exceeds packet size limit");
        }
        if (length <= 3) return true;
        byte[] data = null;
        if (opCode == 128) {
            int version = this.mInput.read();
            int flags = this.mInput.read();
            this.maxPacketSize = (this.mInput.read() << 8) + this.mInput.read();
            if (this.maxPacketSize > 64512) {
                this.maxPacketSize = 64512;
            }
            if (length <= 7) return true;
            data = new byte[length - 7];
            for (int bytesReceived = this.mInput.read(data); bytesReceived != length - 7; bytesReceived += this.mInput.read(data, bytesReceived, data.length - bytesReceived)) {
            }
        } else {
            data = new byte[length - 3];
            for (int bytesReceived = this.mInput.read(data); bytesReceived != length - 3; bytesReceived += this.mInput.read(data, bytesReceived, data.length - bytesReceived)) {
            }
            if (opCode == 255) {
                return true;
            }
        }
        byte[] body = ObexHelper.updateHeaderSet(header, data);
        if (privateInput != null && body != null) {
            privateInput.writeBytes(body, 1);
        }
        if (header.mConnectionID != null) {
            this.mConnectionId = new byte[4];
            System.arraycopy(header.mConnectionID, 0, this.mConnectionId, 0, 4);
        }
        if (header.mAuthResp != null && !this.handleAuthResp(header.mAuthResp)) {
            this.setRequestInactive();
            throw new IOException("Authentication Failed");
        }
        if (header.responseCode != 193 || header.mAuthChall == null || !this.handleAuthChall(header)) return true;
        out.write(78);
        out.write((byte)(header.mAuthResp.length + 3 >> 8));
        out.write((byte)(header.mAuthResp.length + 3));
        out.write(header.mAuthResp);
        header.mAuthChall = null;
        header.mAuthResp = null;
        byte[] sendHeaders = new byte[out.size() - 3];
        System.arraycopy(out.toByteArray(), 3, sendHeaders, 0, sendHeaders.length);
        return this.sendRequest(opCode, sendHeaders, header, privateInput);
    }

    public void close() throws IOException {
        this.mOpen = false;
        this.mInput.close();
        this.mOutput.close();
    }
}

