/*
 * Decompiled with CFR 0.152.
 */
package javax.obex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.obex.HeaderSet;

public final class ObexHelper {
    public static final int BASE_PACKET_LENGTH = 3;
    public static final int MAX_PACKET_SIZE_INT = 65534;
    public static final int MAX_CLIENT_PACKET_SIZE = 64512;
    public static final int OBEX_OPCODE_CONNECT = 128;
    public static final int OBEX_OPCODE_DISCONNECT = 129;
    public static final int OBEX_OPCODE_PUT = 2;
    public static final int OBEX_OPCODE_PUT_FINAL = 130;
    public static final int OBEX_OPCODE_GET = 3;
    public static final int OBEX_OPCODE_GET_FINAL = 131;
    public static final int OBEX_OPCODE_RESERVED = 4;
    public static final int OBEX_OPCODE_RESERVED_FINAL = 132;
    public static final int OBEX_OPCODE_SETPATH = 133;
    public static final int OBEX_OPCODE_ABORT = 255;
    public static final int OBEX_AUTH_REALM_CHARSET_ASCII = 0;
    public static final int OBEX_AUTH_REALM_CHARSET_ISO_8859_1 = 1;
    public static final int OBEX_AUTH_REALM_CHARSET_ISO_8859_2 = 2;
    public static final int OBEX_AUTH_REALM_CHARSET_ISO_8859_3 = 3;
    public static final int OBEX_AUTH_REALM_CHARSET_ISO_8859_4 = 4;
    public static final int OBEX_AUTH_REALM_CHARSET_ISO_8859_5 = 5;
    public static final int OBEX_AUTH_REALM_CHARSET_ISO_8859_6 = 6;
    public static final int OBEX_AUTH_REALM_CHARSET_ISO_8859_7 = 7;
    public static final int OBEX_AUTH_REALM_CHARSET_ISO_8859_8 = 8;
    public static final int OBEX_AUTH_REALM_CHARSET_ISO_8859_9 = 9;
    public static final int OBEX_AUTH_REALM_CHARSET_UNICODE = 255;

    private ObexHelper() {
    }

    public static byte[] updateHeaderSet(HeaderSet header, byte[] headerArray) throws IOException {
        int index = 0;
        int length = 0;
        byte[] value = null;
        byte[] body = null;
        HeaderSet headerImpl = header;
        try {
            while (index < headerArray.length) {
                int headerID = 0xFF & headerArray[index];
                switch (headerID & 0xC0) {
                    case 0: 
                    case 64: {
                        boolean trimTail = true;
                        length = 0xFF & headerArray[++index];
                        length <<= 8;
                        length += 0xFF & headerArray[++index];
                        value = new byte[length -= 3];
                        System.arraycopy(headerArray, ++index, value, 0, length);
                        if (length == 0 || length > 0 && value[length - 1] != 0) {
                            trimTail = false;
                        }
                        switch (headerID) {
                            case 66: {
                                if (!trimTail) {
                                    headerImpl.setHeader(headerID, new String(value, 0, value.length, "ISO8859_1"));
                                    break;
                                }
                                headerImpl.setHeader(headerID, new String(value, 0, value.length - 1, "ISO8859_1"));
                                break;
                            }
                            case 77: {
                                headerImpl.mAuthChall = new byte[length];
                                System.arraycopy(headerArray, index, headerImpl.mAuthChall, 0, length);
                                break;
                            }
                            case 78: {
                                headerImpl.mAuthResp = new byte[length];
                                System.arraycopy(headerArray, index, headerImpl.mAuthResp, 0, length);
                                break;
                            }
                            case 72: 
                            case 73: {
                                body = new byte[length + 1];
                                body[0] = (byte)headerID;
                                System.arraycopy(headerArray, index, body, 1, length);
                                break;
                            }
                            case 68: {
                                String dateString = new String(value, "ISO8859_1");
                                Calendar temp = Calendar.getInstance();
                                if (dateString.length() == 16 && dateString.charAt(15) == 'Z') {
                                    temp.setTimeZone(TimeZone.getTimeZone("UTC"));
                                }
                                temp.set(1, Integer.parseInt(dateString.substring(0, 4)));
                                temp.set(2, Integer.parseInt(dateString.substring(4, 6)));
                                temp.set(5, Integer.parseInt(dateString.substring(6, 8)));
                                temp.set(11, Integer.parseInt(dateString.substring(9, 11)));
                                temp.set(12, Integer.parseInt(dateString.substring(11, 13)));
                                temp.set(13, Integer.parseInt(dateString.substring(13, 15)));
                                headerImpl.setHeader(68, temp);
                                break;
                            }
                            default: {
                                if ((headerID & 0xC0) == 0) {
                                    headerImpl.setHeader(headerID, ObexHelper.convertToUnicode(value, true));
                                    break;
                                }
                                headerImpl.setHeader(headerID, value);
                            }
                        }
                        index += length;
                        break;
                    }
                    case 128: {
                        ++index;
                        try {
                            headerImpl.setHeader(headerID, headerArray[index]);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ++index;
                        break;
                    }
                    case 192: {
                        value = new byte[4];
                        System.arraycopy(headerArray, ++index, value, 0, 4);
                        try {
                            if (headerID != 196) {
                                if (headerID == 203) {
                                    headerImpl.mConnectionID = new byte[4];
                                    System.arraycopy(value, 0, headerImpl.mConnectionID, 0, 4);
                                } else {
                                    headerImpl.setHeader(headerID, ObexHelper.convertToLong(value));
                                }
                            } else {
                                Calendar temp = Calendar.getInstance();
                                temp.setTime(new Date(ObexHelper.convertToLong(value) * 1000L));
                                headerImpl.setHeader(196, temp);
                            }
                        }
                        catch (Exception e) {
                            throw new IOException("Header was not formatted properly");
                        }
                        index += 4;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IOException("Header was not formatted properly");
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createHeader(HeaderSet head, boolean nullOut) {
        Long intHeader = null;
        String stringHeader = null;
        Calendar dateHeader = null;
        Byte byteHeader = null;
        StringBuffer buffer = null;
        byte[] value = null;
        byte[] result = null;
        byte[] lengthArray = new byte[2];
        HeaderSet headImpl = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        headImpl = head;
        try {
            int length;
            if (headImpl.mConnectionID != null && headImpl.getHeader(70) == null) {
                out.write(-53);
                out.write(headImpl.mConnectionID);
            }
            if ((intHeader = (Long)headImpl.getHeader(192)) != null) {
                out.write(-64);
                value = ObexHelper.convertToByteArray(intHeader);
                out.write(value);
                if (nullOut) {
                    headImpl.setHeader(192, null);
                }
            }
            if ((stringHeader = (String)headImpl.getHeader(1)) != null) {
                out.write(1);
                value = ObexHelper.convertToUnicodeByteArray(stringHeader);
                length = value.length + 3;
                lengthArray[0] = (byte)(0xFF & length >> 8);
                lengthArray[1] = (byte)(0xFF & length);
                out.write(lengthArray);
                out.write(value);
                if (nullOut) {
                    headImpl.setHeader(1, null);
                }
            }
            if ((stringHeader = (String)headImpl.getHeader(66)) != null) {
                out.write(66);
                value = stringHeader.getBytes("ISO8859_1");
                length = value.length + 4;
                lengthArray[0] = (byte)(0xFF & length >> 8);
                lengthArray[1] = (byte)(0xFF & length);
                out.write(lengthArray);
                out.write(value);
                out.write(0);
                if (nullOut) {
                    headImpl.setHeader(66, null);
                }
            }
            if ((intHeader = (Long)headImpl.getHeader(195)) != null) {
                out.write(-61);
                value = ObexHelper.convertToByteArray(intHeader);
                out.write(value);
                if (nullOut) {
                    headImpl.setHeader(195, null);
                }
            }
            if ((dateHeader = (Calendar)headImpl.getHeader(68)) != null) {
                int temp;
                buffer = new StringBuffer();
                for (int i = temp = dateHeader.get(1); i < 1000; i *= 10) {
                    buffer.append("0");
                }
                buffer.append(temp);
                temp = dateHeader.get(2);
                if (temp < 10) {
                    buffer.append("0");
                }
                buffer.append(temp);
                temp = dateHeader.get(5);
                if (temp < 10) {
                    buffer.append("0");
                }
                buffer.append(temp);
                buffer.append("T");
                temp = dateHeader.get(11);
                if (temp < 10) {
                    buffer.append("0");
                }
                buffer.append(temp);
                temp = dateHeader.get(12);
                if (temp < 10) {
                    buffer.append("0");
                }
                buffer.append(temp);
                temp = dateHeader.get(13);
                if (temp < 10) {
                    buffer.append("0");
                }
                buffer.append(temp);
                if (dateHeader.getTimeZone().getID().equals("UTC")) {
                    buffer.append("Z");
                }
                value = buffer.toString().getBytes("ISO8859_1");
                length = value.length + 3;
                lengthArray[0] = (byte)(0xFF & length >> 8);
                lengthArray[1] = (byte)(0xFF & length);
                out.write(68);
                out.write(lengthArray);
                out.write(value);
                if (nullOut) {
                    headImpl.setHeader(68, null);
                }
            }
            if ((dateHeader = (Calendar)headImpl.getHeader(196)) != null) {
                out.write(196);
                value = ObexHelper.convertToByteArray(dateHeader.getTime().getTime() / 1000L);
                out.write(value);
                if (nullOut) {
                    headImpl.setHeader(196, null);
                }
            }
            if ((stringHeader = (String)headImpl.getHeader(5)) != null) {
                out.write(5);
                value = ObexHelper.convertToUnicodeByteArray(stringHeader);
                length = value.length + 3;
                lengthArray[0] = (byte)(0xFF & length >> 8);
                lengthArray[1] = (byte)(0xFF & length);
                out.write(lengthArray);
                out.write(value);
                if (nullOut) {
                    headImpl.setHeader(5, null);
                }
            }
            if ((value = (byte[])headImpl.getHeader(70)) != null) {
                out.write(70);
                length = value.length + 3;
                lengthArray[0] = (byte)(0xFF & length >> 8);
                lengthArray[1] = (byte)(0xFF & length);
                out.write(lengthArray);
                out.write(value);
                if (nullOut) {
                    headImpl.setHeader(70, null);
                }
            }
            if ((value = (byte[])headImpl.getHeader(71)) != null) {
                out.write(71);
                length = value.length + 3;
                lengthArray[0] = (byte)(0xFF & length >> 8);
                lengthArray[1] = (byte)(0xFF & length);
                out.write(lengthArray);
                out.write(value);
                if (nullOut) {
                    headImpl.setHeader(71, null);
                }
            }
            if ((value = (byte[])headImpl.getHeader(74)) != null) {
                out.write(74);
                length = value.length + 3;
                lengthArray[0] = (byte)(0xFF & length >> 8);
                lengthArray[1] = (byte)(0xFF & length);
                out.write(lengthArray);
                out.write(value);
                if (nullOut) {
                    headImpl.setHeader(74, null);
                }
            }
            if ((value = (byte[])headImpl.getHeader(76)) != null) {
                out.write(76);
                length = value.length + 3;
                lengthArray[0] = (byte)(0xFF & length >> 8);
                lengthArray[1] = (byte)(0xFF & length);
                out.write(lengthArray);
                out.write(value);
                if (nullOut) {
                    headImpl.setHeader(76, null);
                }
            }
            if ((value = (byte[])headImpl.getHeader(79)) != null) {
                out.write(79);
                length = value.length + 3;
                lengthArray[0] = (byte)(0xFF & length >> 8);
                lengthArray[1] = (byte)(0xFF & length);
                out.write(lengthArray);
                out.write(value);
                if (nullOut) {
                    headImpl.setHeader(79, null);
                }
            }
            for (int i = 0; i < 16; ++i) {
                stringHeader = (String)headImpl.getHeader(i + 48);
                if (stringHeader != null) {
                    out.write((byte)i + 48);
                    value = ObexHelper.convertToUnicodeByteArray(stringHeader);
                    length = value.length + 3;
                    lengthArray[0] = (byte)(0xFF & length >> 8);
                    lengthArray[1] = (byte)(0xFF & length);
                    out.write(lengthArray);
                    out.write(value);
                    if (nullOut) {
                        headImpl.setHeader(i + 48, null);
                    }
                }
                if ((value = (byte[])headImpl.getHeader(i + 112)) != null) {
                    out.write((byte)i + 112);
                    length = value.length + 3;
                    lengthArray[0] = (byte)(0xFF & length >> 8);
                    lengthArray[1] = (byte)(0xFF & length);
                    out.write(lengthArray);
                    out.write(value);
                    if (nullOut) {
                        headImpl.setHeader(i + 112, null);
                    }
                }
                if ((byteHeader = (Byte)headImpl.getHeader(i + 176)) != null) {
                    out.write((byte)i + 176);
                    out.write(byteHeader.byteValue());
                    if (nullOut) {
                        headImpl.setHeader(i + 176, null);
                    }
                }
                if ((intHeader = (Long)headImpl.getHeader(i + 240)) == null) continue;
                out.write((byte)i + 240);
                out.write(ObexHelper.convertToByteArray(intHeader));
                if (!nullOut) continue;
                headImpl.setHeader(i + 240, null);
            }
            if (headImpl.mAuthChall != null) {
                out.write(77);
                length = headImpl.mAuthChall.length + 3;
                lengthArray[0] = (byte)(0xFF & length >> 8);
                lengthArray[1] = (byte)(0xFF & length);
                out.write(lengthArray);
                out.write(headImpl.mAuthChall);
                if (nullOut) {
                    headImpl.mAuthChall = null;
                }
            }
            if (headImpl.mAuthResp != null) {
                out.write(78);
                length = headImpl.mAuthResp.length + 3;
                lengthArray[0] = (byte)(0xFF & length >> 8);
                lengthArray[1] = (byte)(0xFF & length);
                out.write(lengthArray);
                out.write(headImpl.mAuthResp);
                if (nullOut) {
                    headImpl.mAuthResp = null;
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            result = out.toByteArray();
            try {
                out.close();
            }
            catch (Exception ex) {}
        }
        return result;
    }

    public static int findHeaderEnd(byte[] headerArray, int start, int maxSize) {
        int fullLength = 0;
        int lastLength = -1;
        int index = start;
        int length = 0;
        while (fullLength < maxSize && index < headerArray.length) {
            int headerID = headerArray[index] < 0 ? headerArray[index] + 256 : headerArray[index];
            lastLength = fullLength;
            switch (headerID & 0xC0) {
                case 0: 
                case 64: {
                    length = headerArray[++index] < 0 ? headerArray[index] + 256 : headerArray[index];
                    length <<= 8;
                    length += headerArray[++index] < 0 ? headerArray[index] + 256 : headerArray[index];
                    ++index;
                    index += (length -= 3);
                    fullLength += length + 3;
                    break;
                }
                case 128: {
                    ++index;
                    ++index;
                    fullLength += 2;
                    break;
                }
                case 192: {
                    index += 5;
                    fullLength += 5;
                }
            }
        }
        if (lastLength == 0) {
            if (fullLength < maxSize) {
                return headerArray.length;
            }
            return -1;
        }
        return lastLength + start;
    }

    public static long convertToLong(byte[] b) {
        long result = 0L;
        long value = 0L;
        long power = 0L;
        for (int i = b.length - 1; i >= 0; --i) {
            value = b[i];
            if (value < 0L) {
                value += 256L;
            }
            result |= value << (int)power;
            power += 8L;
        }
        return result;
    }

    public static byte[] convertToByteArray(long l) {
        byte[] b = new byte[]{(byte)(0xFFL & l >> 24), (byte)(0xFFL & l >> 16), (byte)(0xFFL & l >> 8), (byte)(0xFFL & l)};
        return b;
    }

    public static byte[] convertToUnicodeByteArray(String s) {
        if (s == null) {
            return null;
        }
        char[] c = s.toCharArray();
        byte[] result = new byte[c.length * 2 + 2];
        for (int i = 0; i < c.length; ++i) {
            result[i * 2] = (byte)(c[i] >> 8);
            result[i * 2 + 1] = (byte)c[i];
        }
        result[result.length - 2] = 0;
        result[result.length - 1] = 0;
        return result;
    }

    public static byte[] getTagValue(byte tag, byte[] triplet) {
        int index = ObexHelper.findTag(tag, triplet);
        if (index == -1) {
            return null;
        }
        int length = triplet[++index] & 0xFF;
        byte[] result = new byte[length];
        System.arraycopy(triplet, ++index, result, 0, length);
        return result;
    }

    public static int findTag(byte tag, byte[] value) {
        int index;
        int length = 0;
        if (value == null) {
            return -1;
        }
        for (index = 0; index < value.length && value[index] != tag; index += length + 2) {
            length = value[index + 1] & 0xFF;
        }
        if (index >= value.length) {
            return -1;
        }
        return index;
    }

    public static String convertToUnicode(byte[] b, boolean includesNull) {
        if (b == null || b.length == 0) {
            return null;
        }
        int arrayLength = b.length;
        if (arrayLength % 2 != 0) {
            throw new IllegalArgumentException("Byte array not of a valid form");
        }
        arrayLength >>= 1;
        if (includesNull) {
            --arrayLength;
        }
        char[] c = new char[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            int upper = b[2 * i];
            int lower = b[2 * i + 1];
            if (upper < 0) {
                upper += 256;
            }
            if (lower < 0) {
                lower += 256;
            }
            if (upper == 0 && lower == 0) {
                return new String(c, 0, i);
            }
            c[i] = (char)(upper << 8 | lower);
        }
        return new String(c);
    }

    public static byte[] computeMd5Hash(byte[] in) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            return md5.digest(in);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] computeAuthenticationChallenge(byte[] nonce, String realm, boolean access, boolean userID) throws IOException {
        byte[] authChall = null;
        if (nonce.length != 16) {
            throw new IllegalArgumentException("Nonce must be 16 bytes long");
        }
        if (realm == null) {
            authChall = new byte[21];
        } else {
            if (realm.length() >= 255) {
                throw new IllegalArgumentException("Realm must be less then 255 bytes");
            }
            authChall = new byte[24 + realm.length()];
            authChall[21] = 2;
            authChall[22] = (byte)(realm.length() + 1);
            authChall[23] = 1;
            System.arraycopy(realm.getBytes("ISO8859_1"), 0, authChall, 24, realm.length());
        }
        authChall[0] = 0;
        authChall[1] = 16;
        System.arraycopy(nonce, 0, authChall, 2, 16);
        authChall[18] = 1;
        authChall[19] = 1;
        authChall[20] = 0;
        if (!access) {
            authChall[20] = (byte)(authChall[20] | 2);
        }
        if (userID) {
            authChall[20] = (byte)(authChall[20] | 1);
        }
        return authChall;
    }
}

