/*
 * Decompiled with CFR 0.152.
 */
package javax.obex;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.Authenticator;
import javax.obex.HeaderSet;
import javax.obex.ObexHelper;
import javax.obex.ObexSession;
import javax.obex.ObexTransport;
import javax.obex.ServerOperation;
import javax.obex.ServerRequestHandler;

public final class ServerSession
extends ObexSession
implements Runnable {
    private static final String TAG = "Obex ServerSession";
    private ObexTransport mTransport;
    private InputStream mInput;
    private OutputStream mOutput;
    private ServerRequestHandler mListener;
    private Thread mProcessThread;
    private int mMaxPacketLength;
    private boolean mClosed;

    public ServerSession(ObexTransport trans, ServerRequestHandler handler, Authenticator auth) throws IOException {
        this.mAuthenticator = auth;
        this.mTransport = trans;
        this.mInput = this.mTransport.openInputStream();
        this.mOutput = this.mTransport.openOutputStream();
        this.mListener = handler;
        this.mMaxPacketLength = 256;
        this.mClosed = false;
        this.mProcessThread = new Thread(this);
        this.mProcessThread.start();
    }

    public void run() {
        try {
            boolean done = false;
            block12: while (!done && !this.mClosed) {
                int requestType = this.mInput.read();
                switch (requestType) {
                    case 128: {
                        this.handleConnectRequest();
                        continue block12;
                    }
                    case 129: {
                        this.handleDisconnectRequest();
                        done = true;
                        continue block12;
                    }
                    case 3: 
                    case 131: {
                        this.handleGetRequest(requestType);
                        continue block12;
                    }
                    case 2: 
                    case 130: {
                        this.handlePutRequest(requestType);
                        continue block12;
                    }
                    case 133: {
                        this.handleSetPathRequest();
                        continue block12;
                    }
                    case 255: {
                        this.handleAbortRequest();
                        continue block12;
                    }
                    case -1: {
                        done = true;
                        continue block12;
                    }
                }
                int length = this.mInput.read();
                length = (length << 8) + this.mInput.read();
                for (int i = 3; i < length; ++i) {
                    this.mInput.read();
                }
                this.sendResponse(209, null);
            }
        }
        catch (NullPointerException e) {
            Log.d(TAG, e.toString());
        }
        catch (Exception e) {
            Log.d(TAG, e.toString());
        }
        this.close();
    }

    private void handleAbortRequest() throws IOException {
        int code = 160;
        HeaderSet request = new HeaderSet();
        HeaderSet reply = new HeaderSet();
        int length = this.mInput.read();
        if ((length = (length << 8) + this.mInput.read()) > 65534) {
            code = 206;
        } else {
            for (int i = 3; i < length; ++i) {
                this.mInput.read();
            }
            code = this.mListener.onAbort(request, reply);
            Log.v(TAG, "onAbort request handler return value- " + code);
            code = this.validateResponseCode(code);
        }
        this.sendResponse(code, null);
    }

    private void handlePutRequest(int type) throws IOException {
        block6: {
            ServerOperation op = new ServerOperation(this, this.mInput, type, this.mMaxPacketLength, this.mListener);
            try {
                int response = -1;
                response = op.finalBitSet && !op.isValidBody() ? this.validateResponseCode(this.mListener.onDelete(op.requestHeader, op.replyHeader)) : this.validateResponseCode(this.mListener.onPut(op));
                if (response != 160 && !op.isAborted) {
                    op.sendReply(response);
                } else if (!op.isAborted) {
                    while (!op.finalBitSet) {
                        op.sendReply(144);
                    }
                    op.sendReply(response);
                }
            }
            catch (Exception e) {
                if (op.isAborted) break block6;
                this.sendResponse(208, null);
            }
        }
    }

    private void handleGetRequest(int type) throws IOException {
        ServerOperation op = new ServerOperation(this, this.mInput, type, this.mMaxPacketLength, this.mListener);
        try {
            int response = this.validateResponseCode(this.mListener.onGet(op));
            if (!op.isAborted) {
                op.sendReply(response);
            }
        }
        catch (Exception e) {
            this.sendResponse(208, null);
        }
    }

    public void sendResponse(int code, byte[] header) throws IOException {
        int totalLength = 3;
        byte[] data = null;
        OutputStream op = this.mOutput;
        if (op == null) {
            return;
        }
        if (header != null) {
            data = new byte[totalLength += header.length];
            data[0] = (byte)code;
            data[1] = (byte)(totalLength >> 8);
            data[2] = (byte)totalLength;
            System.arraycopy(header, 0, data, 3, header.length);
        } else {
            data = new byte[totalLength];
            data[0] = (byte)code;
            data[1] = 0;
            data[2] = (byte)totalLength;
        }
        op.write(data);
        op.flush();
    }

    private void handleSetPathRequest() throws IOException {
        int totalLength = 3;
        byte[] head = null;
        int code = -1;
        HeaderSet request = new HeaderSet();
        HeaderSet reply = new HeaderSet();
        int length = this.mInput.read();
        length = (length << 8) + this.mInput.read();
        int flags = this.mInput.read();
        int constants = this.mInput.read();
        if (length > 65534) {
            code = 206;
            totalLength = 3;
        } else {
            if (length > 5) {
                byte[] headers = new byte[length - 5];
                for (int bytesReceived = this.mInput.read(headers); bytesReceived != headers.length; bytesReceived += this.mInput.read(headers, bytesReceived, headers.length - bytesReceived)) {
                }
                ObexHelper.updateHeaderSet(request, headers);
                if (this.mListener.getConnectionId() != -1L && request.mConnectionID != null) {
                    this.mListener.setConnectionId(ObexHelper.convertToLong(request.mConnectionID));
                } else {
                    this.mListener.setConnectionId(1L);
                }
                if (request.mAuthResp != null) {
                    if (!this.handleAuthResp(request.mAuthResp)) {
                        code = 193;
                        this.mListener.onAuthenticationFailure(ObexHelper.getTagValue((byte)1, request.mAuthResp));
                    }
                    request.mAuthResp = null;
                }
            }
            if (code != 193) {
                if (request.mAuthChall != null) {
                    this.handleAuthChall(request);
                    reply.mAuthResp = new byte[request.mAuthResp.length];
                    System.arraycopy(request.mAuthResp, 0, reply.mAuthResp, 0, reply.mAuthResp.length);
                    request.mAuthChall = null;
                    request.mAuthResp = null;
                }
                boolean backup = false;
                boolean create = true;
                if ((flags & 1) != 0) {
                    backup = true;
                }
                if ((flags & 2) != 0) {
                    create = false;
                }
                try {
                    code = this.mListener.onSetPath(request, reply, backup, create);
                }
                catch (Exception e) {
                    this.sendResponse(208, null);
                    return;
                }
                code = this.validateResponseCode(code);
                if (reply.nonce != null) {
                    this.mChallengeDigest = new byte[16];
                    System.arraycopy(reply.nonce, 0, this.mChallengeDigest, 0, 16);
                } else {
                    this.mChallengeDigest = null;
                }
                long id2 = this.mListener.getConnectionId();
                reply.mConnectionID = (byte[])(id2 == -1L ? null : ObexHelper.convertToByteArray(id2));
                head = ObexHelper.createHeader(reply, false);
                if ((totalLength += head.length) > this.mMaxPacketLength) {
                    totalLength = 3;
                    head = null;
                    code = 208;
                }
            }
        }
        byte[] replyData = new byte[totalLength];
        replyData[0] = (byte)code;
        replyData[1] = (byte)(totalLength >> 8);
        replyData[2] = (byte)totalLength;
        if (head != null) {
            System.arraycopy(head, 0, replyData, 3, head.length);
        }
        this.mOutput.write(replyData);
        this.mOutput.flush();
    }

    private void handleDisconnectRequest() throws IOException {
        int code = 160;
        int totalLength = 3;
        byte[] head = null;
        HeaderSet request = new HeaderSet();
        HeaderSet reply = new HeaderSet();
        int length = this.mInput.read();
        if ((length = (length << 8) + this.mInput.read()) > 65534) {
            code = 206;
            totalLength = 3;
        } else {
            if (length > 3) {
                byte[] headers = new byte[length - 3];
                for (int bytesReceived = this.mInput.read(headers); bytesReceived != headers.length; bytesReceived += this.mInput.read(headers, bytesReceived, headers.length - bytesReceived)) {
                }
                ObexHelper.updateHeaderSet(request, headers);
            }
            if (this.mListener.getConnectionId() != -1L && request.mConnectionID != null) {
                this.mListener.setConnectionId(ObexHelper.convertToLong(request.mConnectionID));
            } else {
                this.mListener.setConnectionId(1L);
            }
            if (request.mAuthResp != null) {
                if (!this.handleAuthResp(request.mAuthResp)) {
                    code = 193;
                    this.mListener.onAuthenticationFailure(ObexHelper.getTagValue((byte)1, request.mAuthResp));
                }
                request.mAuthResp = null;
            }
            if (code != 193) {
                if (request.mAuthChall != null) {
                    this.handleAuthChall(request);
                    request.mAuthChall = null;
                }
                try {
                    this.mListener.onDisconnect(request, reply);
                }
                catch (Exception e) {
                    this.sendResponse(208, null);
                    return;
                }
                long id2 = this.mListener.getConnectionId();
                reply.mConnectionID = (byte[])(id2 == -1L ? null : ObexHelper.convertToByteArray(id2));
                head = ObexHelper.createHeader(reply, false);
                if ((totalLength += head.length) > this.mMaxPacketLength) {
                    totalLength = 3;
                    head = null;
                    code = 208;
                }
            }
        }
        byte[] replyData = head != null ? new byte[3 + head.length] : new byte[]{(byte)code, (byte)(totalLength >> 8), (byte)totalLength};
        if (head != null) {
            System.arraycopy(head, 0, replyData, 3, head.length);
        }
        this.mOutput.write(replyData);
        this.mOutput.flush();
    }

    private void handleConnectRequest() throws IOException {
        int totalLength = 7;
        byte[] head = null;
        int code = -1;
        HeaderSet request = new HeaderSet();
        HeaderSet reply = new HeaderSet();
        int packetLength = this.mInput.read();
        packetLength = (packetLength << 8) + this.mInput.read();
        int version = this.mInput.read();
        int flags = this.mInput.read();
        this.mMaxPacketLength = this.mInput.read();
        this.mMaxPacketLength = (this.mMaxPacketLength << 8) + this.mInput.read();
        if (this.mMaxPacketLength > 65534) {
            this.mMaxPacketLength = 65534;
        }
        if (packetLength > 65534) {
            code = 206;
            totalLength = 7;
        } else {
            if (packetLength > 7) {
                byte[] headers = new byte[packetLength - 7];
                for (int bytesReceived = this.mInput.read(headers); bytesReceived != headers.length; bytesReceived += this.mInput.read(headers, bytesReceived, headers.length - bytesReceived)) {
                }
                ObexHelper.updateHeaderSet(request, headers);
            }
            if (this.mListener.getConnectionId() != -1L && request.mConnectionID != null) {
                this.mListener.setConnectionId(ObexHelper.convertToLong(request.mConnectionID));
            } else {
                this.mListener.setConnectionId(1L);
            }
            if (request.mAuthResp != null) {
                if (!this.handleAuthResp(request.mAuthResp)) {
                    code = 193;
                    this.mListener.onAuthenticationFailure(ObexHelper.getTagValue((byte)1, request.mAuthResp));
                }
                request.mAuthResp = null;
            }
            if (code != 193) {
                if (request.mAuthChall != null) {
                    this.handleAuthChall(request);
                    reply.mAuthResp = new byte[request.mAuthResp.length];
                    System.arraycopy(request.mAuthResp, 0, reply.mAuthResp, 0, reply.mAuthResp.length);
                    request.mAuthChall = null;
                    request.mAuthResp = null;
                }
                try {
                    code = this.mListener.onConnect(request, reply);
                    code = this.validateResponseCode(code);
                    if (reply.nonce != null) {
                        this.mChallengeDigest = new byte[16];
                        System.arraycopy(reply.nonce, 0, this.mChallengeDigest, 0, 16);
                    } else {
                        this.mChallengeDigest = null;
                    }
                    long id2 = this.mListener.getConnectionId();
                    reply.mConnectionID = (byte[])(id2 == -1L ? null : ObexHelper.convertToByteArray(id2));
                    head = ObexHelper.createHeader(reply, false);
                    if ((totalLength += head.length) > this.mMaxPacketLength) {
                        totalLength = 7;
                        head = null;
                        code = 208;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    totalLength = 7;
                    head = null;
                    code = 208;
                }
            }
        }
        byte[] length = ObexHelper.convertToByteArray(totalLength);
        byte[] sendData = new byte[totalLength];
        sendData[0] = (byte)code;
        sendData[1] = length[2];
        sendData[2] = length[3];
        sendData[3] = 16;
        sendData[4] = 0;
        sendData[5] = -1;
        sendData[6] = -2;
        if (head != null) {
            System.arraycopy(head, 0, sendData, 7, head.length);
        }
        this.mOutput.write(sendData);
        this.mOutput.flush();
    }

    public synchronized void close() {
        if (this.mListener != null) {
            this.mListener.onClose();
        }
        try {
            this.mInput.close();
            this.mOutput.close();
            this.mTransport.close();
            this.mClosed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mTransport = null;
        this.mInput = null;
        this.mOutput = null;
        this.mListener = null;
    }

    private int validateResponseCode(int code) {
        if (code >= 160 && code <= 166) {
            return code;
        }
        if (code >= 176 && code <= 181) {
            return code;
        }
        if (code >= 192 && code <= 207) {
            return code;
        }
        if (code >= 208 && code <= 213) {
            return code;
        }
        if (code >= 224 && code <= 225) {
            return code;
        }
        return 208;
    }
}

