/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.FactoryFinder;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class DatatypeFactory {
    public static final String DATATYPEFACTORY_PROPERTY = "javax.xml.datatype.DatatypeFactory";
    public static final String DATATYPEFACTORY_IMPLEMENTATION_CLASS = new String("org.apache.xerces.jaxp.datatype.DatatypeFactoryImpl");

    protected DatatypeFactory() {
    }

    public static DatatypeFactory newInstance() throws DatatypeConfigurationException {
        try {
            return (DatatypeFactory)FactoryFinder.find(DATATYPEFACTORY_PROPERTY, DATATYPEFACTORY_IMPLEMENTATION_CLASS);
        }
        catch (FactoryFinder.ConfigurationError e) {
            throw new DatatypeConfigurationException(e.getMessage(), e.getException());
        }
    }

    public static DatatypeFactory newInstance(String factoryClassName, ClassLoader classLoader) throws DatatypeConfigurationException {
        if (factoryClassName == null) {
            throw new DatatypeConfigurationException("factoryClassName == null");
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            Class<?> type = classLoader != null ? classLoader.loadClass(factoryClassName) : Class.forName(factoryClassName);
            return (DatatypeFactory)type.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new DatatypeConfigurationException(e);
        }
        catch (InstantiationException e) {
            throw new DatatypeConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new DatatypeConfigurationException(e);
        }
    }

    public abstract Duration newDuration(String var1);

    public abstract Duration newDuration(long var1);

    public abstract Duration newDuration(boolean var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5, BigInteger var6, BigDecimal var7);

    public Duration newDuration(boolean isPositive, int years, int months, int days, int hours, int minutes, int seconds) {
        BigInteger realYears = years != Integer.MIN_VALUE ? BigInteger.valueOf(years) : null;
        BigInteger realMonths = months != Integer.MIN_VALUE ? BigInteger.valueOf(months) : null;
        BigInteger realDays = days != Integer.MIN_VALUE ? BigInteger.valueOf(days) : null;
        BigInteger realHours = hours != Integer.MIN_VALUE ? BigInteger.valueOf(hours) : null;
        BigInteger realMinutes = minutes != Integer.MIN_VALUE ? BigInteger.valueOf(minutes) : null;
        BigDecimal realSeconds = seconds != Integer.MIN_VALUE ? BigDecimal.valueOf(seconds) : null;
        return this.newDuration(isPositive, realYears, realMonths, realDays, realHours, realMinutes, realSeconds);
    }

    public Duration newDurationDayTime(String lexicalRepresentation) {
        if (lexicalRepresentation == null) {
            throw new NullPointerException("lexicalRepresentation == null");
        }
        int pos = lexicalRepresentation.indexOf(84);
        int length = pos >= 0 ? pos : lexicalRepresentation.length();
        for (int i = 0; i < length; ++i) {
            char c = lexicalRepresentation.charAt(i);
            if (c != 'Y' && c != 'M') continue;
            throw new IllegalArgumentException("Invalid dayTimeDuration value: " + lexicalRepresentation);
        }
        return this.newDuration(lexicalRepresentation);
    }

    public Duration newDurationDayTime(long durationInMilliseconds) {
        boolean isPositive;
        long _durationInMilliseconds = durationInMilliseconds;
        if (_durationInMilliseconds == 0L) {
            return this.newDuration(true, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0);
        }
        boolean tooLong = false;
        if (_durationInMilliseconds < 0L) {
            isPositive = false;
            if (_durationInMilliseconds == Long.MIN_VALUE) {
                ++_durationInMilliseconds;
                tooLong = true;
            }
            _durationInMilliseconds *= -1L;
        } else {
            isPositive = true;
        }
        long val = _durationInMilliseconds;
        int milliseconds = (int)(val % 60000L);
        if (tooLong) {
            ++milliseconds;
        }
        if (milliseconds % 1000 == 0) {
            int seconds = milliseconds / 1000;
            int minutes = (int)((val /= 60000L) % 60L);
            int hours = (int)((val /= 60L) % 24L);
            long days = val / 24L;
            if (days <= Integer.MAX_VALUE) {
                return this.newDuration(isPositive, Integer.MIN_VALUE, Integer.MIN_VALUE, (int)days, hours, minutes, seconds);
            }
            return this.newDuration(isPositive, null, null, BigInteger.valueOf(days), BigInteger.valueOf(hours), BigInteger.valueOf(minutes), BigDecimal.valueOf(milliseconds, 3));
        }
        BigDecimal seconds = BigDecimal.valueOf(milliseconds, 3);
        BigInteger minutes = BigInteger.valueOf((val /= 60000L) % 60L);
        BigInteger hours = BigInteger.valueOf((val /= 60L) % 24L);
        BigInteger days = BigInteger.valueOf(val /= 24L);
        return this.newDuration(isPositive, null, null, days, hours, minutes, seconds);
    }

    public Duration newDurationDayTime(boolean isPositive, BigInteger day, BigInteger hour, BigInteger minute, BigInteger second) {
        return this.newDuration(isPositive, null, null, day, hour, minute, second != null ? new BigDecimal(second) : null);
    }

    public Duration newDurationDayTime(boolean isPositive, int day, int hour, int minute, int second) {
        return this.newDuration(isPositive, Integer.MIN_VALUE, Integer.MIN_VALUE, day, hour, minute, second);
    }

    public Duration newDurationYearMonth(String lexicalRepresentation) {
        if (lexicalRepresentation == null) {
            throw new NullPointerException("lexicalRepresentation == null");
        }
        int length = lexicalRepresentation.length();
        for (int i = 0; i < length; ++i) {
            char c = lexicalRepresentation.charAt(i);
            if (c != 'D' && c != 'T') continue;
            throw new IllegalArgumentException("Invalid yearMonthDuration value: " + lexicalRepresentation);
        }
        return this.newDuration(lexicalRepresentation);
    }

    public Duration newDurationYearMonth(long durationInMilliseconds) {
        return this.newDuration(durationInMilliseconds);
    }

    public Duration newDurationYearMonth(boolean isPositive, BigInteger year, BigInteger month) {
        return this.newDuration(isPositive, year, month, null, null, null, null);
    }

    public Duration newDurationYearMonth(boolean isPositive, int year, int month) {
        return this.newDuration(isPositive, year, month, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public abstract XMLGregorianCalendar newXMLGregorianCalendar();

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(String var1);

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(GregorianCalendar var1);

    public abstract XMLGregorianCalendar newXMLGregorianCalendar(BigInteger var1, int var2, int var3, int var4, int var5, int var6, BigDecimal var7, int var8);

    public XMLGregorianCalendar newXMLGregorianCalendar(int year, int month, int day, int hour, int minute, int second, int millisecond, int timezone) {
        BigInteger realYear = year != Integer.MIN_VALUE ? BigInteger.valueOf(year) : null;
        BigDecimal realMillisecond = null;
        if (millisecond != Integer.MIN_VALUE) {
            if (millisecond < 0 || millisecond > 1000) {
                throw new IllegalArgumentException("javax.xml.datatype.DatatypeFactory#newXMLGregorianCalendar(int year, int month, int day, int hour, int minute, int second, int millisecond, int timezone)with invalid millisecond: " + millisecond);
            }
            realMillisecond = BigDecimal.valueOf(millisecond, 3);
        }
        return this.newXMLGregorianCalendar(realYear, month, day, hour, minute, second, realMillisecond, timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarDate(int year, int month, int day, int timezone) {
        return this.newXMLGregorianCalendar(year, month, day, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int hours, int minutes, int seconds, int timezone) {
        return this.newXMLGregorianCalendar(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, hours, minutes, seconds, Integer.MIN_VALUE, timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int hours, int minutes, int seconds, BigDecimal fractionalSecond, int timezone) {
        return this.newXMLGregorianCalendar(null, Integer.MIN_VALUE, Integer.MIN_VALUE, hours, minutes, seconds, fractionalSecond, timezone);
    }

    public XMLGregorianCalendar newXMLGregorianCalendarTime(int hours, int minutes, int seconds, int milliseconds, int timezone) {
        BigDecimal realMilliseconds = null;
        if (milliseconds != Integer.MIN_VALUE) {
            if (milliseconds < 0 || milliseconds > 1000) {
                throw new IllegalArgumentException("javax.xml.datatype.DatatypeFactory#newXMLGregorianCalendarTime(int hours, int minutes, int seconds, int milliseconds, int timezone)with invalid milliseconds: " + milliseconds);
            }
            realMilliseconds = BigDecimal.valueOf(milliseconds, 3);
        }
        return this.newXMLGregorianCalendarTime(hours, minutes, seconds, realMilliseconds, timezone);
    }
}

