/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.runner.ClassPathTestCollector;
import junit.runner.TestCaseClassLoader;

public class LoadingTestCollector
extends ClassPathTestCollector {
    TestCaseClassLoader fLoader = new TestCaseClassLoader();

    protected boolean isTestClass(String classFileName) {
        try {
            if (classFileName.endsWith(".class")) {
                Class testClass = this.classFromFile(classFileName);
                return testClass != null && this.isTestClass(testClass);
            }
        }
        catch (ClassNotFoundException expected) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    Class classFromFile(String classFileName) throws ClassNotFoundException {
        String className = this.classNameFromFile(classFileName);
        if (!this.fLoader.isExcluded(className)) {
            return this.fLoader.loadClass(className, false);
        }
        return null;
    }

    boolean isTestClass(Class testClass) {
        if (this.hasSuiteMethod(testClass)) {
            return true;
        }
        return Test.class.isAssignableFrom(testClass) && Modifier.isPublic(testClass.getModifiers()) && this.hasPublicConstructor(testClass);
    }

    boolean hasSuiteMethod(Class testClass) {
        try {
            testClass.getMethod("suite", new Class[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    boolean hasPublicConstructor(Class testClass) {
        try {
            TestSuite.getTestConstructor(testClass);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }
}

