/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.provider.crypto;

import dalvik.system.BlockGuard;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.ProviderException;
import java.security.SecureRandomSpi;
import libcore.io.Streams;
import libcore.util.EmptyArray;
import org.apache.harmony.security.provider.crypto.SHA1Impl;

public class SHA1PRNG_SecureRandomImpl
extends SecureRandomSpi
implements Serializable {
    private static final long serialVersionUID = 283736797212159675L;
    private static FileInputStream devURandom;
    private static final int[] END_FLAGS;
    private static final int[] RIGHT1;
    private static final int[] RIGHT2;
    private static final int[] LEFT;
    private static final int[] MASK;
    private static final int HASHBYTES_TO_USE = 20;
    private static final int FRAME_LENGTH = 16;
    private static final int COUNTER_BASE = 0;
    private static final int HASHCOPY_OFFSET = 0;
    private static final int EXTRAFRAME_OFFSET = 5;
    private static final int FRAME_OFFSET = 21;
    private static final int MAX_BYTES = 48;
    private static final int UNDEFINED = 0;
    private static final int SET_SEED = 1;
    private static final int NEXT_BYTES = 2;
    private static SHA1PRNG_SecureRandomImpl myRandom;
    private transient int[] seed = new int[87];
    private transient long seedLength;
    private transient int[] copies;
    private transient byte[] nextBytes;
    private transient int nextBIndex;
    private transient long counter;
    private transient int state;

    public SHA1PRNG_SecureRandomImpl() {
        this.seed[82] = 1732584193;
        this.seed[83] = -271733879;
        this.seed[84] = -1732584194;
        this.seed[85] = 271733878;
        this.seed[86] = -1009589776;
        this.seedLength = 0L;
        this.copies = new int[37];
        this.nextBytes = new byte[20];
        this.nextBIndex = 20;
        this.counter = 0L;
        this.state = 0;
    }

    private void updateSeed(byte[] bytes) {
        SHA1Impl.updateHash(this.seed, bytes, 0, bytes.length - 1);
        this.seedLength += (long)bytes.length;
    }

    protected synchronized void engineSetSeed(byte[] seed) {
        if (seed == null) {
            throw new NullPointerException("seed == null");
        }
        if (this.state == 2) {
            System.arraycopy(this.copies, 0, this.seed, 82, 5);
        }
        this.state = 1;
        if (seed.length != 0) {
            this.updateSeed(seed);
        }
    }

    protected synchronized byte[] engineGenerateSeed(int numBytes) {
        if (numBytes < 0) {
            throw new NegativeArraySizeException(Integer.toString(numBytes));
        }
        if (numBytes == 0) {
            return EmptyArray.BYTE;
        }
        if (myRandom == null) {
            myRandom = new SHA1PRNG_SecureRandomImpl();
            myRandom.engineSetSeed(SHA1PRNG_SecureRandomImpl.getRandomBytes(20));
        }
        byte[] myBytes = new byte[numBytes];
        myRandom.engineNextBytes(myBytes);
        return myBytes;
    }

    protected synchronized void engineNextBytes(byte[] bytes) {
        int n;
        int i;
        int lastWord;
        int extrabytes = 7;
        if (bytes == null) {
            throw new NullPointerException("bytes == null");
        }
        int n2 = lastWord = this.seed[81] == 0 ? 0 : this.seed[81] + 7 >> 2;
        if (this.state == 0) {
            this.updateSeed(SHA1PRNG_SecureRandomImpl.getRandomBytes(20));
            this.nextBIndex = 20;
            lastWord = this.seed[81] == 0 ? 0 : this.seed[81] + 7 >> 2;
        } else if (this.state == 1) {
            System.arraycopy(this.seed, 82, this.copies, 0, 5);
            for (i = lastWord + 3; i < 18; ++i) {
                this.seed[i] = 0;
            }
            long bits = (this.seedLength << 3) + 64L;
            if (this.seed[81] < 48) {
                this.seed[14] = (int)(bits >>> 32);
                this.seed[15] = (int)(bits & 0xFFFFFFFFFFFFFFFFL);
            } else {
                this.copies[19] = (int)(bits >>> 32);
                this.copies[20] = (int)(bits & 0xFFFFFFFFFFFFFFFFL);
            }
            this.nextBIndex = 20;
        }
        this.state = 2;
        if (bytes.length == 0) {
            return;
        }
        int nextByteToReturn = 0;
        int n3 = n = 20 - this.nextBIndex < bytes.length - nextByteToReturn ? 20 - this.nextBIndex : bytes.length - nextByteToReturn;
        if (n > 0) {
            System.arraycopy(this.nextBytes, this.nextBIndex, bytes, nextByteToReturn, n);
            this.nextBIndex += n;
            nextByteToReturn += n;
        }
        if (nextByteToReturn >= bytes.length) {
            return;
        }
        n = this.seed[81] & 3;
        do {
            if (n == 0) {
                this.seed[lastWord] = (int)(this.counter >>> 32);
                this.seed[lastWord + 1] = (int)(this.counter & 0xFFFFFFFFFFFFFFFFL);
                this.seed[lastWord + 2] = END_FLAGS[0];
            } else {
                int n4 = lastWord;
                this.seed[n4] = this.seed[n4] | (int)(this.counter >>> RIGHT1[n] & (long)MASK[n]);
                this.seed[lastWord + 1] = (int)(this.counter >>> RIGHT2[n] & 0xFFFFFFFFFFFFFFFFL);
                this.seed[lastWord + 2] = (int)(this.counter << LEFT[n] | (long)END_FLAGS[n]);
            }
            if (this.seed[81] > 48) {
                this.copies[5] = this.seed[16];
                this.copies[6] = this.seed[17];
            }
            SHA1Impl.computeHash(this.seed);
            if (this.seed[81] > 48) {
                System.arraycopy(this.seed, 0, this.copies, 21, 16);
                System.arraycopy(this.copies, 5, this.seed, 0, 16);
                SHA1Impl.computeHash(this.seed);
                System.arraycopy(this.copies, 21, this.seed, 0, 16);
            }
            ++this.counter;
            int j = 0;
            for (i = 0; i < 5; ++i) {
                int k = this.seed[82 + i];
                this.nextBytes[j] = (byte)(k >>> 24);
                this.nextBytes[j + 1] = (byte)(k >>> 16);
                this.nextBytes[j + 2] = (byte)(k >>> 8);
                this.nextBytes[j + 3] = (byte)k;
                j += 4;
            }
            this.nextBIndex = 0;
            int n5 = j = 20 < bytes.length - nextByteToReturn ? 20 : bytes.length - nextByteToReturn;
            if (j <= 0) continue;
            System.arraycopy(this.nextBytes, 0, bytes, nextByteToReturn, j);
            nextByteToReturn += j;
            this.nextBIndex += j;
        } while (nextByteToReturn < bytes.length);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int[] intData = null;
        int only_hash = 5;
        int hashes_and_frame = 26;
        int hashes_and_frame_extra = 42;
        oos.writeLong(this.seedLength);
        oos.writeLong(this.counter);
        oos.writeInt(this.state);
        oos.writeInt(this.seed[81]);
        int nRemaining = this.seed[81] + 3 >> 2;
        if (this.state != 2) {
            intData = new int[5 + nRemaining];
            System.arraycopy(this.seed, 0, intData, 0, nRemaining);
            System.arraycopy(this.seed, 82, intData, nRemaining, 5);
        } else {
            int offset = 0;
            if (this.seed[81] < 48) {
                intData = new int[26 + nRemaining];
            } else {
                intData = new int[42 + nRemaining];
                intData[offset] = this.seed[16];
                intData[offset + 1] = this.seed[17];
                intData[offset + 2] = this.seed[30];
                intData[offset + 3] = this.seed[31];
                offset += 4;
            }
            System.arraycopy(this.seed, 0, intData, offset, 16);
            System.arraycopy(this.copies, 21, intData, offset += 16, nRemaining);
            System.arraycopy(this.copies, 0, intData, offset += nRemaining, 5);
            System.arraycopy(this.seed, 82, intData, offset += 5, 5);
        }
        for (int i = 0; i < intData.length; ++i) {
            oos.writeInt(intData[i]);
        }
        oos.writeInt(this.nextBIndex);
        oos.write(this.nextBytes, this.nextBIndex, 20 - this.nextBIndex);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.seed = new int[87];
        this.copies = new int[37];
        this.nextBytes = new byte[20];
        this.seedLength = ois.readLong();
        this.counter = ois.readLong();
        this.state = ois.readInt();
        this.seed[81] = ois.readInt();
        int nRemaining = this.seed[81] + 3 >> 2;
        if (this.state != 2) {
            int i;
            for (i = 0; i < nRemaining; ++i) {
                this.seed[i] = ois.readInt();
            }
            for (i = 0; i < 5; ++i) {
                this.seed[82 + i] = ois.readInt();
            }
        } else {
            int i;
            if (this.seed[81] >= 48) {
                this.seed[16] = ois.readInt();
                this.seed[17] = ois.readInt();
                this.seed[30] = ois.readInt();
                this.seed[31] = ois.readInt();
            }
            for (i = 0; i < 16; ++i) {
                this.seed[i] = ois.readInt();
            }
            for (i = 0; i < nRemaining; ++i) {
                this.copies[21 + i] = ois.readInt();
            }
            for (i = 0; i < 5; ++i) {
                this.copies[i] = ois.readInt();
            }
            for (i = 0; i < 5; ++i) {
                this.seed[82 + i] = ois.readInt();
            }
        }
        this.nextBIndex = ois.readInt();
        Streams.readFully(ois, this.nextBytes, this.nextBIndex, 20 - this.nextBIndex);
    }

    private static byte[] getRandomBytes(int byteCount) {
        byte[] byArray;
        if (byteCount <= 0) {
            throw new IllegalArgumentException("Too few bytes requested: " + byteCount);
        }
        BlockGuard.Policy originalPolicy = BlockGuard.getThreadPolicy();
        try {
            BlockGuard.setThreadPolicy(BlockGuard.LAX_POLICY);
            byte[] result = new byte[byteCount];
            Streams.readFully(devURandom, result, 0, byteCount);
            byArray = result;
            Object var5_5 = null;
        }
        catch (Exception ex) {
            try {
                throw new ProviderException("Couldn't read " + byteCount + " random bytes", ex);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                BlockGuard.setThreadPolicy(originalPolicy);
                throw throwable;
            }
        }
        BlockGuard.setThreadPolicy(originalPolicy);
        return byArray;
    }

    static {
        try {
            devURandom = new FileInputStream(new File("/dev/urandom"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        END_FLAGS = new int[]{Integer.MIN_VALUE, 0x800000, 32768, 128};
        RIGHT1 = new int[]{0, 40, 48, 56};
        RIGHT2 = new int[]{0, 8, 16, 24};
        LEFT = new int[]{0, 24, 16, 8};
        MASK = new int[]{-1, 0xFFFFFF, 65535, 255};
    }
}

