/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml.dom;

import java.util.ArrayList;
import java.util.List;
import libcore.util.Objects;
import org.apache.harmony.xml.dom.DocumentImpl;
import org.apache.harmony.xml.dom.ElementImpl;
import org.apache.harmony.xml.dom.LeafNodeImpl;
import org.apache.harmony.xml.dom.NodeImpl;
import org.apache.harmony.xml.dom.NodeListImpl;
import org.apache.harmony.xml.dom.TextImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class InnerNodeImpl
extends LeafNodeImpl {
    List<LeafNodeImpl> children = new ArrayList<LeafNodeImpl>();

    protected InnerNodeImpl(DocumentImpl document) {
        super(document);
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.insertChildAt(newChild, this.children.size());
    }

    public NodeList getChildNodes() {
        NodeListImpl list = new NodeListImpl();
        for (LeafNodeImpl node : this.children) {
            list.add(node);
        }
        return list;
    }

    public Node getFirstChild() {
        return !this.children.isEmpty() ? this.children.get(0) : null;
    }

    public Node getLastChild() {
        return !this.children.isEmpty() ? this.children.get(this.children.size() - 1) : null;
    }

    public Node getNextSibling() {
        if (this.parent == null || this.index + 1 >= this.parent.children.size()) {
            return null;
        }
        return this.parent.children.get(this.index + 1);
    }

    public boolean hasChildNodes() {
        return this.children.size() != 0;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        LeafNodeImpl refChildImpl = (LeafNodeImpl)refChild;
        if (refChildImpl == null) {
            return this.appendChild(newChild);
        }
        if (refChildImpl.document != this.document) {
            throw new DOMException(4, null);
        }
        if (refChildImpl.parent != this) {
            throw new DOMException(3, null);
        }
        return this.insertChildAt(newChild, refChildImpl.index);
    }

    Node insertChildAt(Node newChild, int index) throws DOMException {
        if (newChild instanceof DocumentFragment) {
            NodeList toAdd = newChild.getChildNodes();
            for (int i = 0; i < toAdd.getLength(); ++i) {
                this.insertChildAt(toAdd.item(i), index + i);
            }
            return newChild;
        }
        LeafNodeImpl toInsert = (LeafNodeImpl)newChild;
        if (toInsert.document != null && this.document != null && toInsert.document != this.document) {
            throw new DOMException(4, null);
        }
        if (toInsert.isParentOf(this)) {
            throw new DOMException(3, null);
        }
        if (toInsert.parent != null) {
            int oldIndex = toInsert.index;
            toInsert.parent.children.remove(oldIndex);
            toInsert.parent.refreshIndices(oldIndex);
        }
        this.children.add(index, toInsert);
        toInsert.parent = this;
        this.refreshIndices(index);
        return newChild;
    }

    public boolean isParentOf(Node node) {
        LeafNodeImpl nodeImpl = (LeafNodeImpl)node;
        while (nodeImpl != null) {
            if (nodeImpl == this) {
                return true;
            }
            nodeImpl = nodeImpl.parent;
        }
        return false;
    }

    public final void normalize() {
        Node node = this.getFirstChild();
        while (node != null) {
            Node next = node.getNextSibling();
            node.normalize();
            if (node.getNodeType() == 3) {
                ((TextImpl)node).minimize();
            }
            node = next;
        }
    }

    private void refreshIndices(int fromIndex) {
        for (int i = fromIndex; i < this.children.size(); ++i) {
            this.children.get((int)i).index = i;
        }
    }

    public Node removeChild(Node oldChild) throws DOMException {
        LeafNodeImpl oldChildImpl = (LeafNodeImpl)oldChild;
        if (oldChildImpl.document != this.document) {
            throw new DOMException(4, null);
        }
        if (oldChildImpl.parent != this) {
            throw new DOMException(3, null);
        }
        int index = oldChildImpl.index;
        this.children.remove(index);
        oldChildImpl.parent = null;
        this.refreshIndices(index);
        return oldChild;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        int index = ((LeafNodeImpl)oldChild).index;
        this.removeChild(oldChild);
        this.insertChildAt(newChild, index);
        return oldChild;
    }

    public String getTextContent() throws DOMException {
        Node child = this.getFirstChild();
        if (child == null) {
            return "";
        }
        Node next = child.getNextSibling();
        if (next == null) {
            return this.hasTextContent(child) ? child.getTextContent() : "";
        }
        StringBuilder buf = new StringBuilder();
        this.getTextContent(buf);
        return buf.toString();
    }

    void getTextContent(StringBuilder buf) throws DOMException {
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!this.hasTextContent(child)) continue;
            ((NodeImpl)child).getTextContent(buf);
        }
    }

    final boolean hasTextContent(Node child) {
        return child.getNodeType() != 8 && child.getNodeType() != 7;
    }

    void getElementsByTagName(NodeListImpl out, String name) {
        for (LeafNodeImpl node : this.children) {
            if (node.getNodeType() != 1) continue;
            ElementImpl element = (ElementImpl)node;
            if (InnerNodeImpl.matchesNameOrWildcard(name, element.getNodeName())) {
                out.add(element);
            }
            element.getElementsByTagName(out, name);
        }
    }

    void getElementsByTagNameNS(NodeListImpl out, String namespaceURI, String localName) {
        for (LeafNodeImpl node : this.children) {
            if (node.getNodeType() != 1) continue;
            ElementImpl element = (ElementImpl)node;
            if (InnerNodeImpl.matchesNameOrWildcard(namespaceURI, element.getNamespaceURI()) && InnerNodeImpl.matchesNameOrWildcard(localName, element.getLocalName())) {
                out.add(element);
            }
            element.getElementsByTagNameNS(out, namespaceURI, localName);
        }
    }

    private static boolean matchesNameOrWildcard(String pattern, String s) {
        return "*".equals(pattern) || Objects.equal(pattern, s);
    }
}

