/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.conn.ConnectionReleaseTrigger;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.http.conn.EofSensorWatcher;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.entity.HttpEntityWrapper;

public class BasicManagedEntity
extends HttpEntityWrapper
implements ConnectionReleaseTrigger,
EofSensorWatcher {
    protected ManagedClientConnection managedConn;
    protected final boolean attemptReuse;

    public BasicManagedEntity(HttpEntity entity, ManagedClientConnection conn, boolean reuse) {
        super(entity);
        if (conn == null) {
            throw new IllegalArgumentException("Connection may not be null.");
        }
        this.managedConn = conn;
        this.attemptReuse = reuse;
    }

    public boolean isRepeatable() {
        return false;
    }

    public InputStream getContent() throws IOException {
        return new EofSensorInputStream(this.wrappedEntity.getContent(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeContent() throws IOException {
        if (this.managedConn == null) {
            return;
        }
        try {
            if (this.attemptReuse) {
                this.wrappedEntity.consumeContent();
                this.managedConn.markReusable();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseManagedConnection();
            throw throwable;
        }
        this.releaseManagedConnection();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        super.writeTo(outstream);
        this.consumeContent();
    }

    public void releaseConnection() throws IOException {
        this.consumeContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortConnection() throws IOException {
        if (this.managedConn != null) {
            try {
                this.managedConn.abortConnection();
                Object var2_1 = null;
                this.managedConn = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.managedConn = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean eofDetected(InputStream wrapped) throws IOException {
        try {
            if (this.attemptReuse && this.managedConn != null) {
                wrapped.close();
                this.managedConn.markReusable();
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseManagedConnection();
            throw throwable;
        }
        this.releaseManagedConnection();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean streamClosed(InputStream wrapped) throws IOException {
        try {
            if (this.attemptReuse && this.managedConn != null) {
                wrapped.close();
                this.managedConn.markReusable();
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseManagedConnection();
            throw throwable;
        }
        this.releaseManagedConnection();
        return false;
    }

    public boolean streamAbort(InputStream wrapped) throws IOException {
        if (this.managedConn != null) {
            this.managedConn.abortConnection();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseManagedConnection() throws IOException {
        if (this.managedConn != null) {
            try {
                this.managedConn.releaseConnection();
                Object var2_1 = null;
                this.managedConn = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.managedConn = null;
                throw throwable;
            }
        }
    }
}

