/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import com.android.org.conscrypt.NativeCrypto;
import org.bouncycastle.crypto.ExtendedDigest;

public class OpenSSLDigest
implements ExtendedDigest {
    private final String algorithm;
    private final long evp_md;
    private final int size;
    private final int blockSize;
    private long ctx;
    private final byte[] singleByte = new byte[1];

    private OpenSSLDigest(String algorithm, long evp_md, int size, int blockSize) {
        this.algorithm = algorithm;
        this.evp_md = evp_md;
        this.size = size;
        this.blockSize = blockSize;
    }

    public String getAlgorithmName() {
        return this.algorithm;
    }

    public int getDigestSize() {
        return this.size;
    }

    public int getByteLength() {
        return this.blockSize;
    }

    public void reset() {
        this.free();
    }

    public void update(byte in) {
        this.singleByte[0] = in;
        this.update(this.singleByte, 0, 1);
    }

    public void update(byte[] in, int inOff, int len) {
        NativeCrypto.EVP_DigestUpdate((long)this.getCtx(), (byte[])in, (int)inOff, (int)len);
    }

    public int doFinal(byte[] out, int outOff) {
        int i = NativeCrypto.EVP_DigestFinal((long)this.getCtx(), (byte[])out, (int)outOff);
        this.ctx = 0L;
        this.reset();
        return i;
    }

    private long getCtx() {
        if (this.ctx == 0L) {
            this.ctx = NativeCrypto.EVP_DigestInit((long)this.evp_md);
        }
        return this.ctx;
    }

    private void free() {
        if (this.ctx != 0L) {
            NativeCrypto.EVP_MD_CTX_destroy((long)this.ctx);
            this.ctx = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.free();
        }
        finally {
            super.finalize();
        }
    }

    public static class SHA512
    extends OpenSSLDigest {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname((String)"sha512");
        private static final int SIZE = NativeCrypto.EVP_MD_size((long)EVP_MD);
        private static final int BLOCK_SIZE = NativeCrypto.EVP_MD_block_size((long)EVP_MD);

        public SHA512() {
            super("SHA-512", EVP_MD, SIZE, BLOCK_SIZE);
        }
    }

    public static class SHA384
    extends OpenSSLDigest {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname((String)"sha384");
        private static final int SIZE = NativeCrypto.EVP_MD_size((long)EVP_MD);
        private static final int BLOCK_SIZE = NativeCrypto.EVP_MD_block_size((long)EVP_MD);

        public SHA384() {
            super("SHA-384", EVP_MD, SIZE, BLOCK_SIZE);
        }
    }

    public static class SHA256
    extends OpenSSLDigest {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname((String)"sha256");
        private static final int SIZE = NativeCrypto.EVP_MD_size((long)EVP_MD);
        private static final int BLOCK_SIZE = NativeCrypto.EVP_MD_block_size((long)EVP_MD);

        public SHA256() {
            super("SHA-256", EVP_MD, SIZE, BLOCK_SIZE);
        }
    }

    public static class SHA224
    extends OpenSSLDigest {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname((String)"sha224");
        private static final int SIZE = NativeCrypto.EVP_MD_size((long)EVP_MD);
        private static final int BLOCK_SIZE = NativeCrypto.EVP_MD_block_size((long)EVP_MD);

        public SHA224() {
            super("SHA-224", EVP_MD, SIZE, BLOCK_SIZE);
        }
    }

    public static class SHA1
    extends OpenSSLDigest {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname((String)"sha1");
        private static final int SIZE = NativeCrypto.EVP_MD_size((long)EVP_MD);
        private static final int BLOCK_SIZE = NativeCrypto.EVP_MD_block_size((long)EVP_MD);

        public SHA1() {
            super("SHA-1", EVP_MD, SIZE, BLOCK_SIZE);
        }
    }

    public static class MD5
    extends OpenSSLDigest {
        private static final long EVP_MD = NativeCrypto.EVP_get_digestbyname((String)"md5");
        private static final int SIZE = NativeCrypto.EVP_MD_size((long)EVP_MD);
        private static final int BLOCK_SIZE = NativeCrypto.EVP_MD_block_size((long)EVP_MD);

        public MD5() {
            super("MD5", EVP_MD, SIZE, BLOCK_SIZE);
        }
    }
}

