/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.AndroidDigestFactory;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertBlacklist {
    private static final String ANDROID_DATA = System.getenv("ANDROID_DATA");
    private static final String BLACKLIST_ROOT = ANDROID_DATA + "/misc/keychain/";
    public static final String DEFAULT_PUBKEY_BLACKLIST_PATH = BLACKLIST_ROOT + "pubkey_blacklist.txt";
    public static final String DEFAULT_SERIAL_BLACKLIST_PATH = BLACKLIST_ROOT + "serial_blacklist.txt";
    private static final Logger logger = Logger.getLogger(CertBlacklist.class.getName());
    public final Set<BigInteger> serialBlacklist;
    public final Set<byte[]> pubkeyBlacklist;

    public CertBlacklist() {
        this(DEFAULT_PUBKEY_BLACKLIST_PATH, DEFAULT_SERIAL_BLACKLIST_PATH);
    }

    public CertBlacklist(String pubkeyBlacklistPath, String serialBlacklistPath) {
        this.serialBlacklist = CertBlacklist.readSerialBlackList(serialBlacklistPath);
        this.pubkeyBlacklist = CertBlacklist.readPublicKeyBlackList(pubkeyBlacklistPath);
    }

    private static boolean isHex(String value) {
        try {
            new BigInteger(value, 16);
            return true;
        }
        catch (NumberFormatException e) {
            logger.log(Level.WARNING, "Could not parse hex value " + value, e);
            return false;
        }
    }

    private static boolean isPubkeyHash(String value) {
        if (value.length() != 40) {
            logger.log(Level.WARNING, "Invalid pubkey hash length: " + value.length());
            return false;
        }
        return CertBlacklist.isHex(value);
    }

    private static String readBlacklist(String path) {
        try {
            return CertBlacklist.readFileAsString(path);
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not read blacklist", e);
        }
        return "";
    }

    private static String readFileAsString(String path) throws IOException {
        return CertBlacklist.readFileAsBytes(path).toString("UTF-8");
    }

    private static ByteArrayOutputStream readFileAsBytes(String path) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        int byteCount;
        byte[] buffer;
        ByteArrayOutputStream bytes;
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(path, "r");
            bytes = new ByteArrayOutputStream((int)f.length());
            buffer = new byte[8192];
            while (true) {
                if ((byteCount = f.read(buffer)) != -1) break block4;
                byteArrayOutputStream = bytes;
                break;
            }
        }
        catch (Throwable throwable) {
            CertBlacklist.closeQuietly(f);
            throw throwable;
        }
        {
            block4: {
                CertBlacklist.closeQuietly(f);
                return byteArrayOutputStream;
            }
            bytes.write(buffer, 0, byteCount);
            continue;
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final Set<BigInteger> readSerialBlackList(String path) {
        HashSet<BigInteger> bl = new HashSet<BigInteger>(Arrays.asList(new BigInteger("077a59bcd53459601ca6907267a6dd1c", 16), new BigInteger("047ecbe9fca55f7bd09eae36e10cae1e", 16), new BigInteger("d8f35f4eb7872b2dab0692e315382fb0", 16), new BigInteger("b0b7133ed096f9b56fae91c874bd3ac0", 16), new BigInteger("9239d5348f40d1695a745470e1f23f43", 16), new BigInteger("e9028b9578e415dc1a710a2b88154447", 16), new BigInteger("d7558fdaf5f1105bb213282b707729a3", 16), new BigInteger("f5c86af36162f13a64f54f6dc9587c06", 16), new BigInteger("392a434f0e07df1f8aa305de34e0c229", 16), new BigInteger("3e75ced46b693021218830ae86a82a71", 16), new BigInteger("864", 16), new BigInteger("827", 16), new BigInteger("31da7", 16)));
        String serialBlacklist = CertBlacklist.readBlacklist(path);
        if (!serialBlacklist.equals("")) {
            for (String value : serialBlacklist.split(",")) {
                try {
                    bl.add(new BigInteger(value, 16));
                }
                catch (NumberFormatException e) {
                    logger.log(Level.WARNING, "Tried to blacklist invalid serial number " + value, e);
                }
            }
        }
        return Collections.unmodifiableSet(bl);
    }

    private static final Set<byte[]> readPublicKeyBlackList(String path) {
        HashSet<byte[]> bl = new HashSet<byte[]>(Arrays.asList("410f36363258f30b347d12ce4863e433437806a8".getBytes(), "ba3e7bd38cd7e1e6b9cd4c219962e59d7a2f4e37".getBytes(), "e23b8d105f87710a68d9248050ebefc627be4ca6".getBytes(), "7b2e16bc39bcd72b456e9f055d1de615b74945db".getBytes(), "e8f91200c65cee16e039b9f883841661635f81c5".getBytes(), "0129bcd5b448ae8d2496d1c3e19723919088e152".getBytes(), "5f3ab33d55007054bc5e3e5553cd8d8465d77c61".getBytes(), "783333c9687df63377efceddd82efa9101913e8e".getBytes(), "3ecf4bbbe46096d514bb539bb913d77aa4ef31bf".getBytes()));
        String pubkeyBlacklist = CertBlacklist.readBlacklist(path);
        if (!pubkeyBlacklist.equals("")) {
            for (String value : pubkeyBlacklist.split(",")) {
                if (CertBlacklist.isPubkeyHash(value = value.trim())) {
                    bl.add(value.getBytes());
                    continue;
                }
                logger.log(Level.WARNING, "Tried to blacklist invalid pubkey " + value);
            }
        }
        return bl;
    }

    public boolean isPublicKeyBlackListed(PublicKey publicKey) {
        byte[] encoded = publicKey.getEncoded();
        Digest digest = AndroidDigestFactory.getSHA1();
        digest.update(encoded, 0, encoded.length);
        byte[] out = new byte[digest.getDigestSize()];
        digest.doFinal(out, 0);
        for (byte[] blacklisted : this.pubkeyBlacklist) {
            if (!Arrays.equals(blacklisted, Hex.encode(out))) continue;
            return true;
        }
        return false;
    }

    public boolean isSerialNumberBlackListed(BigInteger serial) {
        return this.serialBlacklist.contains(serial);
    }
}

