/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.content.Context;
import android.content.SharedPreferences;
import org.chromium.android_webview.AwCookieManager;
import org.chromium.android_webview.AwFormDatabase;
import org.chromium.android_webview.AwGeolocationPermissions;
import org.chromium.android_webview.HttpAuthDatabase;
import org.chromium.content.browser.ContentViewStatics;

public class AwBrowserContext {
    private static final String HTTP_AUTH_DATABASE_FILE = "http_auth.db";
    private SharedPreferences mSharedPreferences;
    private AwGeolocationPermissions mGeolocationPermissions;
    private AwCookieManager mCookieManager;
    private AwFormDatabase mFormDatabase;
    private HttpAuthDatabase mHttpAuthDatabase;

    public AwBrowserContext(SharedPreferences sharedPreferences) {
        this.mSharedPreferences = sharedPreferences;
    }

    public AwGeolocationPermissions getGeolocationPermissions() {
        if (this.mGeolocationPermissions == null) {
            this.mGeolocationPermissions = new AwGeolocationPermissions(this.mSharedPreferences);
        }
        return this.mGeolocationPermissions;
    }

    public AwCookieManager getCookieManager() {
        if (this.mCookieManager == null) {
            this.mCookieManager = new AwCookieManager();
        }
        return this.mCookieManager;
    }

    public AwFormDatabase getFormDatabase() {
        if (this.mFormDatabase == null) {
            this.mFormDatabase = new AwFormDatabase();
        }
        return this.mFormDatabase;
    }

    public HttpAuthDatabase getHttpAuthDatabase(Context context) {
        if (this.mHttpAuthDatabase == null) {
            this.mHttpAuthDatabase = new HttpAuthDatabase(context, HTTP_AUTH_DATABASE_FILE);
        }
        return this.mHttpAuthDatabase;
    }

    public void pauseTimers() {
        ContentViewStatics.setWebKitSharedTimersSuspended(true);
    }

    public void resumeTimers() {
        ContentViewStatics.setWebKitSharedTimersSuspended(false);
    }
}

