/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.content.Context;
import org.chromium.base.PathUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.content.app.LibraryLoader;
import org.chromium.content.browser.AndroidBrowserProcess;
import org.chromium.content.common.ProcessInitException;

public abstract class AwBrowserProcess {
    private static final String PRIVATE_DATA_DIRECTORY_SUFFIX = "webview";

    public static void loadLibrary() {
        PathUtils.setPrivateDataDirectorySuffix(PRIVATE_DATA_DIRECTORY_SUFFIX);
        try {
            LibraryLoader.loadNow();
        }
        catch (ProcessInitException e) {
            throw new RuntimeException("Cannot load WebView", e);
        }
    }

    public static void start(final Context context) {
        ThreadUtils.runOnUiThreadBlocking(new Runnable(){

            public void run() {
                try {
                    LibraryLoader.ensureInitialized();
                    AndroidBrowserProcess.init(context, 0);
                }
                catch (ProcessInitException e) {
                    throw new RuntimeException("Cannot initialize WebView", e);
                }
            }
        });
    }
}

