/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.graphics.Picture;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import java.util.concurrent.Callable;
import org.chromium.android_webview.AwContentsClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AwContentsClientCallbackHelper {
    private static final int MSG_ON_LOAD_RESOURCE = 1;
    private static final int MSG_ON_PAGE_STARTED = 2;
    private static final int MSG_ON_DOWNLOAD_START = 3;
    private static final int MSG_ON_RECEIVED_LOGIN_REQUEST = 4;
    private static final int MSG_ON_RECEIVED_ERROR = 5;
    private static final int MSG_ON_NEW_PICTURE = 6;
    private static final int MSG_ON_SCALE_CHANGED_SCALED = 7;
    private static final long ON_NEW_PICTURE_MIN_PERIOD_MILLIS = 500L;
    private long mLastPictureTime = 0L;
    private boolean mHasPendingOnNewPicture = false;
    private final AwContentsClient mContentsClient;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    String url = (String)msg.obj;
                    AwContentsClientCallbackHelper.this.mContentsClient.onLoadResource(url);
                    break;
                }
                case 2: {
                    String url = (String)msg.obj;
                    AwContentsClientCallbackHelper.this.mContentsClient.onPageStarted(url);
                    break;
                }
                case 3: {
                    DownloadInfo info = (DownloadInfo)msg.obj;
                    AwContentsClientCallbackHelper.this.mContentsClient.onDownloadStart(info.mUrl, info.mUserAgent, info.mContentDisposition, info.mMimeType, info.mContentLength);
                    break;
                }
                case 4: {
                    LoginRequestInfo info = (LoginRequestInfo)msg.obj;
                    AwContentsClientCallbackHelper.this.mContentsClient.onReceivedLoginRequest(info.mRealm, info.mAccount, info.mArgs);
                    break;
                }
                case 5: {
                    OnReceivedErrorInfo info = (OnReceivedErrorInfo)msg.obj;
                    AwContentsClientCallbackHelper.this.mContentsClient.onReceivedError(info.mErrorCode, info.mDescription, info.mFailingUrl);
                    break;
                }
                case 6: {
                    Picture picture = null;
                    try {
                        if (msg.obj != null) {
                            picture = (Picture)((Callable)msg.obj).call();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error getting picture", e);
                    }
                    AwContentsClientCallbackHelper.this.mContentsClient.onNewPicture(picture);
                    AwContentsClientCallbackHelper.this.mLastPictureTime = SystemClock.uptimeMillis();
                    AwContentsClientCallbackHelper.this.mHasPendingOnNewPicture = false;
                    break;
                }
                case 7: {
                    float oldScale = Float.intBitsToFloat(msg.arg1);
                    float newScale = Float.intBitsToFloat(msg.arg2);
                    AwContentsClientCallbackHelper.this.mContentsClient.onScaleChangedScaled(oldScale, newScale);
                    break;
                }
                default: {
                    throw new IllegalStateException("AwContentsClientCallbackHelper: unhandled message " + msg.what);
                }
            }
        }
    };

    public AwContentsClientCallbackHelper(AwContentsClient contentsClient) {
        this.mContentsClient = contentsClient;
    }

    public void postOnLoadResource(String url) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, url));
    }

    public void postOnPageStarted(String url) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, url));
    }

    public void postOnDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
        DownloadInfo info = new DownloadInfo(url, userAgent, contentDisposition, mimeType, contentLength);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, info));
    }

    public void postOnReceivedLoginRequest(String realm, String account, String args) {
        LoginRequestInfo info = new LoginRequestInfo(realm, account, args);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, info));
    }

    public void postOnReceivedError(int errorCode, String description, String failingUrl) {
        OnReceivedErrorInfo info = new OnReceivedErrorInfo(errorCode, description, failingUrl);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, info));
    }

    public void postOnNewPicture(Callable<Picture> pictureProvider) {
        if (this.mHasPendingOnNewPicture) {
            return;
        }
        this.mHasPendingOnNewPicture = true;
        long pictureTime = Math.max(this.mLastPictureTime + 500L, SystemClock.uptimeMillis());
        this.mHandler.sendMessageAtTime(this.mHandler.obtainMessage(6, pictureProvider), pictureTime);
    }

    public void postOnScaleChangedScaled(float oldScale, float newScale) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, Float.floatToIntBits(oldScale), Float.floatToIntBits(newScale)));
    }

    private static class OnReceivedErrorInfo {
        final int mErrorCode;
        final String mDescription;
        final String mFailingUrl;

        OnReceivedErrorInfo(int errorCode, String description, String failingUrl) {
            this.mErrorCode = errorCode;
            this.mDescription = description;
            this.mFailingUrl = failingUrl;
        }
    }

    private static class LoginRequestInfo {
        final String mRealm;
        final String mAccount;
        final String mArgs;

        LoginRequestInfo(String realm, String account, String args) {
            this.mRealm = realm;
            this.mAccount = account;
            this.mArgs = args;
        }
    }

    private static class DownloadInfo {
        final String mUrl;
        final String mUserAgent;
        final String mContentDisposition;
        final String mMimeType;
        final long mContentLength;

        DownloadInfo(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
            this.mUrl = url;
            this.mUserAgent = userAgent;
            this.mContentDisposition = contentDisposition;
            this.mMimeType = mimeType;
            this.mContentLength = contentLength;
        }
    }
}

