/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.view.View;

public class AwLayoutSizer {
    public static final int FIXED_LAYOUT_HEIGHT = 0;
    private boolean mWidthMeasurementIsFixed;
    private boolean mHeightMeasurementIsFixed;
    private int mContentHeightCss;
    private int mContentWidthCss;
    private float mPageScaleFactor = 0.0f;
    private float mLastMeasuredPageScaleFactor = 0.0f;
    private boolean mFreezeLayoutRequests;
    private boolean mFrozenLayoutRequestPending;
    private double mDIPScale;
    private boolean mHeightMeasurementLimited;
    private int mHeightMeasurementLimit;
    private int mLastWidth;
    private int mLastHeight;
    private int mLastSentFixedLayoutSizeWidth = -1;
    private int mLastSentFixedLayoutSizeHeight = -1;
    private Delegate mDelegate;

    public void setDelegate(Delegate delegate) {
        this.mDelegate = delegate;
    }

    public void setDIPScale(double dipScale) {
        this.mDIPScale = dipScale;
    }

    public void freezeLayoutRequests() {
        this.mFreezeLayoutRequests = true;
        this.mFrozenLayoutRequestPending = false;
    }

    public void unfreezeLayoutRequests() {
        this.mFreezeLayoutRequests = false;
        if (this.mFrozenLayoutRequestPending) {
            this.mFrozenLayoutRequestPending = false;
            this.mDelegate.requestLayout();
        }
    }

    public void onContentSizeChanged(int widthCss, int heightCss) {
        this.doUpdate(widthCss, heightCss, this.mPageScaleFactor);
    }

    public void onPageScaleChanged(float pageScaleFactor) {
        this.doUpdate(this.mContentWidthCss, this.mContentHeightCss, pageScaleFactor);
    }

    private void doUpdate(int widthCss, int heightCss, float pageScaleFactor) {
        int heightPix = (int)((double)((float)heightCss * this.mPageScaleFactor) * this.mDIPScale);
        boolean pageScaleChanged = this.mPageScaleFactor != pageScaleFactor;
        boolean contentHeightChangeMeaningful = !this.mHeightMeasurementIsFixed && (!this.mHeightMeasurementLimited || heightPix < this.mHeightMeasurementLimit);
        boolean pageScaleChangeMeaningful = !this.mWidthMeasurementIsFixed || contentHeightChangeMeaningful;
        boolean layoutNeeded = this.mContentWidthCss != widthCss && !this.mWidthMeasurementIsFixed || this.mContentHeightCss != heightCss && contentHeightChangeMeaningful || pageScaleChanged && pageScaleChangeMeaningful;
        this.mContentWidthCss = widthCss;
        this.mContentHeightCss = heightCss;
        this.mPageScaleFactor = pageScaleFactor;
        if (layoutNeeded) {
            if (this.mFreezeLayoutRequests) {
                this.mFrozenLayoutRequestPending = true;
            } else {
                this.mDelegate.requestLayout();
            }
        } else if (pageScaleChanged && this.mLastWidth != 0) {
            this.updateFixedLayoutSize(this.mLastWidth, this.mLastHeight, this.mPageScaleFactor);
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int contentHeightPix = (int)((double)((float)this.mContentHeightCss * this.mPageScaleFactor) * this.mDIPScale);
        int contentWidthPix = (int)((double)((float)this.mContentWidthCss * this.mPageScaleFactor) * this.mDIPScale);
        int measuredHeight = contentHeightPix;
        int measuredWidth = contentWidthPix;
        this.mLastMeasuredPageScaleFactor = this.mPageScaleFactor;
        this.mWidthMeasurementIsFixed = widthMode != 0;
        this.mHeightMeasurementIsFixed = heightMode == 0x40000000;
        this.mHeightMeasurementLimited = heightMode == Integer.MIN_VALUE && contentHeightPix > heightSize;
        this.mHeightMeasurementLimit = heightSize;
        if (this.mHeightMeasurementIsFixed || this.mHeightMeasurementLimited) {
            measuredHeight = heightSize;
        }
        if (this.mWidthMeasurementIsFixed) {
            measuredWidth = widthSize;
        }
        if (measuredHeight < contentHeightPix) {
            measuredHeight |= 0x1000000;
        }
        if (measuredWidth < contentWidthPix) {
            measuredWidth |= 0x1000000;
        }
        this.mDelegate.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    public void onSizeChanged(int w, int h, int ow, int oh) {
        this.mLastWidth = w;
        this.mLastHeight = h;
        this.updateFixedLayoutSize(this.mLastWidth, this.mLastHeight, this.mLastMeasuredPageScaleFactor);
    }

    public void onLayoutChange() {
        this.updateFixedLayoutSize(this.mLastWidth, this.mLastHeight, this.mLastMeasuredPageScaleFactor);
    }

    private void setFixedLayoutSize(int widthDip, int heightDip) {
        if (widthDip == this.mLastSentFixedLayoutSizeWidth && heightDip == this.mLastSentFixedLayoutSizeHeight) {
            return;
        }
        this.mLastSentFixedLayoutSizeWidth = widthDip;
        this.mLastSentFixedLayoutSizeHeight = heightDip;
        this.mDelegate.setFixedLayoutSize(widthDip, heightDip);
    }

    private void updateFixedLayoutSize(int w, int h, float pageScaleFactor) {
        boolean wrapContentForHeight = this.mDelegate.isLayoutParamsHeightWrapContent();
        if (this.mWidthMeasurementIsFixed && !wrapContentForHeight || pageScaleFactor == 0.0f) {
            this.setFixedLayoutSize(0, 0);
            return;
        }
        double dipAndPageScale = (double)pageScaleFactor * this.mDIPScale;
        int contentWidthPix = (int)((double)this.mContentWidthCss * dipAndPageScale);
        int widthDip = (int)Math.ceil((double)w / dipAndPageScale);
        if (w == contentWidthPix) {
            widthDip = this.mContentWidthCss;
        }
        this.setFixedLayoutSize(widthDip, 0);
    }

    public static interface Delegate {
        public void requestLayout();

        public void setMeasuredDimension(int var1, int var2);

        public void setFixedLayoutSize(int var1, int var2);

        public boolean isLayoutParamsHeightWrapContent();
    }
}

