/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.content.res.Resources;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="android_webview::AwResource")
public class AwResource {
    public static int RAW_LOAD_ERROR;
    public static int RAW_NO_DOMAIN;
    public static int STRING_DEFAULT_TEXT_ENCODING;
    private static Resources sResources;
    private static Map<Integer, SoftReference<String>> sResourceCache;
    private static final int TYPE_STRING = 0;
    private static final int TYPE_RAW = 1;

    public static void setResources(Resources resources) {
        sResources = resources;
        sResourceCache = new HashMap<Integer, SoftReference<String>>();
    }

    @CalledByNative
    public static String getDefaultTextEncoding() {
        return AwResource.getResource(STRING_DEFAULT_TEXT_ENCODING, 0);
    }

    @CalledByNative
    public static String getNoDomainPageContent() {
        return AwResource.getResource(RAW_NO_DOMAIN, 1);
    }

    @CalledByNative
    public static String getLoadErrorPageContent() {
        return AwResource.getResource(RAW_LOAD_ERROR, 1);
    }

    private static String getResource(int resid, int type) {
        String result;
        assert (resid != 0);
        assert (sResources != null);
        assert (sResourceCache != null);
        String string2 = result = sResourceCache.get(resid) == null ? null : (String)sResourceCache.get(resid).get();
        if (result == null) {
            switch (type) {
                case 0: {
                    result = sResources.getString(resid);
                    break;
                }
                case 1: {
                    result = AwResource.getRawFileResourceContent(resid);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown resource type");
                }
            }
            sResourceCache.put(resid, new SoftReference<String>(result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRawFileResourceContent(int resid) {
        assert (resid != 0);
        assert (sResources != null);
        InputStreamReader isr = null;
        String result = null;
        try {
            isr = new InputStreamReader(sResources.openRawResource(resid));
            result = new Scanner(isr).useDelimiter("\\A").next();
        }
        catch (Resources.NotFoundException e) {
            String string2 = "";
            return string2;
        }
        catch (NoSuchElementException e) {
            String string3 = "";
            return string3;
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException e) {}
        }
        return result;
    }
}

