/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.ValueCallback;
import org.chromium.android_webview.AwContentsClient;
import org.chromium.android_webview.AwWebContentsDelegate;
import org.chromium.base.ThreadUtils;
import org.chromium.content.browser.ContentViewCore;

class AwWebContentsDelegateAdapter
extends AwWebContentsDelegate {
    private static final String TAG = "AwWebContentsDelegateAdapter";
    final AwContentsClient mContentsClient;
    final View mContainerView;

    public AwWebContentsDelegateAdapter(AwContentsClient contentsClient, View containerView) {
        this.mContentsClient = contentsClient;
        this.mContainerView = containerView;
    }

    public void onLoadProgressChanged(int progress) {
        this.mContentsClient.onProgressChanged(progress);
    }

    public void handleKeyboardEvent(KeyEvent event) {
        if (event.getAction() == 0) {
            int direction;
            switch (event.getKeyCode()) {
                case 20: {
                    direction = 130;
                    break;
                }
                case 19: {
                    direction = 33;
                    break;
                }
                case 21: {
                    direction = 17;
                    break;
                }
                case 22: {
                    direction = 66;
                    break;
                }
                default: {
                    direction = 0;
                }
            }
            if (direction != 0 && this.tryToMoveFocus(direction)) {
                return;
            }
        }
        this.mContentsClient.onUnhandledKeyEvent(event);
    }

    public boolean takeFocus(boolean reverse) {
        int direction;
        int n = direction = reverse == (this.mContainerView.getLayoutDirection() == 1) ? 66 : 17;
        if (this.tryToMoveFocus(direction)) {
            return true;
        }
        direction = reverse ? 33 : 130;
        return this.tryToMoveFocus(direction);
    }

    private boolean tryToMoveFocus(int direction) {
        View focus = this.mContainerView.focusSearch(direction);
        return focus != null && focus != this.mContainerView && focus.requestFocus();
    }

    public boolean addMessageToConsole(int level, String message, int lineNumber, String sourceId) {
        ConsoleMessage.MessageLevel messageLevel = ConsoleMessage.MessageLevel.DEBUG;
        switch (level) {
            case 0: {
                messageLevel = ConsoleMessage.MessageLevel.TIP;
                break;
            }
            case 1: {
                messageLevel = ConsoleMessage.MessageLevel.LOG;
                break;
            }
            case 2: {
                messageLevel = ConsoleMessage.MessageLevel.WARNING;
                break;
            }
            case 3: {
                messageLevel = ConsoleMessage.MessageLevel.ERROR;
                break;
            }
            default: {
                Log.w(TAG, "Unknown message level, defaulting to DEBUG");
            }
        }
        return this.mContentsClient.onConsoleMessage(new ConsoleMessage(message, sourceId, lineNumber, messageLevel));
    }

    public void onUpdateUrl(String url) {
    }

    public void openNewTab(String url, String extraHeaders, byte[] postData, int disposition) {
        assert (false);
    }

    public boolean addNewContents(int nativeSourceWebContents, int nativeWebContents, int disposition, Rect initialPosition, boolean userGesture) {
        throw new RuntimeException("Impossible");
    }

    public void closeContents() {
        this.mContentsClient.onCloseWindow();
    }

    public void showRepostFormWarningDialog(final ContentViewCore contentViewCore) {
        boolean MSG_CONTINUE_PENDING_RELOAD = true;
        int MSG_CANCEL_PENDING_RELOAD = 2;
        Handler handler = new Handler(ThreadUtils.getUiThreadLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        contentViewCore.continuePendingReload();
                        break;
                    }
                    case 2: {
                        contentViewCore.cancelPendingReload();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("WebContentsDelegateAdapter: unhandled message " + msg.what);
                    }
                }
            }
        };
        Message resend = handler.obtainMessage(1);
        Message dontResend = handler.obtainMessage(2);
        this.mContentsClient.onFormResubmission(dontResend, resend);
    }

    public void runFileChooser(final int processId, final int renderId, final int mode_flags, String acceptTypes, String title, String defaultFilename, boolean capture) {
        AwContentsClient.FileChooserParams params = new AwContentsClient.FileChooserParams();
        params.mode = mode_flags;
        params.acceptTypes = acceptTypes;
        params.title = title;
        params.defaultFilename = defaultFilename;
        params.capture = capture;
        this.mContentsClient.showFileChooser(new ValueCallback<String[]>(){
            boolean completed = false;

            @Override
            public void onReceiveValue(String[] results) {
                if (this.completed) {
                    throw new IllegalStateException("Duplicate showFileChooser result");
                }
                this.completed = true;
                AwWebContentsDelegate.nativeFilesSelectedInChooser(processId, renderId, mode_flags, results);
            }
        }, params);
    }

    public boolean addNewContents(boolean isDialog, boolean isUserGesture) {
        return this.mContentsClient.onCreateWindow(isDialog, isUserGesture);
    }

    public void activateContents() {
        this.mContentsClient.onRequestFocus();
    }
}

