/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.util.Log;

public class HttpAuthDatabase {
    private static final String LOGTAG = "HttpAuthDatabase";
    private static final int DATABASE_VERSION = 1;
    private SQLiteDatabase mDatabase = null;
    private static final String ID_COL = "_id";
    private static final String[] ID_PROJECTION = new String[]{"_id"};
    private static final String HTTPAUTH_TABLE_NAME = "httpauth";
    private static final String HTTPAUTH_HOST_COL = "host";
    private static final String HTTPAUTH_REALM_COL = "realm";
    private static final String HTTPAUTH_USERNAME_COL = "username";
    private static final String HTTPAUTH_PASSWORD_COL = "password";
    private boolean mInitialized = false;

    public HttpAuthDatabase(final Context context, final String databaseFile) {
        new Thread(){

            public void run() {
                HttpAuthDatabase.this.initOnBackgroundThread(context, databaseFile);
            }
        }.start();
    }

    private synchronized void initOnBackgroundThread(Context context, String databaseFile) {
        if (this.mInitialized) {
            return;
        }
        this.initDatabase(context, databaseFile);
        this.mInitialized = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabase(Context context, String databaseFile) {
        block7: {
            try {
                this.mDatabase = context.openOrCreateDatabase(databaseFile, 0, null);
            }
            catch (SQLiteException e) {
                if (!context.deleteDatabase(databaseFile)) break block7;
                this.mDatabase = context.openOrCreateDatabase(databaseFile, 0, null);
            }
        }
        if (this.mDatabase == null) {
            Log.e(LOGTAG, "Unable to open or create " + databaseFile);
            return;
        }
        if (this.mDatabase.getVersion() != 1) {
            this.mDatabase.beginTransactionNonExclusive();
            try {
                this.createTable();
                this.mDatabase.setTransactionSuccessful();
            }
            finally {
                this.mDatabase.endTransaction();
            }
        }
    }

    private void createTable() {
        this.mDatabase.execSQL("CREATE TABLE httpauth (_id INTEGER PRIMARY KEY, host TEXT, realm TEXT, username TEXT, password TEXT, UNIQUE (host, realm) ON CONFLICT REPLACE);");
        this.mDatabase.setVersion(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForInit() {
        HttpAuthDatabase httpAuthDatabase = this;
        synchronized (httpAuthDatabase) {
            while (!this.mInitialized) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e(LOGTAG, "Caught exception while checking initialization", e);
                }
            }
        }
        return this.mDatabase != null;
    }

    public void setHttpAuthUsernamePassword(String host, String realm, String username, String password) {
        if (host == null || realm == null || !this.waitForInit()) {
            return;
        }
        ContentValues c = new ContentValues();
        c.put(HTTPAUTH_HOST_COL, host);
        c.put(HTTPAUTH_REALM_COL, realm);
        c.put(HTTPAUTH_USERNAME_COL, username);
        c.put(HTTPAUTH_PASSWORD_COL, password);
        this.mDatabase.insert(HTTPAUTH_TABLE_NAME, HTTPAUTH_HOST_COL, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHttpAuthUsernamePassword(String host, String realm) {
        if (host == null || realm == null || !this.waitForInit()) {
            return null;
        }
        String[] columns = new String[]{HTTPAUTH_USERNAME_COL, HTTPAUTH_PASSWORD_COL};
        String selection = "(host == ?) AND (realm == ?)";
        String[] ret = null;
        Cursor cursor = null;
        try {
            cursor = this.mDatabase.query(HTTPAUTH_TABLE_NAME, columns, "(host == ?) AND (realm == ?)", new String[]{host, realm}, null, null, null);
            if (cursor.moveToFirst()) {
                ret = new String[]{cursor.getString(cursor.getColumnIndex(HTTPAUTH_USERNAME_COL)), cursor.getString(cursor.getColumnIndex(HTTPAUTH_PASSWORD_COL))};
            }
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "getHttpAuthUsernamePassword", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasHttpAuthUsernamePassword() {
        if (!this.waitForInit()) {
            return false;
        }
        Cursor cursor = null;
        boolean ret = false;
        try {
            cursor = this.mDatabase.query(HTTPAUTH_TABLE_NAME, ID_PROJECTION, null, null, null, null, null);
            ret = cursor.moveToFirst();
        }
        catch (IllegalStateException e) {
            Log.e(LOGTAG, "hasEntries", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return ret;
    }

    public void clearHttpAuthUsernamePassword() {
        if (!this.waitForInit()) {
            return;
        }
        this.mDatabase.delete(HTTPAUTH_TABLE_NAME, null, null);
    }
}

