/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.util.Log;
import android.util.LruCache;
import org.chromium.android_webview.AwContents;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="android_webview")
public class JavaBrowserViewRendererHelper {
    private static final String LOGTAG = "JavaBrowserViewRendererHelper";
    private static LruCache<Integer, Bitmap> sBitmapCache = new LruCache(5);

    @CalledByNative
    private static Bitmap createBitmap(int width, int height, Canvas canvas, int ownerKey) {
        Bitmap bitmap;
        if (canvas != null) {
            width = Math.min(width, canvas.getMaximumBitmapWidth());
            height = Math.min(height, canvas.getMaximumBitmapHeight());
        }
        if ((bitmap = sBitmapCache.get(ownerKey)) == null || bitmap.getWidth() != width || bitmap.getHeight() != height) {
            try {
                bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
            }
            catch (OutOfMemoryError e) {
                Log.w(LOGTAG, "Error allocating bitmap");
                return null;
            }
            if (ownerKey != 0) {
                if (sBitmapCache.size() > AwContents.getNativeInstanceCount()) {
                    sBitmapCache.evictAll();
                }
                sBitmapCache.put(ownerKey, bitmap);
            }
        }
        return bitmap;
    }

    @CalledByNative
    private static void drawBitmapIntoCanvas(Bitmap bitmap, Canvas canvas, int x, int y) {
        canvas.drawBitmap(bitmap, x, y, null);
    }

    @CalledByNative
    private static Picture recordBitmapIntoPicture(Bitmap bitmap) {
        Picture picture = new Picture();
        if (bitmap != null) {
            Canvas recordingCanvas = picture.beginRecording(bitmap.getWidth(), bitmap.getHeight());
            JavaBrowserViewRendererHelper.drawBitmapIntoCanvas(bitmap, recordingCanvas, 0, 0);
            picture.endRecording();
        }
        return picture;
    }

    private JavaBrowserViewRendererHelper() {
    }
}

