/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.app.Activity;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ObserverList;
import org.chromium.base.ThreadUtils;

@JNINamespace(value="base::android")
public class ActivityStatus {
    public static final int CREATED = 1;
    public static final int STARTED = 2;
    public static final int RESUMED = 3;
    public static final int PAUSED = 4;
    public static final int STOPPED = 5;
    public static final int DESTROYED = 6;
    private static Activity sActivity;
    private static int sActivityState;
    private static final ObserverList<StateListener> sStateListeners;

    private ActivityStatus() {
    }

    public static void onStateChange(Activity activity, int newState) {
        if (sActivity != activity) {
            sActivity = activity;
        }
        sActivityState = newState;
        for (StateListener listener : sStateListeners) {
            listener.onActivityStateChange(newState);
        }
        if (newState == 6) {
            sActivity = null;
        }
    }

    public static boolean isPaused() {
        return sActivityState == 4;
    }

    public static Activity getActivity() {
        return sActivity;
    }

    public static int getState() {
        return sActivityState;
    }

    public static void registerStateListener(StateListener listener) {
        sStateListeners.addObserver(listener);
    }

    public static void unregisterStateListener(StateListener listener) {
        sStateListeners.removeObserver(listener);
    }

    @CalledByNative
    private static void registerThreadSafeNativeStateListener() {
        ThreadUtils.runOnUiThread(new Runnable(){

            public void run() {
                sStateListeners.addObserver(new StateListener(){

                    public void onActivityStateChange(int newState) {
                        ActivityStatus.nativeOnActivityStateChange(newState);
                    }
                });
            }
        });
    }

    private static native void nativeOnActivityStateChange(int var0);

    static {
        sStateListeners = new ObserverList();
    }

    public static interface StateListener {
        public void onActivityStateChange(int var1);
    }
}

