/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import org.chromium.base.ActivityStatus;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="base::android")
public class PowerMonitor
implements ActivityStatus.StateListener {
    private static final long SUSPEND_DELAY_MS = 60000L;
    private static PowerMonitor sInstance;
    private boolean mIsBatteryPower;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private static final Runnable sSuspendTask;

    public static void createForTests(Context context) {
        sInstance = LazyHolder.INSTANCE;
    }

    public static void create(Context context) {
        if (sInstance == null) {
            sInstance = LazyHolder.INSTANCE;
            ActivityStatus.registerStateListener(sInstance);
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatusIntent = context.registerReceiver(null, ifilter);
            PowerMonitor.onBatteryChargingChanged(batteryStatusIntent);
        }
    }

    private PowerMonitor() {
    }

    public static void onBatteryChargingChanged(Intent intent) {
        if (sInstance == null) {
            return;
        }
        int chargePlug = intent.getIntExtra("plugged", -1);
        PowerMonitor.sInstance.mIsBatteryPower = chargePlug != 2 && chargePlug != 1;
        PowerMonitor.nativeOnBatteryChargingChanged();
    }

    public void onActivityStateChange(int newState) {
        if (newState == 3) {
            this.mHandler.removeCallbacks(sSuspendTask);
            PowerMonitor.nativeOnMainActivityResumed();
        } else if (newState == 4) {
            this.mHandler.postDelayed(sSuspendTask, 60000L);
        }
    }

    @CalledByNative
    private static boolean isBatteryPower() {
        return PowerMonitor.sInstance.mIsBatteryPower;
    }

    private static native void nativeOnBatteryChargingChanged();

    private static native void nativeOnMainActivitySuspended();

    private static native void nativeOnMainActivityResumed();

    static {
        sSuspendTask = new Runnable(){

            public void run() {
                PowerMonitor.nativeOnMainActivitySuspended();
            }
        };
    }

    private static class LazyHolder {
        private static final PowerMonitor INSTANCE = new PowerMonitor();

        private LazyHolder() {
        }
    }
}

