/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import org.chromium.base.ThreadUtils;

public class WeakContext {
    private static WeakReference<Context> sWeakContext;

    public static void initializeWeakContext(Context context) {
        sWeakContext = new WeakReference<Context>(context);
    }

    public static Context getContext() {
        return (Context)sWeakContext.get();
    }

    public static Object getSystemService(final String name) {
        final Context context = (Context)sWeakContext.get();
        if (context == null) {
            return null;
        }
        if (ThreadUtils.runningOnUiThread()) {
            return context.getSystemService(name);
        }
        return ThreadUtils.runOnUiThreadBlockingNoException(new Callable<Object>(){

            @Override
            public Object call() {
                return context.getSystemService(name);
            }
        });
    }
}

