/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.Surface;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.content.app.ChildProcessService;
import org.chromium.content.app.PrivilegedProcessService;
import org.chromium.content.app.SandboxedProcessService;
import org.chromium.content.browser.ChildProcessConnection;
import org.chromium.content.browser.FileDescriptorInfo;
import org.chromium.content.common.IChildProcessCallback;
import org.chromium.content.common.IChildProcessService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="content")
public class ChildProcessLauncher {
    private static String TAG = "ChildProcessLauncher";
    private static final int CALLBACK_FOR_UNKNOWN_PROCESS = 0;
    private static final int CALLBACK_FOR_GPU_PROCESS = 1;
    private static final int CALLBACK_FOR_RENDERER_PROCESS = 2;
    private static final String SWITCH_PROCESS_TYPE = "type";
    private static final String SWITCH_PPAPI_BROKER_PROCESS = "ppapi-broker";
    private static final String SWITCH_RENDERER_PROCESS = "renderer";
    private static final String SWITCH_GPU_PROCESS = "gpu-process";
    static final int MAX_REGISTERED_SANDBOXED_SERVICES = 13;
    static final int MAX_REGISTERED_PRIVILEGED_SERVICES = 3;
    private static final ChildConnectionAllocator sSandboxedChildConnectionAllocator = new ChildConnectionAllocator(true);
    private static final ChildConnectionAllocator sPrivilegedChildConnectionAllocator = new ChildConnectionAllocator(false);
    private static boolean sConnectionAllocated = false;
    private static final int NULL_PROCESS_HANDLE = 0;
    private static Map<Integer, ChildProcessConnection> sServiceMap = new ConcurrentHashMap<Integer, ChildProcessConnection>();
    private static SparseIntArray sOomBindingCount = new SparseIntArray();
    private static ChildProcessConnection sSpareSandboxedConnection = null;

    public static void setChildProcessClass(Class<? extends SandboxedProcessService> sandboxedServiceClass, Class<? extends PrivilegedProcessService> privilegedServiceClass) {
        assert (!sConnectionAllocated);
        sSandboxedChildConnectionAllocator.setServiceClass(sandboxedServiceClass);
        sPrivilegedChildConnectionAllocator.setServiceClass(privilegedServiceClass);
    }

    private static ChildConnectionAllocator getConnectionAllocator(boolean inSandbox) {
        return inSandbox ? sSandboxedChildConnectionAllocator : sPrivilegedChildConnectionAllocator;
    }

    private static ChildProcessConnection allocateConnection(Context context, boolean inSandbox) {
        ChildProcessConnection.DeathCallback deathCallback = new ChildProcessConnection.DeathCallback(){

            public void onChildProcessDied(int pid) {
                ChildProcessLauncher.stop(pid);
            }
        };
        sConnectionAllocated = true;
        return ChildProcessLauncher.getConnectionAllocator(inSandbox).allocate(context, deathCallback);
    }

    private static ChildProcessConnection allocateBoundConnection(Context context, String[] commandLine, boolean inSandbox) {
        ChildProcessConnection connection = ChildProcessLauncher.allocateConnection(context, inSandbox);
        if (connection != null) {
            connection.start(commandLine);
        }
        return connection;
    }

    private static void freeConnection(ChildProcessConnection connection) {
        if (connection == null) {
            return;
        }
        ChildProcessLauncher.getConnectionAllocator(connection.isInSandbox()).free(connection);
    }

    public static IChildProcessService getChildService(int pid) {
        ChildProcessConnection connection = sServiceMap.get(pid);
        if (connection != null) {
            return connection.getService();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warmUp(Context context) {
        Class<ChildProcessLauncher> clazz = ChildProcessLauncher.class;
        synchronized (ChildProcessLauncher.class) {
            assert (!ThreadUtils.runningOnUiThread());
            if (sSpareSandboxedConnection == null) {
                sSpareSandboxedConnection = ChildProcessLauncher.allocateBoundConnection(context, null, true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static String getSwitchValue(String[] commandLine, String switchKey) {
        if (commandLine == null || switchKey == null) {
            return null;
        }
        String switchKeyPrefix = "--" + switchKey + "=";
        for (String command : commandLine) {
            if (command == null || !command.startsWith(switchKeyPrefix)) continue;
            return command.substring(switchKeyPrefix.length());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    static void start(Context context, String[] commandLine, int[] fileIds, int[] fileFds, boolean[] fileAutoClose, final int clientContext) {
        assert (fileIds.length == fileFds.length && fileFds.length == fileAutoClose.length);
        FileDescriptorInfo[] filesToBeMapped = new FileDescriptorInfo[fileFds.length];
        for (int i = 0; i < fileFds.length; ++i) {
            filesToBeMapped[i] = new FileDescriptorInfo(fileIds[i], fileFds[i], fileAutoClose[i]);
        }
        assert (clientContext != 0);
        int callbackType = 0;
        boolean inSandbox = true;
        String processType = ChildProcessLauncher.getSwitchValue(commandLine, SWITCH_PROCESS_TYPE);
        if (SWITCH_RENDERER_PROCESS.equals(processType)) {
            callbackType = 2;
        } else if (SWITCH_GPU_PROCESS.equals(processType)) {
            callbackType = 1;
        } else if (SWITCH_PPAPI_BROKER_PROCESS.equals(processType)) {
            inSandbox = false;
        }
        ChildProcessConnection allocatedConnection = null;
        Class<ChildProcessLauncher> clazz = ChildProcessLauncher.class;
        synchronized (ChildProcessLauncher.class) {
            if (inSandbox) {
                allocatedConnection = sSpareSandboxedConnection;
                sSpareSandboxedConnection = null;
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            if (allocatedConnection == null && (allocatedConnection = ChildProcessLauncher.allocateBoundConnection(context, commandLine, inSandbox)) == null) {
                ChildProcessLauncher.nativeOnChildProcessStarted(clientContext, 0);
                return;
            }
            final ChildProcessConnection connection = allocatedConnection;
            Log.d(TAG, "Setting up connection to process: slot=" + connection.getServiceNumber());
            ChildProcessConnection.ConnectionCallbacks connectionCallbacks = new ChildProcessConnection.ConnectionCallbacks(){

                public void onConnected(int pid, int oomBindingCount) {
                    Log.d(TAG, "on connect callback, pid=" + pid + " context=" + clientContext);
                    if (pid != 0) {
                        sOomBindingCount.put(pid, oomBindingCount);
                        sServiceMap.put(pid, connection);
                    } else {
                        ChildProcessLauncher.freeConnection(connection);
                    }
                    ChildProcessLauncher.nativeOnChildProcessStarted(clientContext, pid);
                }

                public void onOomBindingAdded(int pid) {
                    if (pid != 0) {
                        sOomBindingCount.put(pid, sOomBindingCount.get(pid) + 1);
                    }
                }

                public void onOomBindingRemoved(int pid) {
                    if (pid != 0) {
                        int count = sOomBindingCount.get(pid, -1);
                        assert (count > 0);
                        if (--count > 0) {
                            sOomBindingCount.put(pid, count);
                        } else {
                            sOomBindingCount.delete(pid);
                        }
                    }
                }
            };
            connection.setupConnection(commandLine, filesToBeMapped, ChildProcessLauncher.createCallback(callbackType), connectionCallbacks);
            return;
        }
    }

    @CalledByNative
    static void stop(int pid) {
        Log.d(TAG, "stopping child connection: pid=" + pid);
        ChildProcessConnection connection = sServiceMap.remove(pid);
        if (connection == null) {
            ChildProcessLauncher.LogPidWarning(pid, "Tried to stop non-existent connection");
            return;
        }
        connection.stop();
        ChildProcessLauncher.freeConnection(connection);
    }

    static void removeInitialBinding(int pid) {
        ChildProcessConnection connection = sServiceMap.get(pid);
        if (connection == null) {
            ChildProcessLauncher.LogPidWarning(pid, "Tried to remove a binding for a non-existent connection");
            return;
        }
        connection.removeInitialBinding();
    }

    static void bindAsHighPriority(int pid) {
        ChildProcessConnection connection = sServiceMap.get(pid);
        if (connection == null) {
            ChildProcessLauncher.LogPidWarning(pid, "Tried to bind a non-existent connection");
            return;
        }
        connection.attachAsActive();
    }

    static void unbindAsHighPriority(int pid) {
        ChildProcessConnection connection = sServiceMap.get(pid);
        if (connection == null) {
            ChildProcessLauncher.LogPidWarning(pid, "Tried to unbind non-existent connection");
            return;
        }
        connection.detachAsActive();
    }

    static boolean isOomProtected(int pid) {
        return sOomBindingCount.get(pid) > 0;
    }

    private static IChildProcessCallback createCallback(final int callbackType) {
        return new IChildProcessCallback.Stub(){

            public void establishSurfacePeer(int pid, Surface surface, int primaryID, int secondaryID) {
                if (callbackType != 1) {
                    Log.e(TAG, "Illegal callback for non-GPU process.");
                    return;
                }
                ChildProcessLauncher.nativeEstablishSurfacePeer(pid, surface, primaryID, secondaryID);
            }

            public Surface getViewSurface(int surfaceId) {
                if (callbackType != 1) {
                    Log.e(TAG, "Illegal callback for non-GPU process.");
                    return null;
                }
                return ChildProcessLauncher.nativeGetViewSurface(surfaceId);
            }
        };
    }

    private static void LogPidWarning(int pid, String message) {
        if (pid > 0 && !ChildProcessLauncher.nativeIsSingleProcess()) {
            Log.w(TAG, message + ", pid=" + pid);
        }
    }

    private static native void nativeOnChildProcessStarted(int var0, int var1);

    private static native Surface nativeGetViewSurface(int var0);

    private static native void nativeEstablishSurfacePeer(int var0, Surface var1, int var2, int var3);

    private static native boolean nativeIsSingleProcess();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildConnectionAllocator {
        private ChildProcessConnection[] mChildProcessConnections;
        private ArrayList<Integer> mFreeConnectionIndices;
        private final Object mConnectionLock = new Object();
        private Class<? extends ChildProcessService> mChildClass;
        private final boolean mInSandbox;

        public ChildConnectionAllocator(boolean inSandbox) {
            int numChildServices = inSandbox ? 13 : 3;
            this.mChildProcessConnections = new ChildProcessConnection[numChildServices];
            this.mFreeConnectionIndices = new ArrayList(numChildServices);
            for (int i = 0; i < numChildServices; ++i) {
                this.mFreeConnectionIndices.add(i);
            }
            this.setServiceClass(inSandbox ? SandboxedProcessService.class : PrivilegedProcessService.class);
            this.mInSandbox = inSandbox;
        }

        public void setServiceClass(Class<? extends ChildProcessService> childClass) {
            this.mChildClass = childClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChildProcessConnection allocate(Context context, ChildProcessConnection.DeathCallback deathCallback) {
            Object object = this.mConnectionLock;
            synchronized (object) {
                if (this.mFreeConnectionIndices.isEmpty()) {
                    Log.w(TAG, "Ran out of service.");
                    return null;
                }
                int slot = this.mFreeConnectionIndices.remove(0);
                assert (this.mChildProcessConnections[slot] == null);
                this.mChildProcessConnections[slot] = new ChildProcessConnection(context, slot, this.mInSandbox, deathCallback, this.mChildClass);
                return this.mChildProcessConnections[slot];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void free(ChildProcessConnection connection) {
            Object object = this.mConnectionLock;
            synchronized (object) {
                int slot = connection.getServiceNumber();
                if (this.mChildProcessConnections[slot] != connection) {
                    int occupier = this.mChildProcessConnections[slot] == null ? -1 : this.mChildProcessConnections[slot].getServiceNumber();
                    Log.e(TAG, "Unable to find connection to free in slot: " + slot + " already occupied by service: " + occupier);
                    assert (false);
                } else {
                    this.mChildProcessConnections[slot] = null;
                    assert (!this.mFreeConnectionIndices.contains(slot));
                    this.mFreeConnectionIndices.add(slot);
                }
            }
        }
    }
}

