/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.MediaController;
import android.widget.ProgressBar;
import android.widget.TextView;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.content.R;
import org.chromium.content.browser.ContentVideoViewClient;
import org.chromium.content.browser.ContentVideoViewControls;

@JNINamespace(value="content")
public class ContentVideoView
extends FrameLayout
implements ContentVideoViewControls.Delegate,
SurfaceHolder.Callback,
View.OnTouchListener,
View.OnKeyListener {
    private static final String TAG = "ContentVideoView";
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    public static final int MEDIA_ERROR_NOT_VALID_FOR_PROGRESSIVE_PLAYBACK = 2;
    public static final int MEDIA_ERROR_INVALID_CODE = 3;
    private static final int STATE_ERROR = -1;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PLAYING = 1;
    private static final int STATE_PAUSED = 2;
    private static final int STATE_PLAYBACK_COMPLETED = 3;
    private SurfaceHolder mSurfaceHolder;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mCurrentBufferPercentage;
    private int mDuration;
    private ContentVideoViewControls mControls;
    private boolean mCanPause;
    private boolean mCanSeekBack;
    private boolean mCanSeekForward;
    private int mNativeContentVideoView;
    private int mCurrentState = 0;
    private String mPlaybackErrorText;
    private String mUnknownErrorText;
    private String mErrorButton;
    private String mErrorTitle;
    private String mVideoLoadingText;
    private VideoSurfaceView mVideoSurfaceView;
    private View mProgressView;
    private Surface mSurface;
    private ContentVideoViewClient mClient;
    private Runnable mExitFullscreenRunnable = new Runnable(){

        public void run() {
            ContentVideoView.this.exitFullscreen(true);
        }
    };

    private ContentVideoView(Context context, int nativeContentVideoView, ContentVideoViewClient client) {
        super(context);
        this.mNativeContentVideoView = nativeContentVideoView;
        this.mClient = client;
        this.initResources(context);
        this.mCurrentBufferPercentage = 0;
        this.mVideoSurfaceView = new VideoSurfaceView(context);
        this.setBackgroundColor(-16777216);
        this.showContentVideoView();
        this.setVisibility(0);
        this.mClient.onShowCustomView(this);
    }

    private void initResources(Context context) {
        if (this.mPlaybackErrorText != null) {
            return;
        }
        this.mPlaybackErrorText = context.getString(R.string.media_player_error_text_invalid_progressive_playback);
        this.mUnknownErrorText = context.getString(R.string.media_player_error_text_unknown);
        this.mErrorButton = context.getString(R.string.media_player_error_button);
        this.mErrorTitle = context.getString(R.string.media_player_error_title);
        this.mVideoLoadingText = context.getString(R.string.media_player_loading_video);
    }

    private void showContentVideoView() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
        this.addView((View)this.mVideoSurfaceView, layoutParams);
        View progressView = this.mClient.getVideoLoadingProgressView();
        this.mProgressView = progressView != null ? progressView : new ProgressView(this.getContext(), this.mVideoLoadingText);
        this.addView(this.mProgressView, layoutParams);
        this.mVideoSurfaceView.setZOrderOnTop(true);
        this.mVideoSurfaceView.setOnKeyListener(this);
        this.mVideoSurfaceView.setOnTouchListener(this);
        this.mVideoSurfaceView.getHolder().addCallback(this);
        this.mVideoSurfaceView.setFocusable(true);
        this.mVideoSurfaceView.setFocusableInTouchMode(true);
        this.mVideoSurfaceView.requestFocus();
    }

    @CalledByNative
    public void onMediaPlayerError(int errorType) {
        Log.d(TAG, "OnMediaPlayerError: " + errorType);
        if (this.mCurrentState == -1 || this.mCurrentState == 3) {
            return;
        }
        if (errorType == 3) {
            return;
        }
        this.mCurrentState = -1;
        if (this.mControls != null) {
            this.mControls.hide();
        }
        if (this.getWindowToken() != null) {
            String message = errorType == 2 ? this.mPlaybackErrorText : this.mUnknownErrorText;
            new AlertDialog.Builder(this.getContext()).setTitle(this.mErrorTitle).setMessage(message).setPositiveButton(this.mErrorButton, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    ContentVideoView.this.onCompletion();
                }
            }).setCancelable(false).show();
        }
    }

    @CalledByNative
    private void onVideoSizeChanged(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        if (this.mVideoWidth != 0 && this.mVideoHeight != 0) {
            this.mVideoSurfaceView.getHolder().setFixedSize(this.mVideoWidth, this.mVideoHeight);
        }
    }

    @CalledByNative
    private void onBufferingUpdate(int percent) {
        this.mCurrentBufferPercentage = percent;
    }

    @CalledByNative
    private void onPlaybackComplete() {
        this.onCompletion();
    }

    @CalledByNative
    private void onUpdateMediaMetadata(int videoWidth, int videoHeight, int duration, boolean canPause, boolean canSeekBack, boolean canSeekForward) {
        this.mProgressView.setVisibility(8);
        this.mDuration = duration;
        this.mCanPause = canPause;
        this.mCanSeekBack = canSeekBack;
        this.mCanSeekForward = canSeekForward;
        int n = this.mCurrentState = this.isPlaying() ? 1 : 2;
        if (this.mControls != null) {
            this.mControls.setEnabled(true);
            if (this.isPlaying()) {
                this.mControls.show();
            } else {
                this.mControls.show(0);
            }
        }
        this.onVideoSizeChanged(videoWidth, videoHeight);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mVideoSurfaceView.setFocusable(true);
        this.mVideoSurfaceView.setFocusableInTouchMode(true);
        if (this.isInPlaybackState() && this.mControls != null) {
            this.mControls.show();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
        this.openVideo();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        if (this.mNativeContentVideoView != 0) {
            this.nativeSetSurface(this.mNativeContentVideoView, null);
        }
        this.mSurfaceHolder = null;
        this.post(this.mExitFullscreenRunnable);
    }

    private void setControls(ContentVideoViewControls controls) {
        if (this.mControls != null) {
            this.mControls.hide();
        }
        this.mControls = controls;
        this.attachControls();
    }

    private void attachControls() {
        if (this.mControls != null) {
            this.mControls.setDelegate(this);
            this.mControls.setAnchorView(this.mVideoSurfaceView);
            this.mControls.setEnabled(false);
        }
    }

    @CalledByNative
    private void openVideo() {
        if (this.mSurfaceHolder != null) {
            this.mCurrentState = 0;
            this.mCurrentBufferPercentage = 0;
            ContentVideoViewControls controls = this.mClient.createControls();
            if (controls == null) {
                controls = new FullScreenControls(this.getContext(), this);
            }
            this.setControls(controls);
            if (this.mNativeContentVideoView != 0) {
                this.nativeUpdateMediaMetadata(this.mNativeContentVideoView);
                this.nativeSetSurface(this.mNativeContentVideoView, this.mSurfaceHolder.getSurface());
            }
        }
    }

    private void onCompletion() {
        this.mCurrentState = 3;
        if (this.mControls != null) {
            this.mControls.hide();
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.isInPlaybackState() && this.mControls != null && event.getAction() == 0) {
            this.toggleMediaControlsVisiblity();
        }
        return true;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mControls != null) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        boolean isKeyCodeSupported;
        boolean bl = isKeyCodeSupported = keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 164 && keyCode != 5 && keyCode != 82 && keyCode != 84 && keyCode != 6;
        if (this.isInPlaybackState() && isKeyCodeSupported && this.mControls != null) {
            if (keyCode == 79 || keyCode == 85) {
                if (this.isPlaying()) {
                    this.pause();
                    this.mControls.show();
                } else {
                    this.start();
                    this.mControls.hide();
                }
                return true;
            }
            if (keyCode == 126) {
                if (!this.isPlaying()) {
                    this.start();
                    this.mControls.hide();
                }
                return true;
            }
            if (keyCode == 86 || keyCode == 127) {
                if (this.isPlaying()) {
                    this.pause();
                    this.mControls.show();
                }
                return true;
            }
            this.toggleMediaControlsVisiblity();
        } else {
            if (keyCode == 4 && event.getAction() == 1) {
                this.exitFullscreen(false);
                return true;
            }
            if (keyCode == 82 || keyCode == 84) {
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mControls.isShowing()) {
            this.mControls.hide();
        } else {
            this.mControls.show();
        }
    }

    private boolean isInPlaybackState() {
        return this.mCurrentState != -1 && this.mCurrentState != 0;
    }

    public void start() {
        if (this.isInPlaybackState()) {
            if (this.mNativeContentVideoView != 0) {
                this.nativePlay(this.mNativeContentVideoView);
            }
            this.mCurrentState = 1;
        }
    }

    public void pause() {
        if (this.isInPlaybackState() && this.isPlaying()) {
            if (this.mNativeContentVideoView != 0) {
                this.nativePause(this.mNativeContentVideoView);
            }
            this.mCurrentState = 2;
        }
    }

    public int getDuration() {
        if (this.isInPlaybackState()) {
            if (this.mDuration > 0) {
                return this.mDuration;
            }
            this.mDuration = this.mNativeContentVideoView != 0 ? this.nativeGetDurationInMilliSeconds(this.mNativeContentVideoView) : 0;
            return this.mDuration;
        }
        this.mDuration = -1;
        return this.mDuration;
    }

    public int getCurrentPosition() {
        if (this.isInPlaybackState() && this.mNativeContentVideoView != 0) {
            return this.nativeGetCurrentPosition(this.mNativeContentVideoView);
        }
        return 0;
    }

    public void seekTo(int msec) {
        if (this.mNativeContentVideoView != 0) {
            this.nativeSeekTo(this.mNativeContentVideoView, msec);
        }
    }

    public boolean isPlaying() {
        return this.mNativeContentVideoView != 0 && this.nativeIsPlaying(this.mNativeContentVideoView);
    }

    public int getBufferPercentage() {
        return this.mCurrentBufferPercentage;
    }

    public boolean canPause() {
        return this.mCanPause;
    }

    public boolean canSeekBackward() {
        return this.mCanSeekBack;
    }

    public boolean canSeekForward() {
        return this.mCanSeekForward;
    }

    public int getAudioSessionId() {
        return 0;
    }

    @CalledByNative
    private static ContentVideoView createContentVideoView(Context context, int nativeContentVideoView, ContentVideoViewClient client) {
        ThreadUtils.assertOnUiThread();
        if (!(context instanceof Activity)) {
            Log.w(TAG, "Wrong type of context, can't create fullscreen video");
            return null;
        }
        return new ContentVideoView(context, nativeContentVideoView, client);
    }

    private void removeControls() {
        if (this.mControls != null) {
            this.mControls.setEnabled(false);
            this.mControls.hide();
            this.mControls = null;
        }
    }

    public void removeSurfaceView() {
        this.removeView(this.mVideoSurfaceView);
        this.removeView(this.mProgressView);
        this.mVideoSurfaceView = null;
        this.mProgressView = null;
    }

    public void exitFullscreen(boolean relaseMediaPlayer) {
        this.destroyContentVideoView(false);
        if (this.mNativeContentVideoView != 0) {
            this.nativeExitFullscreen(this.mNativeContentVideoView, relaseMediaPlayer);
            this.mNativeContentVideoView = 0;
        }
    }

    @CalledByNative
    private void destroyContentVideoView(boolean nativeViewDestroyed) {
        if (this.mVideoSurfaceView != null) {
            this.removeControls();
            this.removeSurfaceView();
            this.setVisibility(8);
            this.mClient.onDestroyContentVideoView();
        }
        if (nativeViewDestroyed) {
            this.mNativeContentVideoView = 0;
        }
    }

    public static ContentVideoView getContentVideoView() {
        return ContentVideoView.nativeGetSingletonJavaContentVideoView();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        return true;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1) {
            this.exitFullscreen(false);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private static native ContentVideoView nativeGetSingletonJavaContentVideoView();

    private native void nativeExitFullscreen(int var1, boolean var2);

    private native int nativeGetCurrentPosition(int var1);

    private native int nativeGetDurationInMilliSeconds(int var1);

    private native void nativeUpdateMediaMetadata(int var1);

    private native int nativeGetVideoWidth(int var1);

    private native int nativeGetVideoHeight(int var1);

    private native boolean nativeIsPlaying(int var1);

    private native void nativePause(int var1);

    private native void nativePlay(int var1);

    private native void nativeSeekTo(int var1, int var2);

    private native void nativeSetSurface(int var1, Surface var2);

    private static class FullScreenControls
    implements ContentVideoViewControls {
        View mVideoView;
        MediaController mMediaController;

        public FullScreenControls(Context context, View video) {
            this.mMediaController = new MediaController(context);
            this.mVideoView = video;
        }

        public void show() {
            this.mMediaController.show();
            if (this.mVideoView != null) {
                this.mVideoView.setSystemUiVisibility(0);
            }
        }

        public void show(int timeout_ms) {
            this.mMediaController.show(timeout_ms);
        }

        public void hide() {
            if (this.mVideoView != null) {
                this.mVideoView.setSystemUiVisibility(1);
            }
            this.mMediaController.hide();
        }

        public boolean isShowing() {
            return this.mMediaController.isShowing();
        }

        public void setEnabled(boolean enabled) {
            this.mMediaController.setEnabled(enabled);
        }

        public void setDelegate(ContentVideoViewControls.Delegate delegate) {
            this.mMediaController.setMediaPlayer(delegate);
        }

        public void setAnchorView(View view) {
            this.mMediaController.setAnchorView(view);
        }
    }

    private static class ProgressView
    extends LinearLayout {
        private ProgressBar mProgressBar;
        private TextView mTextView;

        public ProgressView(Context context, String videoLoadingText) {
            super(context);
            this.setOrientation(1);
            this.setLayoutParams(new LinearLayout.LayoutParams(-2, -2));
            this.mProgressBar = new ProgressBar(context, null, 16842874);
            this.mTextView = new TextView(context);
            this.mTextView.setText(videoLoadingText);
            this.addView(this.mProgressBar);
            this.addView(this.mTextView);
        }
    }

    private class VideoSurfaceView
    extends SurfaceView {
        public VideoSurfaceView(Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (ContentVideoView.this.mVideoWidth == 0 && ContentVideoView.this.mVideoHeight == 0) {
                this.setMeasuredDimension(1, 1);
                return;
            }
            int width = VideoSurfaceView.getDefaultSize(ContentVideoView.this.mVideoWidth, widthMeasureSpec);
            int height = VideoSurfaceView.getDefaultSize(ContentVideoView.this.mVideoHeight, heightMeasureSpec);
            if (ContentVideoView.this.mVideoWidth > 0 && ContentVideoView.this.mVideoHeight > 0) {
                if (ContentVideoView.this.mVideoWidth * height > width * ContentVideoView.this.mVideoHeight) {
                    height = width * ContentVideoView.this.mVideoHeight / ContentVideoView.this.mVideoWidth;
                } else if (ContentVideoView.this.mVideoWidth * height < width * ContentVideoView.this.mVideoHeight) {
                    width = height * ContentVideoView.this.mVideoWidth / ContentVideoView.this.mVideoHeight;
                }
            }
            this.setMeasuredDimension(width, height);
        }
    }
}

