/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.WeakContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="content")
class DeviceMotionAndOrientation
implements SensorEventListener {
    private static final String TAG = "DeviceMotionAndOrientation";
    private Thread mThread;
    private Handler mHandler;
    private Object mHandlerLock = new Object();
    private int mNativePtr;
    private Object mNativePtrLock = new Object();
    private float[] mAccelerationIncludingGravityVector;
    private float[] mMagneticFieldVector;
    private SensorManagerProxy mSensorManagerProxy;
    private static DeviceMotionAndOrientation sSingleton;
    private static Object sSingletonLock;
    static final int DEVICE_ORIENTATION = 0;
    static final int DEVICE_MOTION = 1;
    static final ImmutableSet<Integer> DEVICE_ORIENTATION_SENSORS;
    static final ImmutableSet<Integer> DEVICE_MOTION_SENSORS;
    @VisibleForTesting
    final Set<Integer> mActiveSensors = Sets.newHashSet();
    boolean mDeviceMotionIsActive = false;
    boolean mDeviceOrientationIsActive = false;

    protected DeviceMotionAndOrientation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public boolean start(int nativePtr, int eventType, int rateInMilliseconds) {
        boolean success = false;
        Object object = this.mNativePtrLock;
        synchronized (object) {
            switch (eventType) {
                case 0: {
                    success = this.registerSensors(DEVICE_ORIENTATION_SENSORS, rateInMilliseconds, true);
                    break;
                }
                case 1: {
                    success = this.registerSensors(DEVICE_MOTION_SENSORS, rateInMilliseconds, false);
                    break;
                }
                default: {
                    Log.e(TAG, "Unknown event type: " + eventType);
                    return false;
                }
            }
            if (success) {
                this.mNativePtr = nativePtr;
                this.setEventTypeActive(eventType, true);
            }
            return success;
        }
    }

    @CalledByNative
    public int getNumberActiveDeviceMotionSensors() {
        HashSet<Integer> deviceMotionSensors = Sets.newHashSet(DEVICE_MOTION_SENSORS);
        deviceMotionSensors.removeAll(this.mActiveSensors);
        return DEVICE_MOTION_SENSORS.size() - deviceMotionSensors.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void stop(int eventType) {
        HashSet<Integer> sensorsToRemainActive = Sets.newHashSet();
        Object object = this.mNativePtrLock;
        synchronized (object) {
            switch (eventType) {
                case 0: {
                    if (!this.mDeviceMotionIsActive) break;
                    sensorsToRemainActive.addAll(DEVICE_MOTION_SENSORS);
                    break;
                }
                case 1: {
                    if (!this.mDeviceOrientationIsActive) break;
                    sensorsToRemainActive.addAll(DEVICE_ORIENTATION_SENSORS);
                    break;
                }
                default: {
                    Log.e(TAG, "Unknown event type: " + eventType);
                    return;
                }
            }
            HashSet<Integer> sensorsToDeactivate = Sets.newHashSet(this.mActiveSensors);
            sensorsToDeactivate.removeAll(sensorsToRemainActive);
            this.unregisterSensors(sensorsToDeactivate);
            this.setEventTypeActive(eventType, false);
            if (this.mActiveSensors.isEmpty()) {
                this.mNativePtr = 0;
            }
        }
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    @Override
    public void onSensorChanged(SensorEvent event) {
        this.sensorChanged(event.sensor.getType(), event.values);
    }

    @VisibleForTesting
    void sensorChanged(int type, float[] values) {
        switch (type) {
            case 1: {
                if (this.mAccelerationIncludingGravityVector == null) {
                    this.mAccelerationIncludingGravityVector = new float[3];
                }
                System.arraycopy(values, 0, this.mAccelerationIncludingGravityVector, 0, this.mAccelerationIncludingGravityVector.length);
                if (this.mDeviceMotionIsActive) {
                    this.gotAccelerationIncludingGravity(this.mAccelerationIncludingGravityVector[0], this.mAccelerationIncludingGravityVector[1], this.mAccelerationIncludingGravityVector[2]);
                }
                if (!this.mDeviceOrientationIsActive) break;
                this.getOrientationUsingGetRotationMatrix();
                break;
            }
            case 10: {
                if (!this.mDeviceMotionIsActive) break;
                this.gotAcceleration(values[0], values[1], values[2]);
                break;
            }
            case 4: {
                if (!this.mDeviceMotionIsActive) break;
                this.gotRotationRate(values[0], values[1], values[2]);
                break;
            }
            case 2: {
                if (this.mMagneticFieldVector == null) {
                    this.mMagneticFieldVector = new float[3];
                }
                System.arraycopy(values, 0, this.mMagneticFieldVector, 0, this.mMagneticFieldVector.length);
                if (!this.mDeviceOrientationIsActive) break;
                this.getOrientationUsingGetRotationMatrix();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void getOrientationUsingGetRotationMatrix() {
        double gamma;
        double beta;
        double alpha;
        if (this.mAccelerationIncludingGravityVector == null || this.mMagneticFieldVector == null) {
            return;
        }
        float[] deviceRotationMatrix = new float[9];
        if (!SensorManager.getRotationMatrix(deviceRotationMatrix, null, this.mAccelerationIncludingGravityVector, this.mMagneticFieldVector)) {
            return;
        }
        float[] rotationAngles = new float[3];
        SensorManager.getOrientation(deviceRotationMatrix, rotationAngles);
        for (alpha = Math.toDegrees(-rotationAngles[0]); alpha < 0.0; alpha += 360.0) {
        }
        for (beta = Math.toDegrees(-rotationAngles[1]); beta < -180.0; beta += 360.0) {
        }
        for (gamma = Math.toDegrees(rotationAngles[2]); gamma < -90.0; gamma += 360.0) {
        }
        this.gotOrientation(alpha, beta, gamma);
    }

    private SensorManagerProxy getSensorManagerProxy() {
        if (this.mSensorManagerProxy != null) {
            return this.mSensorManagerProxy;
        }
        SensorManager sensorManager = (SensorManager)WeakContext.getSystemService("sensor");
        if (sensorManager != null) {
            this.mSensorManagerProxy = new SensorManagerProxyImpl(sensorManager);
        }
        return this.mSensorManagerProxy;
    }

    @VisibleForTesting
    void setSensorManagerProxy(SensorManagerProxy sensorManagerProxy) {
        this.mSensorManagerProxy = sensorManagerProxy;
    }

    private void setEventTypeActive(int eventType, boolean value) {
        switch (eventType) {
            case 0: {
                this.mDeviceOrientationIsActive = value;
                return;
            }
            case 1: {
                this.mDeviceMotionIsActive = value;
                return;
            }
        }
    }

    private boolean registerSensors(Iterable<Integer> sensorTypes, int rateInMilliseconds, boolean failOnMissingSensor) {
        HashSet<Integer> sensorsToActivate = Sets.newHashSet(sensorTypes);
        sensorsToActivate.removeAll(this.mActiveSensors);
        boolean success = false;
        for (Integer sensorType : sensorsToActivate) {
            boolean result = this.registerForSensorType(sensorType, rateInMilliseconds);
            if (!result && failOnMissingSensor) {
                this.unregisterSensors(sensorsToActivate);
                return false;
            }
            if (!result) continue;
            this.mActiveSensors.add(sensorType);
            success = true;
        }
        return success;
    }

    private void unregisterSensors(Iterable<Integer> sensorTypes) {
        for (Integer sensorType : sensorTypes) {
            if (!this.mActiveSensors.contains(sensorType)) continue;
            this.getSensorManagerProxy().unregisterListener(this, sensorType);
            this.mActiveSensors.remove(sensorType);
        }
    }

    private boolean registerForSensorType(int type, int rateInMilliseconds) {
        SensorManagerProxy sensorManager = this.getSensorManagerProxy();
        if (sensorManager == null) {
            return false;
        }
        int rateInMicroseconds = 1000 * rateInMilliseconds;
        return sensorManager.registerListener(this, type, rateInMicroseconds, this.getHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotOrientation(double alpha, double beta, double gamma) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0) {
                this.nativeGotOrientation(this.mNativePtr, alpha, beta, gamma);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotAcceleration(double x, double y, double z) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0) {
                this.nativeGotAcceleration(this.mNativePtr, x, y, z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotAccelerationIncludingGravity(double x, double y, double z) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0) {
                this.nativeGotAccelerationIncludingGravity(this.mNativePtr, x, y, z);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gotRotationRate(double alpha, double beta, double gamma) {
        Object object = this.mNativePtrLock;
        synchronized (object) {
            if (this.mNativePtr != 0) {
                this.nativeGotRotationRate(this.mNativePtr, alpha, beta, gamma);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler getHandler() {
        Object object = this.mHandlerLock;
        synchronized (object) {
            if (this.mHandler == null) {
                HandlerThread thread = new HandlerThread(TAG);
                thread.start();
                this.mHandler = new Handler(thread.getLooper());
            }
            return this.mHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    static DeviceMotionAndOrientation getInstance() {
        Object object = sSingletonLock;
        synchronized (object) {
            if (sSingleton == null) {
                sSingleton = new DeviceMotionAndOrientation();
            }
            return sSingleton;
        }
    }

    private native void nativeGotOrientation(int var1, double var2, double var4, double var6);

    private native void nativeGotAcceleration(int var1, double var2, double var4, double var6);

    private native void nativeGotAccelerationIncludingGravity(int var1, double var2, double var4, double var6);

    private native void nativeGotRotationRate(int var1, double var2, double var4, double var6);

    static {
        sSingletonLock = new Object();
        DEVICE_ORIENTATION_SENSORS = ImmutableSet.of(1, 2);
        DEVICE_MOTION_SENSORS = ImmutableSet.of(1, 10, 4);
    }

    static class SensorManagerProxyImpl
    implements SensorManagerProxy {
        private final SensorManager mSensorManager;

        SensorManagerProxyImpl(SensorManager sensorManager) {
            this.mSensorManager = sensorManager;
        }

        public boolean registerListener(SensorEventListener listener, int sensorType, int rate, Handler handler) {
            List<Sensor> sensors = this.mSensorManager.getSensorList(sensorType);
            if (sensors.isEmpty()) {
                return false;
            }
            return this.mSensorManager.registerListener(listener, sensors.get(0), rate, handler);
        }

        public void unregisterListener(SensorEventListener listener, int sensorType) {
            List<Sensor> sensors = this.mSensorManager.getSensorList(sensorType);
            if (!sensors.isEmpty()) {
                this.mSensorManager.unregisterListener(listener, sensors.get(0));
            }
        }
    }

    static interface SensorManagerProxy {
        public boolean registerListener(SensorEventListener var1, int var2, int var3, Handler var4);

        public void unregisterListener(SensorEventListener var1, int var2);
    }
}

