/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.content.pm.PackageManager;
import org.chromium.content.common.CommandLine;

public class DeviceUtils {
    private static final int MINIMUM_TABLET_WIDTH_DP = 600;
    private static Boolean sIsTv = null;
    private static Boolean sIsTablet = null;

    public static boolean isTablet(Context context) {
        if (sIsTablet == null) {
            if (DeviceUtils.isTv(context)) {
                sIsTablet = true;
                return sIsTablet;
            }
            int minimumScreenWidthDp = context.getResources().getConfiguration().smallestScreenWidthDp;
            sIsTablet = minimumScreenWidthDp >= 600;
        }
        return sIsTablet;
    }

    public static boolean isTv(Context context) {
        if (sIsTv == null) {
            PackageManager manager = context.getPackageManager();
            if (manager != null) {
                sIsTv = manager.hasSystemFeature("android.hardware.type.television");
                return sIsTv;
            }
            sIsTv = false;
        }
        return sIsTv;
    }

    public static void addDeviceSpecificUserAgentSwitch(Context context) {
        if (DeviceUtils.isTablet(context)) {
            CommandLine.getInstance().appendSwitch("tablet-ui");
        } else {
            CommandLine.getInstance().appendSwitch("use-mobile-user-agent");
        }
    }
}

