/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LongPressDetector {
    private MotionEvent mCurrentDownEvent;
    private final LongPressDelegate mLongPressDelegate;
    private final Handler mLongPressHandler;
    private final int mTouchSlopSquare;
    private boolean mInLongPress;
    private boolean mMoveConfirmed;
    private int mTouchInitialX;
    private int mTouchInitialY;
    private static final int LONG_PRESS = 2;
    private static final int LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
    private static final int TAP_TIMEOUT = ViewConfiguration.getTapTimeout();

    LongPressDetector(Context context, LongPressDelegate delegate) {
        this.mLongPressDelegate = delegate;
        this.mLongPressHandler = new LongPressHandler();
        ViewConfiguration configuration = ViewConfiguration.get(context);
        int touchSlop = configuration.getScaledTouchSlop();
        this.mTouchSlopSquare = touchSlop * touchSlop;
    }

    private static long calculateLongPressTimeoutTime(MotionEvent ev) {
        return ev.getEventTime() + (long)TAP_TIMEOUT + (long)LONGPRESS_TIMEOUT;
    }

    void startLongPressTimerIfNeeded(MotionEvent ev) {
        if (ev.getAction() != 0) {
            return;
        }
        if (this.mCurrentDownEvent != null) {
            return;
        }
        this.mCurrentDownEvent = MotionEvent.obtain(ev);
        this.mLongPressHandler.sendEmptyMessageAtTime(2, LongPressDetector.calculateLongPressTimeoutTime(this.mCurrentDownEvent));
        this.mInLongPress = false;
    }

    void cancelLongPressIfNeeded(MotionEvent ev) {
        if (!this.hasPendingMessage() || this.mCurrentDownEvent == null || ev.getDownTime() != this.mCurrentDownEvent.getDownTime()) {
            return;
        }
        int action = ev.getAction();
        float y = ev.getY();
        float x = ev.getX();
        switch (action & 0xFF) {
            case 2: {
                int deltaX = (int)(x - this.mCurrentDownEvent.getX());
                int deltaY = (int)(y - this.mCurrentDownEvent.getY());
                int distance = deltaX * deltaX + deltaY * deltaY;
                if (distance <= this.mTouchSlopSquare) break;
                this.cancelLongPress();
                break;
            }
            case 1: 
            case 3: {
                if (LongPressDetector.calculateLongPressTimeoutTime(this.mCurrentDownEvent) <= ev.getEventTime()) break;
                this.cancelLongPress();
                break;
            }
        }
    }

    void cancelLongPressIfNeeded(Iterator<MotionEvent> pendingEvents) {
        MotionEvent pending;
        if (this.mCurrentDownEvent == null) {
            return;
        }
        long currentDownTime = this.mCurrentDownEvent.getDownTime();
        while (pendingEvents.hasNext() && (pending = pendingEvents.next()).getDownTime() == currentDownTime) {
            this.cancelLongPressIfNeeded(pending);
        }
    }

    void cancelLongPress() {
        this.mInLongPress = false;
        if (this.hasPendingMessage()) {
            this.mLongPressHandler.removeMessages(2);
            this.mCurrentDownEvent.recycle();
            this.mCurrentDownEvent = null;
        }
    }

    boolean isInLongPress() {
        return this.mInLongPress;
    }

    private void dispatchLongPress() {
        this.mInLongPress = true;
        this.mLongPressDelegate.onLongPress(this.mCurrentDownEvent);
        this.mCurrentDownEvent.recycle();
        this.mCurrentDownEvent = null;
    }

    boolean hasPendingMessage() {
        return this.mCurrentDownEvent != null;
    }

    void onOfferTouchEventToJavaScript(MotionEvent event) {
        if (event.getActionMasked() == 0) {
            this.mMoveConfirmed = false;
            this.mTouchInitialX = Math.round(event.getX());
            this.mTouchInitialY = Math.round(event.getY());
        }
    }

    boolean confirmOfferMoveEventToJavaScript(MotionEvent event) {
        int deltaY;
        int deltaX;
        if (!this.mMoveConfirmed && (deltaX = Math.round(event.getX()) - this.mTouchInitialX) * deltaX + (deltaY = Math.round(event.getY()) - this.mTouchInitialY) * deltaY >= this.mTouchSlopSquare) {
            this.mMoveConfirmed = true;
        }
        return this.mMoveConfirmed;
    }

    void sendLongPressGestureForTest() {
        if (this.mCurrentDownEvent == null) {
            return;
        }
        this.dispatchLongPress();
    }

    static interface LongPressDelegate {
        public void onLongPress(MotionEvent var1);
    }

    private class LongPressHandler
    extends Handler {
        LongPressHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    LongPressDetector.this.dispatchLongPress();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown message " + msg);
                }
            }
        }
    }
}

