/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.media.MediaMetadataRetriever;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.util.HashMap;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.PathUtils;

@JNINamespace(value="content")
class MediaResourceGetter {
    private static final String TAG = "MediaResourceGetter";

    MediaResourceGetter() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNative
    private static MediaMetadata extractMediaMetadata(Context context, String url, String cookies) {
        int durationInMilliseconds = 0;
        int width = 0;
        int height = 0;
        boolean success = false;
        ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (mConnectivityManager != null) {
            if (context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") != 0) {
                return new MediaMetadata(0, 0, 0, false);
            }
            NetworkInfo info = mConnectivityManager.getActiveNetworkInfo();
            if (info == null) {
                return new MediaMetadata(durationInMilliseconds, width, height, success);
            }
            switch (info.getType()) {
                case 1: 
                case 9: {
                    break;
                }
                default: {
                    return new MediaMetadata(durationInMilliseconds, width, height, success);
                }
            }
        }
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        try {
            block13: {
                Uri uri = Uri.parse(url);
                String scheme = uri.getScheme();
                if (scheme == null || scheme.equals("file")) {
                    File file = new File(uri.getPath());
                    String path = file.getAbsolutePath();
                    if (file.exists() && (path.startsWith("/mnt/sdcard/") || path.startsWith("/sdcard/") || path.startsWith(PathUtils.getExternalStorageDirectory()))) {
                        retriever.setDataSource(path);
                        break block13;
                    } else {
                        Log.e(TAG, "Unable to read file: " + url);
                        return new MediaMetadata(durationInMilliseconds, width, height, success);
                    }
                }
                HashMap<String, String> headersMap = new HashMap<String, String>();
                if (!TextUtils.isEmpty(cookies)) {
                    headersMap.put("Cookie", cookies);
                }
                retriever.setDataSource(url, headersMap);
            }
            durationInMilliseconds = Integer.parseInt(retriever.extractMetadata(9));
            width = Integer.parseInt(retriever.extractMetadata(18));
            height = Integer.parseInt(retriever.extractMetadata(19));
            success = true;
            return new MediaMetadata(durationInMilliseconds, width, height, success);
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Invalid url: " + e);
            return new MediaMetadata(durationInMilliseconds, width, height, success);
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Invalid url: " + e);
        }
        return new MediaMetadata(durationInMilliseconds, width, height, success);
    }

    private static class MediaMetadata {
        private final int mDurationInMilliseconds;
        private final int mWidth;
        private final int mHeight;
        private final boolean mSuccess;

        private MediaMetadata(int durationInMilliseconds, int width, int height, boolean success) {
            this.mDurationInMilliseconds = durationInMilliseconds;
            this.mWidth = width;
            this.mHeight = height;
            this.mSuccess = success;
        }

        @CalledByNative(value="MediaMetadata")
        private int getDurationInMilliseconds() {
            return this.mDurationInMilliseconds;
        }

        @CalledByNative(value="MediaMetadata")
        private int getWidth() {
            return this.mWidth;
        }

        @CalledByNative(value="MediaMetadata")
        private int getHeight() {
            return this.mHeight;
        }

        @CalledByNative(value="MediaMetadata")
        private boolean isSuccess() {
            return this.mSuccess;
        }
    }
}

