/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import org.chromium.content.R;

public class SelectActionModeCallback
implements ActionMode.Callback {
    private Context mContext;
    private ActionHandler mActionHandler;
    private final boolean mIncognito;
    private boolean mEditable;

    protected SelectActionModeCallback(Context context, ActionHandler actionHandler, boolean incognito) {
        this.mContext = context;
        this.mActionHandler = actionHandler;
        this.mIncognito = incognito;
    }

    protected Context getContext() {
        return this.mContext;
    }

    public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
        mode.setTitle(null);
        mode.setSubtitle(null);
        this.mEditable = this.mActionHandler.isSelectionEditable();
        this.createActionMenu(mode, menu2);
        return true;
    }

    public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
        boolean isEditableNow = this.mActionHandler.isSelectionEditable();
        if (this.mEditable != isEditableNow) {
            this.mEditable = isEditableNow;
            menu2.clear();
            this.createActionMenu(mode, menu2);
            return true;
        }
        return false;
    }

    private void createActionMenu(ActionMode mode, Menu menu2) {
        mode.getMenuInflater().inflate(R.menu.select_action_menu, menu2);
        if (!this.mEditable || !this.canPaste()) {
            menu2.removeItem(R.id.select_action_menu_paste);
        }
        if (!this.mEditable) {
            menu2.removeItem(R.id.select_action_menu_cut);
        }
        if (this.mEditable || !this.isShareHandlerAvailable()) {
            menu2.removeItem(R.id.select_action_menu_share);
        }
        if (this.mEditable || this.mIncognito || !this.isWebSearchAvailable()) {
            menu2.removeItem(R.id.select_action_menu_web_search);
        }
    }

    public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
        String selection = this.mActionHandler.getSelectedText();
        int id2 = item.getItemId();
        if (id2 == R.id.select_action_menu_select_all) {
            this.mActionHandler.selectAll();
        } else if (id2 == R.id.select_action_menu_cut) {
            this.mActionHandler.cut();
        } else if (id2 == R.id.select_action_menu_copy) {
            this.mActionHandler.copy();
            mode.finish();
        } else if (id2 == R.id.select_action_menu_paste) {
            this.mActionHandler.paste();
        } else if (id2 == R.id.select_action_menu_share) {
            if (!TextUtils.isEmpty(selection)) {
                Intent send = new Intent("android.intent.action.SEND");
                send.setType("text/plain");
                send.putExtra("android.intent.extra.TEXT", selection);
                try {
                    Intent i = Intent.createChooser(send, this.getContext().getString(R.string.actionbar_share));
                    i.setFlags(0x10000000);
                    this.getContext().startActivity(i);
                }
                catch (ActivityNotFoundException ex) {
                    // empty catch block
                }
            }
            mode.finish();
        } else if (id2 == R.id.select_action_menu_web_search) {
            if (!TextUtils.isEmpty(selection)) {
                Intent i = new Intent("android.intent.action.WEB_SEARCH");
                i.putExtra("new_search", true);
                i.putExtra("query", selection);
                i.putExtra("com.android.browser.application_id", this.getContext().getPackageName());
                if (!(this.getContext() instanceof Activity)) {
                    i.addFlags(0x10000000);
                }
                try {
                    this.getContext().startActivity(i);
                }
                catch (ActivityNotFoundException ex) {
                    // empty catch block
                }
            }
            mode.finish();
        } else {
            return false;
        }
        return true;
    }

    public void onDestroyActionMode(ActionMode mode) {
        this.mActionHandler.onDestroyActionMode();
    }

    private boolean canPaste() {
        ClipboardManager clipMgr = (ClipboardManager)this.getContext().getSystemService("clipboard");
        return clipMgr.hasPrimaryClip();
    }

    private boolean isShareHandlerAvailable() {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        return this.getContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    private boolean isWebSearchAvailable() {
        Intent intent = new Intent("android.intent.action.WEB_SEARCH");
        intent.putExtra("new_search", true);
        return this.getContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    public static interface ActionHandler {
        public boolean selectAll();

        public boolean copy();

        public boolean cut();

        public boolean paste();

        public boolean isSelectionEditable();

        public String getSelectedText();

        public void onDestroyActionMode();
    }
}

