/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.animation.TimeAnimator;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.view.MotionEvent;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.content.browser.ContentViewCore;

@JNINamespace(value="content")
public class SmoothScroller {
    private final ContentViewCore mContentViewCore;
    private final boolean mScrollDown;
    private final float mMouseEventX;
    private final float mMouseEventY;
    private final Handler mHandler = new Handler(ThreadUtils.getUiThreadLooper());
    private TimeAnimator mTimeAnimator;
    private int mNativePtr;
    private long mDownTime;
    private float mCurrentY;
    private final byte STATE_INITIAL = 0;
    private final byte STATE_MOVING = 1;
    private final byte STATE_PENDING_UP = (byte)2;
    private final byte STATE_FINAL = (byte)3;
    private byte state = 0;

    SmoothScroller(ContentViewCore contentViewCore, boolean scrollDown, int mouseEventX, int mouseEventY) {
        this.mContentViewCore = contentViewCore;
        this.mScrollDown = scrollDown;
        float scale = this.mContentViewCore.getRenderCoordinates().getDeviceScaleFactor();
        this.mMouseEventX = (float)mouseEventX * scale;
        this.mCurrentY = this.mMouseEventY = (float)mouseEventY * scale;
    }

    @CalledByNative
    void start(int nativePtr) {
        assert (this.mNativePtr == 0);
        this.mNativePtr = nativePtr;
        Runnable runnable = Build.VERSION.SDK_INT >= 16 ? this.createJBRunnable() : this.createPreJBRunnable();
        this.mHandler.post(runnable);
    }

    boolean sendEvent(long time) {
        switch (this.state) {
            case 0: {
                this.mDownTime = SystemClock.uptimeMillis();
                MotionEvent event = MotionEvent.obtain(this.mDownTime, this.mDownTime, 0, this.mMouseEventX, this.mCurrentY, 0);
                this.mContentViewCore.onTouchEvent(event);
                event.recycle();
                this.state = 1;
                break;
            }
            case 1: {
                double delta = this.nativeGetScrollDelta(this.mNativePtr, this.mContentViewCore.getRenderCoordinates().getDeviceScaleFactor());
                if (delta != 0.0) {
                    this.mCurrentY = (float)((double)this.mCurrentY + (this.mScrollDown ? -delta : delta));
                    MotionEvent event = MotionEvent.obtain(this.mDownTime, time, 2, this.mMouseEventX, this.mCurrentY, 0);
                    this.mContentViewCore.onTouchEvent(event);
                    event.recycle();
                }
                if (!this.nativeHasFinished(this.mNativePtr)) break;
                this.state = (byte)2;
                break;
            }
            case 2: {
                MotionEvent event = MotionEvent.obtain(this.mDownTime, time, 1, this.mMouseEventX, this.mCurrentY, 0);
                this.mContentViewCore.onTouchEvent(event);
                event.recycle();
                this.nativeSetHasSentMotionUp(this.mNativePtr);
                this.state = (byte)3;
                break;
            }
        }
        return this.state != 3;
    }

    private Runnable createJBRunnable() {
        return new Runnable(){

            public void run() {
                SmoothScroller.this.mTimeAnimator = new TimeAnimator();
                SmoothScroller.this.mTimeAnimator.setTimeListener(new TimeAnimator.TimeListener(){

                    public void onTimeUpdate(TimeAnimator animation, long totalTime, long deltaTime) {
                        if (!SmoothScroller.this.sendEvent(SmoothScroller.this.mDownTime + totalTime)) {
                            SmoothScroller.this.mTimeAnimator.end();
                        }
                    }
                });
                SmoothScroller.this.mTimeAnimator.start();
            }
        };
    }

    private Runnable createPreJBRunnable() {
        return new Runnable(){

            public void run() {
                if (SmoothScroller.this.sendEvent(SystemClock.uptimeMillis())) {
                    SmoothScroller.this.mHandler.post(this);
                }
            }
        };
    }

    private native double nativeGetScrollDelta(int var1, double var2);

    private native boolean nativeHasFinished(int var1);

    private native void nativeSetHasSentMotionUp(int var1);
}

