/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.ContentViewCore;

@JNINamespace(value="content")
public abstract class WebContentsObserverAndroid {
    private int mNativeWebContentsObserverAndroid;

    public WebContentsObserverAndroid(ContentViewCore contentViewCore) {
        this.mNativeWebContentsObserverAndroid = this.nativeInit(contentViewCore.getNativeContentViewCore());
    }

    @CalledByNative
    public void didStartLoading(String url) {
    }

    @CalledByNative
    public void didStopLoading(String url) {
    }

    @CalledByNative
    public void didFailLoad(boolean isProvisionalLoad, boolean isMainFrame, int errorCode, String description, String failingUrl) {
    }

    @CalledByNative
    public void didNavigateMainFrame(String url, String baseUrl, boolean isNavigationToDifferentPage) {
    }

    @CalledByNative
    public void didNavigateAnyFrame(String url, String baseUrl, boolean isReload) {
    }

    @CalledByNative
    public void didStartProvisionalLoadForFrame(long frameId, long parentFrameId, boolean isMainFrame, String validatedUrl, boolean isErrorPage, boolean isIframeSrcdoc) {
    }

    @CalledByNative
    public void didCommitProvisionalLoadForFrame(long frameId, boolean isMainFrame, String url, int transitionType) {
    }

    @CalledByNative
    public void didFinishLoad(long frameId, String validatedUrl, boolean isMainFrame) {
    }

    @CalledByNative
    public void didChangeVisibleSSLState() {
    }

    @CalledByNative
    public void detachFromWebContents() {
        if (this.mNativeWebContentsObserverAndroid != 0) {
            this.nativeDestroy(this.mNativeWebContentsObserverAndroid);
            this.mNativeWebContentsObserverAndroid = 0;
        }
    }

    private native int nativeInit(int var1);

    private native void nativeDestroy(int var1);
}

