/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import org.chromium.content.browser.ContentViewCore;

class ZoomManager {
    private static final String TAG = "ContentViewZoom";
    private ContentViewCore mContentViewCore;
    private ScaleGestureDetector mMultiTouchDetector;
    private ScaleGestureListener mMultiTouchListener;

    ZoomManager(Context context, ContentViewCore contentViewCore) {
        this.mContentViewCore = contentViewCore;
        this.mMultiTouchListener = new ScaleGestureListener();
        this.mMultiTouchDetector = new ScaleGestureDetector(context, this.mMultiTouchListener);
    }

    boolean isScaleGestureDetectionInProgress() {
        return !this.mMultiTouchListener.getPermanentlyIgnoreDetectorEvents() && this.mMultiTouchDetector.isInProgress();
    }

    void passTouchEventThrough(MotionEvent event) {
        block2: {
            this.mMultiTouchListener.setTemporarilyIgnoreDetectorEvents(true);
            try {
                this.mMultiTouchDetector.onTouchEvent(event);
            }
            catch (Exception e) {
                Log.e(TAG, "ScaleGestureDetector got into a bad state!", e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    boolean processTouchEvent(MotionEvent event) {
        this.mMultiTouchListener.setTemporarilyIgnoreDetectorEvents(false);
        try {
            boolean inGesture = this.isScaleGestureDetectionInProgress();
            boolean retVal = this.mMultiTouchDetector.onTouchEvent(event);
            if (!(inGesture || event.getActionMasked() != 1 && event.getActionMasked() != 3)) {
                return false;
            }
            return retVal;
        }
        catch (Exception e) {
            Log.e(TAG, "ScaleGestureDetector got into a bad state!", e);
            assert (false);
            return false;
        }
    }

    void updateMultiTouchSupport(boolean supportsMultiTouchZoom) {
        this.mMultiTouchListener.setPermanentlyIgnoreDetectorEvents(!supportsMultiTouchZoom);
    }

    private class ScaleGestureListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        private boolean mPermanentlyIgnoreDetectorEvents = false;
        private boolean mTemporarilyIgnoreDetectorEvents = false;
        private boolean mPinchEventSent;

        private ScaleGestureListener() {
        }

        boolean getPermanentlyIgnoreDetectorEvents() {
            return this.mPermanentlyIgnoreDetectorEvents;
        }

        void setPermanentlyIgnoreDetectorEvents(boolean value) {
            this.mPermanentlyIgnoreDetectorEvents = value;
        }

        void setTemporarilyIgnoreDetectorEvents(boolean value) {
            this.mTemporarilyIgnoreDetectorEvents = value;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            if (this.ignoreDetectorEvents()) {
                return false;
            }
            this.mPinchEventSent = false;
            ZoomManager.this.mContentViewCore.getContentViewGestureHandler().setIgnoreSingleTap(true);
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            if (!this.mPinchEventSent || !ZoomManager.this.mContentViewCore.isAlive()) {
                return;
            }
            ZoomManager.this.mContentViewCore.getContentViewGestureHandler().pinchEnd(detector.getEventTime());
            this.mPinchEventSent = false;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (this.ignoreDetectorEvents()) {
                return false;
            }
            if (!this.mPinchEventSent) {
                ZoomManager.this.mContentViewCore.getContentViewGestureHandler().pinchBegin(detector.getEventTime(), (int)detector.getFocusX(), (int)detector.getFocusY());
                this.mPinchEventSent = true;
            }
            ZoomManager.this.mContentViewCore.getContentViewGestureHandler().pinchBy(detector.getEventTime(), (int)detector.getFocusX(), (int)detector.getFocusY(), detector.getScaleFactor());
            return true;
        }

        private boolean ignoreDetectorEvents() {
            return this.mPermanentlyIgnoreDetectorEvents || this.mTemporarilyIgnoreDetectorEvents || !ZoomManager.this.mContentViewCore.isAlive();
        }
    }
}

