/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.text.Editable;
import android.text.Selection;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import com.google.common.annotations.VisibleForTesting;
import org.chromium.content.browser.input.ImeAdapter;
import org.chromium.content.browser.input.InputMethodManagerWrapper;

public class AdapterInputConnection
extends BaseInputConnection {
    private static final String TAG = "org.chromium.content.browser.input.AdapterInputConnection";
    private static final boolean DEBUG = false;
    public static final int INVALID_SELECTION = -1;
    public static final int INVALID_COMPOSITION = -1;
    private final View mInternalView;
    private final ImeAdapter mImeAdapter;
    private boolean mSingleLine;
    private int mNumNestedBatchEdits = 0;
    private boolean mIgnoreTextInputStateUpdates = false;
    private int mLastUpdateSelectionStart = -1;
    private int mLastUpdateSelectionEnd = -1;
    private int mLastUpdateCompositionStart = -1;
    private int mLastUpdateCompositionEnd = -1;

    @VisibleForTesting
    AdapterInputConnection(View view, ImeAdapter imeAdapter, EditorInfo outAttrs) {
        super(view, true);
        this.mInternalView = view;
        this.mImeAdapter = imeAdapter;
        this.mImeAdapter.setInputConnection(this);
        this.mSingleLine = true;
        outAttrs.imeOptions = 0x12000000;
        outAttrs.inputType = 161;
        if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeText) {
            outAttrs.imeOptions |= 2;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeTextArea || imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeContentEditable) {
            outAttrs.inputType |= 0x2C000;
            outAttrs.imeOptions |= 1;
            this.mSingleLine = false;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypePassword) {
            outAttrs.inputType = 225;
            outAttrs.imeOptions |= 2;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeSearch) {
            outAttrs.imeOptions |= 3;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeUrl) {
            outAttrs.imeOptions |= 2;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeEmail) {
            outAttrs.inputType = 209;
            outAttrs.imeOptions |= 2;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeTel) {
            outAttrs.inputType = 3;
            outAttrs.imeOptions |= 5;
        } else if (imeAdapter.getTextInputType() == ImeAdapter.sTextInputTypeNumber) {
            outAttrs.inputType = 2;
            outAttrs.imeOptions |= 5;
        }
        outAttrs.initialSelStart = imeAdapter.getInitialSelectionStart();
        outAttrs.initialSelEnd = imeAdapter.getInitialSelectionStart();
    }

    public void setEditableText(String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd) {
        text = text.replace('\u00a0', ' ');
        selectionStart = Math.min(selectionStart, text.length());
        selectionEnd = Math.min(selectionEnd, text.length());
        compositionStart = Math.min(compositionStart, text.length());
        compositionEnd = Math.min(compositionEnd, text.length());
        Editable editable = this.getEditable();
        String prevText = editable.toString();
        boolean textUnchanged = prevText.equals(text);
        if (!textUnchanged) {
            editable.replace(0, editable.length(), text);
        }
        int prevSelectionStart = Selection.getSelectionStart(editable);
        int prevSelectionEnd = Selection.getSelectionEnd(editable);
        int prevCompositionStart = AdapterInputConnection.getComposingSpanStart(editable);
        int prevCompositionEnd = AdapterInputConnection.getComposingSpanEnd(editable);
        if (prevSelectionStart == selectionStart && prevSelectionEnd == selectionEnd && prevCompositionStart == compositionStart && prevCompositionEnd == compositionEnd) {
            return;
        }
        Selection.setSelection(editable, selectionStart, selectionEnd);
        if (compositionStart == compositionEnd) {
            AdapterInputConnection.removeComposingSpans(editable);
        } else {
            super.setComposingRegion(compositionStart, compositionEnd);
        }
        if (this.mIgnoreTextInputStateUpdates) {
            return;
        }
        this.updateSelection(selectionStart, selectionEnd, compositionStart, compositionEnd);
    }

    @VisibleForTesting
    protected void updateSelection(int selectionStart, int selectionEnd, int compositionStart, int compositionEnd) {
        if (this.mLastUpdateSelectionStart == selectionStart && this.mLastUpdateSelectionEnd == selectionEnd && this.mLastUpdateCompositionStart == compositionStart && this.mLastUpdateCompositionEnd == compositionEnd) {
            return;
        }
        this.getInputMethodManagerWrapper().updateSelection(this.mInternalView, selectionStart, selectionEnd, compositionStart, compositionEnd);
        this.mLastUpdateSelectionStart = selectionStart;
        this.mLastUpdateSelectionEnd = selectionEnd;
        this.mLastUpdateCompositionStart = compositionStart;
        this.mLastUpdateCompositionEnd = compositionEnd;
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        super.setComposingText(text, newCursorPosition);
        return this.mImeAdapter.checkCompositionQueueAndCallNative(((Object)text).toString(), newCursorPosition, false);
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        super.commitText(text, newCursorPosition);
        return this.mImeAdapter.checkCompositionQueueAndCallNative(((Object)text).toString(), newCursorPosition, text.length() > 0);
    }

    public boolean performEditorAction(int actionCode) {
        if (actionCode == 5) {
            this.restartInput();
            long timeStampMs = System.currentTimeMillis();
            this.mImeAdapter.sendSyntheticKeyEvent(ImeAdapter.sEventTypeRawKeyDown, timeStampMs, 61, 0);
        } else {
            this.mImeAdapter.sendKeyEventWithKeyCode(66, 22);
        }
        return true;
    }

    public boolean performContextMenuAction(int id2) {
        switch (id2) {
            case 16908319: {
                return this.mImeAdapter.selectAll();
            }
            case 0x1020020: {
                return this.mImeAdapter.cut();
            }
            case 0x1020021: {
                return this.mImeAdapter.copy();
            }
            case 0x1020022: {
                return this.mImeAdapter.paste();
            }
        }
        return false;
    }

    public ExtractedText getExtractedText(ExtractedTextRequest request, int flags) {
        ExtractedText et = new ExtractedText();
        Editable editable = this.getEditable();
        et.text = editable.toString();
        et.partialEndOffset = editable.length();
        et.selectionStart = Selection.getSelectionStart(editable);
        et.selectionEnd = Selection.getSelectionEnd(editable);
        et.flags = this.mSingleLine ? 1 : 0;
        return et;
    }

    public boolean beginBatchEdit() {
        if (this.mNumNestedBatchEdits == 0) {
            this.mImeAdapter.batchStateChanged(true);
        }
        ++this.mNumNestedBatchEdits;
        return false;
    }

    public boolean endBatchEdit() {
        if (this.mNumNestedBatchEdits == 0) {
            return false;
        }
        --this.mNumNestedBatchEdits;
        if (this.mNumNestedBatchEdits == 0) {
            this.mImeAdapter.batchStateChanged(false);
        }
        return false;
    }

    public boolean deleteSurroundingText(int leftLength, int rightLength) {
        if (!super.deleteSurroundingText(leftLength, rightLength)) {
            return false;
        }
        return this.mImeAdapter.deleteSurroundingText(leftLength, rightLength);
    }

    public boolean sendKeyEvent(KeyEvent event) {
        if (event.getAction() == 1) {
            if (event.getKeyCode() == 67) {
                this.deleteSurroundingText(1, 0);
                return true;
            }
            if (event.getKeyCode() == 112) {
                this.deleteSurroundingText(0, 1);
                return true;
            }
            int unicodeChar = event.getUnicodeChar();
            if (unicodeChar != 0) {
                int selectionEnd;
                Editable editable = this.getEditable();
                int selectionStart = Selection.getSelectionStart(editable);
                if (selectionStart > (selectionEnd = Selection.getSelectionEnd(editable))) {
                    int temp = selectionStart;
                    selectionStart = selectionEnd;
                    selectionEnd = temp;
                }
                editable.replace(selectionStart, selectionEnd, Character.toString((char)unicodeChar));
            }
        } else if (event.getAction() == 0) {
            if (event.getKeyCode() == 67) {
                return true;
            }
            if (event.getKeyCode() == 112) {
                return true;
            }
        }
        this.mImeAdapter.translateAndSendNativeEvents(event);
        return true;
    }

    public boolean finishComposingText() {
        Editable editable = this.getEditable();
        if (AdapterInputConnection.getComposingSpanStart(editable) == AdapterInputConnection.getComposingSpanEnd(editable)) {
            return true;
        }
        super.finishComposingText();
        this.mImeAdapter.finishComposingText();
        return true;
    }

    public boolean setSelection(int start, int end) {
        if (start < 0 || end < 0) {
            return true;
        }
        super.setSelection(start, end);
        return this.mImeAdapter.setEditableSelectionOffsets(start, end);
    }

    void restartInput() {
        this.getInputMethodManagerWrapper().restartInput(this.mInternalView);
        this.mIgnoreTextInputStateUpdates = false;
        this.mNumNestedBatchEdits = 0;
    }

    public boolean setComposingRegion(int start, int end) {
        int a = Math.min(start, end);
        int b = Math.max(start, end);
        if (a < 0) {
            a = 0;
        }
        if (b < 0) {
            b = 0;
        }
        if (a == b) {
            AdapterInputConnection.removeComposingSpans(this.getEditable());
        } else {
            super.setComposingRegion(a, b);
        }
        return this.mImeAdapter.setComposingRegion(a, b);
    }

    boolean isActive() {
        return this.getInputMethodManagerWrapper().isActive(this.mInternalView);
    }

    public void setIgnoreTextInputStateUpdates(boolean shouldIgnore) {
        this.mIgnoreTextInputStateUpdates = shouldIgnore;
        if (shouldIgnore) {
            return;
        }
        Editable editable = this.getEditable();
        this.updateSelection(Selection.getSelectionStart(editable), Selection.getSelectionEnd(editable), AdapterInputConnection.getComposingSpanStart(editable), AdapterInputConnection.getComposingSpanEnd(editable));
    }

    @VisibleForTesting
    protected boolean isIgnoringTextInputStateUpdates() {
        return this.mIgnoreTextInputStateUpdates;
    }

    private InputMethodManagerWrapper getInputMethodManagerWrapper() {
        return this.mImeAdapter.getInputMethodManagerWrapper();
    }
}

