/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser.input;

import android.content.Context;
import java.util.Calendar;
import org.chromium.content.R;
import org.chromium.content.browser.input.TwoFieldDatePicker;

public class WeekPicker
extends TwoFieldDatePicker {
    public WeekPicker(Context context, long minValue, long maxValue) {
        super(context, minValue, maxValue);
        this.getPositionInYearSpinner().setContentDescription(this.getResources().getString(R.string.accessibility_date_picker_week));
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        cal.setTimeInMillis(System.currentTimeMillis());
        this.init(WeekPicker.getISOWeekYearForDate(cal), WeekPicker.getWeekForDate(cal), null);
    }

    private Calendar createDateFromWeek(int year, int week) {
        Calendar date = Calendar.getInstance();
        date.clear();
        date.setFirstDayOfWeek(2);
        date.setMinimalDaysInFirstWeek(4);
        date.set(7, 2);
        date.set(1, year);
        date.set(3, week);
        return date;
    }

    protected Calendar createDateFromValue(long value) {
        Calendar date = Calendar.getInstance();
        date.clear();
        date.setFirstDayOfWeek(2);
        date.setMinimalDaysInFirstWeek(4);
        date.setTimeInMillis(value);
        return date;
    }

    public static int getISOWeekYearForDate(Calendar date) {
        int year = date.get(1);
        int month = date.get(2);
        int week = date.get(3);
        if (month == 0 && week > 51) {
            --year;
        } else if (month == 11 && week == 1) {
            ++year;
        }
        return year;
    }

    public static int getWeekForDate(Calendar date) {
        return date.get(3);
    }

    protected void setCurrentDate(int year, int week) {
        Calendar date = this.createDateFromWeek(year, week);
        if (date.before(this.getMinDate())) {
            this.setCurrentDate(this.getMinDate());
        } else if (date.after(this.getMaxDate())) {
            this.setCurrentDate(this.getMaxDate());
        } else {
            this.setCurrentDate(date);
        }
    }

    private int getNumberOfWeeks(int year) {
        Calendar date = this.createDateFromWeek(year, 20);
        return date.getActualMaximum(3);
    }

    public int getYear() {
        return WeekPicker.getISOWeekYearForDate(this.getCurrentDate());
    }

    public int getWeek() {
        return WeekPicker.getWeekForDate(this.getCurrentDate());
    }

    public int getPositionInYear() {
        return this.getWeek();
    }

    protected int getMaxYear() {
        return WeekPicker.getISOWeekYearForDate(this.getMaxDate());
    }

    protected int getMinYear() {
        return WeekPicker.getISOWeekYearForDate(this.getMinDate());
    }

    protected int getMaxPositionInYear(int year) {
        if (year == WeekPicker.getISOWeekYearForDate(this.getMaxDate())) {
            return WeekPicker.getWeekForDate(this.getMaxDate());
        }
        return this.getNumberOfWeeks(year);
    }

    protected int getMinPositionInYear(int year) {
        if (year == WeekPicker.getISOWeekYearForDate(this.getMinDate())) {
            return WeekPicker.getWeekForDate(this.getMinDate());
        }
        return 1;
    }
}

