/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.util.Log;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="media")
class AudioManagerAndroid {
    private static final String TAG = "AudioManagerAndroid";
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;
    private final AudioManager mAudioManager;
    private final Context mContext;
    private BroadcastReceiver mReceiver;
    private boolean mOriginalSpeakerStatus;

    @CalledByNative
    public void setMode(int mode) {
        try {
            this.mAudioManager.setMode(mode);
            if (mode == 3) {
                this.mAudioManager.setSpeakerphoneOn(true);
            }
        }
        catch (SecurityException e) {
            Log.e(TAG, "setMode exception: " + e.getMessage());
            this.logDeviceInfo();
        }
    }

    @CalledByNative
    private static AudioManagerAndroid createAudioManagerAndroid(Context context) {
        return new AudioManagerAndroid(context);
    }

    private AudioManagerAndroid(Context context) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    @CalledByNative
    public void registerHeadsetReceiver() {
        if (this.mReceiver != null) {
            return;
        }
        this.mOriginalSpeakerStatus = this.mAudioManager.isSpeakerphoneOn();
        IntentFilter filter = new IntentFilter("android.intent.action.HEADSET_PLUG");
        this.mReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if ("android.intent.action.HEADSET_PLUG".equals(intent.getAction())) {
                    try {
                        AudioManagerAndroid.this.mAudioManager.setSpeakerphoneOn(intent.getIntExtra("state", 0) == 0);
                    }
                    catch (SecurityException e) {
                        Log.e(AudioManagerAndroid.TAG, "setMode exception: " + e.getMessage());
                        AudioManagerAndroid.this.logDeviceInfo();
                    }
                }
            }
        };
        this.mContext.registerReceiver(this.mReceiver, filter);
    }

    @CalledByNative
    public void unregisterHeadsetReceiver() {
        this.mContext.unregisterReceiver(this.mReceiver);
        this.mReceiver = null;
        this.mAudioManager.setSpeakerphoneOn(this.mOriginalSpeakerStatus);
    }

    private void logDeviceInfo() {
        Log.i(TAG, "Manufacturer:" + Build.MANUFACTURER + " Board: " + Build.BOARD + " Device: " + Build.DEVICE + " Model: " + Build.MODEL + " PRODUCT: " + Build.PRODUCT);
    }

    @CalledByNative
    private int getNativeOutputSampleRate() {
        if (Build.VERSION.SDK_INT >= 17) {
            String sampleRateString = this.mAudioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            return sampleRateString == null ? 44100 : Integer.parseInt(sampleRateString);
        }
        return 44100;
    }

    @CalledByNative
    private static int getMinInputFrameSize(int sampleRate, int channels) {
        int channelConfig;
        if (channels == 1) {
            channelConfig = 16;
        } else if (channels == 2) {
            channelConfig = 12;
        } else {
            return -1;
        }
        return AudioRecord.getMinBufferSize(sampleRate, channelConfig, 2) / 2 / channels;
    }

    @CalledByNative
    private static int getMinOutputFrameSize(int sampleRate, int channels) {
        int channelConfig;
        if (channels == 1) {
            channelConfig = 4;
        } else if (channels == 2) {
            channelConfig = 12;
        } else {
            return -1;
        }
        return AudioTrack.getMinBufferSize(sampleRate, channelConfig, 2) / 2 / channels;
    }

    @CalledByNative
    private boolean isAudioLowLatencySupported() {
        return this.mContext.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    @CalledByNative
    private int getAudioLowLatencyOutputFrameSize() {
        String framesPerBuffer = this.mAudioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return framesPerBuffer == null ? 256 : Integer.parseInt(framesPerBuffer);
    }
}

