/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.media;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="media")
public class MediaPlayerBridge {
    private static final String TAG = "MediaPlayerBridge";
    private MediaPlayer mPlayer;

    @CalledByNative
    private static MediaPlayerBridge create() {
        return new MediaPlayerBridge();
    }

    protected MediaPlayer getLocalPlayer() {
        if (this.mPlayer == null) {
            this.mPlayer = new MediaPlayer();
        }
        return this.mPlayer;
    }

    @CalledByNative
    protected void setSurface(Surface surface) {
        this.getLocalPlayer().setSurface(surface);
    }

    @CalledByNative
    protected void prepareAsync() throws IllegalStateException {
        this.getLocalPlayer().prepareAsync();
    }

    @CalledByNative
    protected boolean isPlaying() {
        return this.getLocalPlayer().isPlaying();
    }

    @CalledByNative
    protected int getVideoWidth() {
        return this.getLocalPlayer().getVideoWidth();
    }

    @CalledByNative
    protected int getVideoHeight() {
        return this.getLocalPlayer().getVideoHeight();
    }

    @CalledByNative
    protected int getCurrentPosition() {
        return this.getLocalPlayer().getCurrentPosition();
    }

    @CalledByNative
    protected int getDuration() {
        return this.getLocalPlayer().getDuration();
    }

    @CalledByNative
    protected void release() {
        this.getLocalPlayer().release();
    }

    @CalledByNative
    protected void setVolume(double volume) {
        this.getLocalPlayer().setVolume((float)volume, (float)volume);
    }

    @CalledByNative
    protected void start() {
        this.getLocalPlayer().start();
    }

    @CalledByNative
    protected void pause() {
        this.getLocalPlayer().pause();
    }

    @CalledByNative
    protected void seekTo(int msec) throws IllegalStateException {
        this.getLocalPlayer().seekTo(msec);
    }

    @CalledByNative
    protected boolean setDataSource(Context context, String url, String cookies, boolean hideUrlLog) {
        Uri uri = Uri.parse(url);
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (hideUrlLog) {
            headersMap.put("x-hide-urls-from-log", "true");
        }
        if (!TextUtils.isEmpty(cookies)) {
            headersMap.put("Cookie", cookies);
        }
        try {
            this.getLocalPlayer().setDataSource(context, uri, headersMap);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void setOnBufferingUpdateListener(MediaPlayer.OnBufferingUpdateListener listener) {
        this.getLocalPlayer().setOnBufferingUpdateListener(listener);
    }

    protected void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        this.getLocalPlayer().setOnCompletionListener(listener);
    }

    protected void setOnErrorListener(MediaPlayer.OnErrorListener listener) {
        this.getLocalPlayer().setOnErrorListener(listener);
    }

    protected void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        this.getLocalPlayer().setOnPreparedListener(listener);
    }

    protected void setOnSeekCompleteListener(MediaPlayer.OnSeekCompleteListener listener) {
        this.getLocalPlayer().setOnSeekCompleteListener(listener);
    }

    protected void setOnVideoSizeChangedListener(MediaPlayer.OnVideoSizeChangedListener listener) {
        this.getLocalPlayer().setOnVideoSizeChangedListener(listener);
    }

    @CalledByNative
    private static AllowedOperations getAllowedOperations(MediaPlayerBridge bridge) {
        MediaPlayer player = bridge.getLocalPlayer();
        boolean canPause = true;
        boolean canSeekForward = true;
        boolean canSeekBackward = true;
        try {
            Method getMetadata = player.getClass().getDeclaredMethod("getMetadata", Boolean.TYPE, Boolean.TYPE);
            getMetadata.setAccessible(true);
            Object data = getMetadata.invoke(player, false, false);
            if (data != null) {
                Class<?> metadataClass = data.getClass();
                Method hasMethod = metadataClass.getDeclaredMethod("has", Integer.TYPE);
                Method getBooleanMethod = metadataClass.getDeclaredMethod("getBoolean", Integer.TYPE);
                int pause = (Integer)metadataClass.getField("PAUSE_AVAILABLE").get(null);
                int seekForward = (Integer)metadataClass.getField("SEEK_FORWARD_AVAILABLE").get(null);
                int seekBackward = (Integer)metadataClass.getField("SEEK_BACKWARD_AVAILABLE").get(null);
                hasMethod.setAccessible(true);
                getBooleanMethod.setAccessible(true);
                canPause = (Boolean)hasMethod.invoke(data, pause) == false || (Boolean)getBooleanMethod.invoke(data, pause) != false;
                canSeekForward = (Boolean)hasMethod.invoke(data, seekForward) == false || (Boolean)getBooleanMethod.invoke(data, seekForward) != false;
                canSeekBackward = (Boolean)hasMethod.invoke(data, seekBackward) == false || (Boolean)getBooleanMethod.invoke(data, seekBackward) != false;
            }
        }
        catch (NoSuchMethodException e) {
            Log.e(TAG, "Cannot find getMetadata() method: " + e);
        }
        catch (InvocationTargetException e) {
            Log.e(TAG, "Cannot invoke MediaPlayer.getMetadata() method: " + e);
        }
        catch (IllegalAccessException e) {
            Log.e(TAG, "Cannot access metadata: " + e);
        }
        catch (NoSuchFieldException e) {
            Log.e(TAG, "Cannot find matching fields in Metadata class: " + e);
        }
        return new AllowedOperations(canPause, canSeekForward, canSeekBackward);
    }

    private static class AllowedOperations {
        private final boolean mCanPause;
        private final boolean mCanSeekForward;
        private final boolean mCanSeekBackward;

        private AllowedOperations(boolean canPause, boolean canSeekForward, boolean canSeekBackward) {
            this.mCanPause = canPause;
            this.mCanSeekForward = canSeekForward;
            this.mCanSeekBackward = canSeekBackward;
        }

        @CalledByNative(value="AllowedOperations")
        private boolean canPause() {
            return this.mCanPause;
        }

        @CalledByNative(value="AllowedOperations")
        private boolean canSeekForward() {
            return this.mCanSeekForward;
        }

        @CalledByNative(value="AllowedOperations")
        private boolean canSeekBackward() {
            return this.mCanSeekBackward;
        }
    }
}

