/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;

public class UiUtils {
    private static float KEYBOARD_DETECT_BOTTOM_THRESHOLD_DP = 100.0f;

    private UiUtils() {
    }

    public static void showKeyboard(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.showSoftInput(view, 1);
    }

    public static boolean hideKeyboard(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        return imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public static boolean isKeyboardShowing(Context context, View view) {
        View rootView = view.getRootView();
        if (rootView == null) {
            return false;
        }
        Rect appRect = new Rect();
        rootView.getWindowVisibleDisplayFrame(appRect);
        float screenHeight = context.getResources().getDisplayMetrics().heightPixels;
        float bottomMargin = Math.abs((float)appRect.bottom - screenHeight);
        float density = context.getResources().getDisplayMetrics().density;
        return bottomMargin > KEYBOARD_DETECT_BOTTOM_THRESHOLD_DP * density;
    }

    public static int insertBefore(ViewGroup container, View newView, View existingView) {
        return UiUtils.insertView(container, newView, existingView, false);
    }

    public static int insertAfter(ViewGroup container, View newView, View existingView) {
        return UiUtils.insertView(container, newView, existingView, true);
    }

    private static int insertView(ViewGroup container, View newView, View existingView, boolean after) {
        int index = container.indexOfChild(newView);
        if (index >= 0) {
            return index;
        }
        index = container.indexOfChild(existingView);
        if (index < 0) {
            return -1;
        }
        if (after) {
            ++index;
        }
        container.addView(newView, index);
        return index;
    }
}

