/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.autofill;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListPopupWindow;
import android.widget.TextView;
import java.util.ArrayList;
import org.chromium.ui.R;
import org.chromium.ui.ViewAndroidDelegate;
import org.chromium.ui.autofill.AutofillListAdapter;
import org.chromium.ui.autofill.AutofillSuggestion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutofillPopup
extends ListPopupWindow
implements AdapterView.OnItemClickListener {
    private static final int ITEM_ID_AUTOCOMPLETE_ENTRY = 0;
    private static final int ITEM_ID_PASSWORD_ENTRY = -2;
    private static final int ITEM_ID_DATA_LIST_ENTRY = -6;
    private static final int TEXT_PADDING_DP = 30;
    private final AutofillPopupDelegate mAutofillCallback;
    private final Context mContext;
    private final ViewAndroidDelegate mViewAndroidDelegate;
    private View mAnchorView;
    private float mAnchorWidth;
    private float mAnchorHeight;
    private float mAnchorX;
    private float mAnchorY;
    private Paint mLabelViewPaint;
    private Paint mSublabelViewPaint;
    private View.OnLayoutChangeListener mLayoutChangeListener;

    public AutofillPopup(Context context, ViewAndroidDelegate viewAndroidDelegate, AutofillPopupDelegate autofillCallback) {
        super(context, null, 0, R.style.AutofillPopupWindow);
        this.mContext = context;
        this.mViewAndroidDelegate = viewAndroidDelegate;
        this.mAutofillCallback = autofillCallback;
        this.setOnItemClickListener(this);
        this.mAnchorView = this.mViewAndroidDelegate.acquireAnchorView();
        this.mAnchorView.setId(R.id.autofill_popup_window);
        this.mAnchorView.setTag(this);
        this.mViewAndroidDelegate.setAnchorViewPosition(this.mAnchorView, this.mAnchorX, this.mAnchorY, this.mAnchorWidth, this.mAnchorHeight);
        this.mLayoutChangeListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (v == AutofillPopup.this.mAnchorView) {
                    AutofillPopup.this.show();
                }
            }
        };
        this.mAnchorView.addOnLayoutChangeListener(this.mLayoutChangeListener);
        this.setAnchorView(this.mAnchorView);
    }

    @Override
    public void show() {
        this.setInputMethodMode(1);
        super.show();
    }

    public void setAnchorRect(float x, float y, float width, float height) {
        this.mAnchorWidth = width;
        this.mAnchorHeight = height;
        this.mAnchorX = x;
        this.mAnchorY = y;
        if (this.mAnchorView != null) {
            this.mViewAndroidDelegate.setAnchorViewPosition(this.mAnchorView, this.mAnchorX, this.mAnchorY, this.mAnchorWidth, this.mAnchorHeight);
        }
    }

    public void show(AutofillSuggestion[] suggestions) {
        ArrayList<AutofillSuggestion> cleanedData = new ArrayList<AutofillSuggestion>();
        for (int i = 0; i < suggestions.length; ++i) {
            int itemId = suggestions[i].mUniqueId;
            if (itemId <= 0 && itemId != 0 && itemId != -2 && itemId != -6) continue;
            cleanedData.add(suggestions[i]);
        }
        this.setAdapter(new AutofillListAdapter(this.mContext, cleanedData));
        this.mAnchorWidth = Math.max(this.getDesiredWidth(cleanedData), this.mAnchorWidth);
        this.mViewAndroidDelegate.setAnchorViewPosition(this.mAnchorView, this.mAnchorX, this.mAnchorY, this.mAnchorWidth, this.mAnchorHeight);
    }

    @Override
    public void dismiss() {
        this.mAutofillCallback.requestHide();
    }

    public void hide() {
        super.dismiss();
        this.mAnchorView.removeOnLayoutChangeListener(this.mLayoutChangeListener);
        this.mAnchorView.setTag(null);
        this.mViewAndroidDelegate.releaseAnchorView(this.mAnchorView);
    }

    private float getDesiredWidth(ArrayList<AutofillSuggestion> data) {
        if (this.mLabelViewPaint == null || this.mSublabelViewPaint == null) {
            LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            View layout2 = inflater.inflate(R.layout.autofill_text, null);
            TextView labelView = (TextView)layout2.findViewById(R.id.autofill_label);
            this.mLabelViewPaint = labelView.getPaint();
            TextView sublabelView = (TextView)layout2.findViewById(R.id.autofill_sublabel);
            this.mSublabelViewPaint = sublabelView.getPaint();
        }
        float maxTextWidth = 0.0f;
        Rect bounds = new Rect();
        for (int i = 0; i < data.size(); ++i) {
            bounds.setEmpty();
            String label = data.get((int)i).mLabel;
            if (!TextUtils.isEmpty(label)) {
                this.mLabelViewPaint.getTextBounds(label, 0, label.length(), bounds);
            }
            float labelWidth = bounds.width();
            bounds.setEmpty();
            String sublabel = data.get((int)i).mSublabel;
            if (!TextUtils.isEmpty(sublabel)) {
                this.mSublabelViewPaint.getTextBounds(sublabel, 0, sublabel.length(), bounds);
            }
            float localMax = Math.max(labelWidth, (float)bounds.width());
            maxTextWidth = Math.max(maxTextWidth, localMax);
        }
        return (maxTextWidth /= this.mContext.getResources().getDisplayMetrics().density) + 30.0f;
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mAutofillCallback.suggestionSelected(position);
    }

    public static interface AutofillPopupDelegate {
        public void requestHide();

        public void suggestionSelected(int var1);
    }
}

