/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.ui.gfx;

import android.content.Context;
import android.graphics.PixelFormat;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="gfx")
public class DeviceDisplayInfo {
    private final Context mAppContext;
    private final WindowManager mWinManager;

    private DeviceDisplayInfo(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.mWinManager = (WindowManager)this.mAppContext.getSystemService("window");
    }

    @CalledByNative
    public int getDisplayHeight() {
        return this.getMetrics().heightPixels;
    }

    @CalledByNative
    public int getDisplayWidth() {
        return this.getMetrics().widthPixels;
    }

    private int getPixelFormat() {
        if (Build.VERSION.SDK_INT < 17) {
            return this.getDisplay().getPixelFormat();
        }
        return 1;
    }

    @CalledByNative
    public int getBitsPerPixel() {
        int format = this.getPixelFormat();
        PixelFormat info = new PixelFormat();
        PixelFormat.getPixelFormatInfo(format, info);
        return info.bitsPerPixel;
    }

    @CalledByNative
    public int getBitsPerComponent() {
        int format = this.getPixelFormat();
        switch (format) {
            case 7: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 1: 
            case 2: 
            case 3: {
                return 8;
            }
            case 11: {
                return 2;
            }
            case 4: {
                return 5;
            }
            case 8: 
            case 9: 
            case 10: {
                return 0;
            }
        }
        return 8;
    }

    @CalledByNative
    public double getDIPScale() {
        return this.getMetrics().density;
    }

    private Display getDisplay() {
        return this.mWinManager.getDefaultDisplay();
    }

    private DisplayMetrics getMetrics() {
        return this.mAppContext.getResources().getDisplayMetrics();
    }

    @CalledByNative
    public static DeviceDisplayInfo create(Context context) {
        return new DeviceDisplayInfo(context);
    }
}

