/*
 * Copyright (c) 2013 - present Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 */

package java.util.zip;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import com.facebook.infer.models.InferUndefined;


public class ZipOutputStream extends DeflaterOutputStream {

    public ZipOutputStream(OutputStream out) {
        super(out);
    }

    public void putNextEntry(ZipEntry e) throws IOException {
        InferUndefined.can_throw_ioexception_void();
    }

    public void closeEntry() throws IOException {
        InferUndefined.can_throw_ioexception_void();
    }

    public void close() throws IOException {
        if (out != null) {
            if (out instanceof FileOutputStream) {
                ((FileOutputStream) out).close();
            } else if (out instanceof BufferedOutputStream) {
                ((BufferedOutputStream) out).close();
            }
        }
    }
}
