// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

//
// This file specifies various assembly level attributes.
//

using MS.Internal.PresentationFramework;
using System;
using System.Resources;
using System.Runtime.InteropServices;
using System.Runtime.CompilerServices;
using System.Security;
using System.Windows.Markup;

[assembly:TypeForwardedTo(typeof(System.Windows.NameScope))]
[assembly:TypeForwardedTo(typeof(System.Windows.Markup.ArrayExtension))]
[assembly:TypeForwardedTo(typeof(System.Windows.Markup.IProvideValueTarget))]
[assembly:TypeForwardedTo(typeof(System.Windows.Markup.NullExtension))]
[assembly:TypeForwardedTo(typeof(System.Windows.Markup.StaticExtension))]
[assembly:TypeForwardedTo(typeof(System.Windows.Markup.TypeExtension))]

// IProvidePropertyFallback is an internal interface and not included in the PresentationCore reference assembly.
// Therefore we need to ensure it's not included in the PresentationFramework reference assembly as it won't be defined there.
#if !PRESENTATION_FRAMEWORK_REF
[assembly:TypeForwardedTo(typeof(System.Windows.Markup.IProvidePropertyFallback))]
#endif

[assembly:InternalsVisibleTo(BuildInfo.PresentationFrameworkRoyale)]
[assembly:InternalsVisibleTo(BuildInfo.PresentationFrameworkLuna)]
[assembly:InternalsVisibleTo(BuildInfo.PresentationFrameworkAero)]
[assembly:InternalsVisibleTo(BuildInfo.PresentationFrameworkAero2)]
[assembly:InternalsVisibleTo(BuildInfo.PresentationFrameworkAeroLite)]
[assembly:InternalsVisibleTo(BuildInfo.PresentationFrameworkClassic)]
[assembly:InternalsVisibleTo(BuildInfo.SystemWindowsPresentation)]
[assembly:InternalsVisibleTo(BuildInfo.PresentationFrameworkSystemCore)]
[assembly:InternalsVisibleTo(BuildInfo.PresentationFrameworkSystemXml)]
[assembly:InternalsVisibleTo(BuildInfo.SystemWindowsControlsRibbon)]

[assembly:DependencyAttribute("mscorlib,", LoadHint.Always)]
[assembly:DependencyAttribute("System,", LoadHint.Always)]
[assembly:DependencyAttribute("WindowsBase,", LoadHint.Always)]
[assembly:DependencyAttribute("PresentationCore,", LoadHint.Always)]
[assembly:DependencyAttribute("System.Xaml,", LoadHint.Sometimes)]

// Due to the XBAP script interop feature, we take a dependency on System.Core for the use
// of the dynamic pseudo-type, on BrowserInteropHelper.HostScript. The dynamic type really
// is System.Object with the DynamicAttribute applied to it, which lives in System.Core.
// It turns out that System.Core has [assembly:DefaultDependencyAttribute(LoadHint.Always)]
// applied on it, so every reference to it causes System.Core to be loaded regardless of
// whether code in it is actually hit. By setting the LoadHint below to Sometimes, we avoid
// this eager loading to be caused by PresentationFramework's dependency on it. Note there
// is a plan by the CLR team to remove the attribute on System.Core. At that point, we can
// likely drop the attribute below, but there should be no harm in leaving it.
[assembly:DependencyAttribute("System.Core,", LoadHint.Sometimes)]

[assembly:System.Windows.ThemeInfoAttribute(System.Windows.ResourceDictionaryLocation.ExternalAssembly, System.Windows.ResourceDictionaryLocation.None)]

// Namespace information for Xaml
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "System.Windows.Controls")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "System.Windows.Documents")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "System.Windows.Shapes")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "System.Windows.Shell")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "System.Windows.Navigation")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "System.Windows.Data")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "System.Windows")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "System.Windows.Controls.Primitives")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "System.Windows.Media.Animation")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "System.Windows.Input")]
[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "System.Windows.Media")]
[assembly:System.Windows.Markup.XmlnsPrefix    ("http://schemas.microsoft.com/winfx/2006/xaml/presentation", "av")]

[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "System.Windows.Controls")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "System.Windows.Documents")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "System.Windows.Shapes")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "System.Windows.Shell")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "System.Windows.Navigation")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "System.Windows.Data")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "System.Windows")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "System.Windows.Controls.Primitives")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "System.Windows.Media.Animation")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "System.Windows.Input")]
[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "System.Windows.Media")]
[assembly:System.Windows.Markup.XmlnsPrefix    ("http://schemas.microsoft.com/netfx/2007/xaml/presentation", "wpf")]

[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2009/xaml/presentation", "System.Windows.Controls")]
[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2009/xaml/presentation", "System.Windows.Documents")]
[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2009/xaml/presentation", "System.Windows.Shapes")]
[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2009/xaml/presentation", "System.Windows.Shell")]
[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2009/xaml/presentation", "System.Windows.Navigation")]
[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2009/xaml/presentation", "System.Windows.Data")]
[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2009/xaml/presentation", "System.Windows")]
[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2009/xaml/presentation", "System.Windows.Controls.Primitives")]
[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2009/xaml/presentation", "System.Windows.Media.Animation")]
[assembly: System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/netfx/2009/xaml/presentation", "System.Windows.Input")]
[assembly: System.Windows.Markup.XmlnsPrefix("http://schemas.microsoft.com/netfx/2009/xaml/presentation", "wpf")]

[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/winfx/2006/xaml", "System.Windows.Markup")]
[assembly:System.Windows.Markup.XmlnsPrefix    ("http://schemas.microsoft.com/winfx/2006/xaml", "x")]

[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/xps/2005/06", "System.Windows.Controls")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/xps/2005/06", "System.Windows.Documents")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/xps/2005/06", "System.Windows.Shapes")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/xps/2005/06", "System.Windows.Navigation")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/xps/2005/06", "System.Windows.Data")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/xps/2005/06", "System.Windows")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/xps/2005/06", "System.Windows.Controls.Primitives")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/xps/2005/06", "System.Windows.Media.Animation")]
[assembly:System.Windows.Markup.XmlnsDefinition("http://schemas.microsoft.com/xps/2005/06", "System.Windows.Input")]
[assembly:System.Windows.Markup.XmlnsPrefix    ("http://schemas.microsoft.com/xps/2005/06", "metro")]

[assembly: System.Windows.Markup.XmlnsCompatibleWith("http://schemas.microsoft.com/xps/2005/06/resourcedictionary-key", "http://schemas.microsoft.com/winfx/2006/xaml")]
