/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import java.io.Serializable;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Collection;
import sandbox.java.util.Comparator;
import sandbox.java.util.ConcurrentModificationException;
import sandbox.java.util.Iterator;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.BiFunction;
import sandbox.java.util.function.Function;

public interface Map<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public V get(Object var1);

    public V put(K var1, V var2);

    public V remove(Object var1);

    public void putAll(Map<? extends K, ? extends V> var1);

    public void clear();

    public Set<K> keySet();

    public Collection<V> values();

    public Set<Entry<K, V>> entrySet();

    public boolean equals(Object var1);

    public int hashCode();

    /*
     * Enabled aggressive block sorting
     */
    default public V getOrDefault(Object object, V v) {
        V v2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        V v3 = this.get(object);
        RuntimeCostAccounter.recordJump();
        if (v3 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
            boolean bl = this.containsKey(object);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                v2 = v;
                return v2;
            }
        }
        v2 = v3;
        RuntimeCostAccounter.recordJump();
        return v2;
    }

    default public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biConsumer);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
        Set<Entry<K, V>> set = this.entrySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator<Entry<K, V>> iterator = set.iterator();
        while (true) {
            V v;
            K k;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Entry<K, V> entry = iterator.next();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                k = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                v = entry.getValue();
            }
            catch (IllegalStateException illegalStateException) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:(Ljava/lang/Throwable;)V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException(illegalStateException);
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiConsumer.accept:(Ljava/lang/Object;Ljava/lang/Object;)V");
            biConsumer.accept(k, v);
            RuntimeCostAccounter.recordJump();
        }
    }

    default public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.entrySet:()Ljava/util/Set;");
        Set<Entry<K, V>> set = this.entrySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
        Iterator<Entry<K, V>> iterator = set.iterator();
        while (true) {
            V v;
            K k;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Entry<K, V> entry = iterator.next();
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                k = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                v = entry.getValue();
            }
            catch (IllegalStateException illegalStateException) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:(Ljava/lang/Throwable;)V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException(illegalStateException);
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            v = biFunction.apply(k, v);
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.setValue:(Ljava/lang/Object;)Ljava/lang/Object;");
                entry.setValue(v);
            }
            catch (IllegalStateException illegalStateException) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:(Ljava/lang/Throwable;)V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException(illegalStateException);
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordJump();
            RuntimeCostAccounter.recordJump();
        }
    }

    default public V putIfAbsent(K k, V v) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        V v2 = this.get(k);
        RuntimeCostAccounter.recordJump();
        if (v2 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            v2 = this.put(k, v);
        }
        return v2;
    }

    default public boolean remove(Object object, Object object2) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                V v = this.get(object);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.equals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = Objects.equals(v, object2);
                RuntimeCostAccounter.recordJump();
                if (!bl) break block2;
                RuntimeCostAccounter.recordJump();
                if (v != null) break block3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl2 = this.containsKey(object);
                RuntimeCostAccounter.recordJump();
                if (bl2) break block3;
            }
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
        this.remove(object);
        return true;
    }

    default public boolean replace(K k, V v, V v2) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                V v3 = this.get(k);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.equals:(Ljava/lang/Object;Ljava/lang/Object;)Z");
                boolean bl = Objects.equals(v3, v);
                RuntimeCostAccounter.recordJump();
                if (!bl) break block2;
                RuntimeCostAccounter.recordJump();
                if (v3 != null) break block3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl2 = this.containsKey(k);
                RuntimeCostAccounter.recordJump();
                if (bl2) break block3;
            }
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        this.put(k, v2);
        return true;
    }

    default public V replace(K k, V v) {
        V v2;
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                v2 = this.get(k);
                RuntimeCostAccounter.recordJump();
                if (v2 != null) break block2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                boolean bl = this.containsKey(k);
                RuntimeCostAccounter.recordJump();
                if (!bl) break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            v2 = this.put(k, v);
        }
        return v2;
    }

    default public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(function);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        V v = this.get(k);
        RuntimeCostAccounter.recordJump();
        if (v == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Function.apply:(Ljava/lang/Object;)Ljava/lang/Object;");
            V v2 = function.apply(k);
            RuntimeCostAccounter.recordJump();
            if (v2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.put(k, v2);
                return v2;
            }
        }
        return v;
    }

    default public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        V v = this.get(k);
        RuntimeCostAccounter.recordJump();
        if (v != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            V v2 = biFunction.apply(k, v);
            RuntimeCostAccounter.recordJump();
            if (v2 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.put(k, v2);
                return v2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.remove(k);
            return null;
        }
        return null;
    }

    default public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        V v;
        block2: {
            block4: {
                block3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
                    Objects.requireNonNull(biFunction);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    V v2 = this.get(k);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                    v = biFunction.apply(k, v2);
                    RuntimeCostAccounter.recordJump();
                    if (v != null) break block2;
                    RuntimeCostAccounter.recordJump();
                    if (v2 != null) break block3;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.containsKey:(Ljava/lang/Object;)Z");
                    boolean bl = this.containsKey(k);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block4;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
                this.remove(k);
                return null;
            }
            return null;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        this.put(k, v);
        return v;
    }

    default public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        V v2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(biFunction);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(v);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        V v3 = this.get(k);
        RuntimeCostAccounter.recordJump();
        if (v3 == null) {
            v2 = v;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/function/BiFunction.apply:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            v2 = biFunction.apply(v3, v);
        }
        V v4 = v2;
        RuntimeCostAccounter.recordJump();
        if (v4 == null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.remove:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.remove(k);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            this.put(k, v4);
        }
        return v4;
    }

    public static interface Entry<K, V> {
        public K getKey();

        public V getValue();

        public V setValue(V var1);

        public boolean equals(Object var1);

        public int hashCode();

        public static <K extends Comparable<? super K>, V> Comparator<Entry<K, V>> comparingByKey() {
            return (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(entry, entry2) -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Comparable comparable = (Comparable)entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry2.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
                return comparable.compareTo(k);
            }));
        }

        public static <K, V extends Comparable<? super V>> Comparator<Entry<K, V>> comparingByValue() {
            return (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(entry, entry2) -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Comparable comparable = (Comparable)entry.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Object v = entry2.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
                return comparable.compareTo(v);
            }));
        }

        public static <K, V> Comparator<Entry<K, V>> comparingByKey(Comparator<? super K> comparator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(comparator);
            return (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(entry, entry2) -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k = entry.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                Object k2 = entry2.getKey();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                return comparator.compare((Object)k, (Object)k2);
            }));
        }

        public static <K, V> Comparator<Entry<K, V>> comparingByValue(Comparator<? super V> comparator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(comparator);
            return (Comparator)((Object)((sandbox.java.io.Serializable)(Comparator & Serializable)(entry, entry2) -> {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Object v = entry.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                Object v2 = entry2.getValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                return comparator.compare((Object)v, (Object)v2);
            }));
        }
    }
}

