/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectInputStream;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractQueue;
import sandbox.java.util.ArrayDeque;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collection;
import sandbox.java.util.Comparator;
import sandbox.java.util.ConcurrentModificationException;
import sandbox.java.util.Iterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.SortedSet;
import sandbox.java.util.Spliterator;
import sandbox.java.util.function.Consumer;

public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    transient Object[] queue;
    private int size;
    private final Comparator<? super E> comparator;
    transient int modCount;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public PriorityQueue() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.<init>:(ILjava/util/Comparator;)V");
        this(11, null);
    }

    public PriorityQueue(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.<init>:(ILjava/util/Comparator;)V");
        this(n, null);
    }

    public PriorityQueue(Comparator<? super E> comparator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.<init>:(ILjava/util/Comparator;)V");
        this(11, comparator);
    }

    public PriorityQueue(int n, Comparator<? super E> comparator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
        this.size = 0;
        this.modCount = 0;
        RuntimeCostAccounter.recordJump();
        if (n < 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)8);
        this.queue = new Object[n2];
        this.comparator = comparator;
    }

    public PriorityQueue(Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
        this.size = 0;
        this.modCount = 0;
        boolean bl = collection instanceof SortedSet;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            SortedSet sortedSet = (SortedSet)collection;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.comparator:()Ljava/util/Comparator;");
            this.comparator = sortedSet.comparator();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.initElementsFromCollection:(Ljava/util/Collection;)V");
            this.initElementsFromCollection(sortedSet);
            RuntimeCostAccounter.recordJump();
        } else {
            boolean bl2 = collection instanceof PriorityQueue;
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                PriorityQueue priorityQueue = (PriorityQueue)collection;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.comparator:()Ljava/util/Comparator;");
                this.comparator = priorityQueue.comparator();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.initFromPriorityQueue:(Ljava/util/PriorityQueue;)V");
                this.initFromPriorityQueue(priorityQueue);
                RuntimeCostAccounter.recordJump();
            } else {
                this.comparator = null;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.initFromCollection:(Ljava/util/Collection;)V");
                this.initFromCollection(collection);
            }
        }
    }

    public PriorityQueue(PriorityQueue<? extends E> priorityQueue) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
        this.size = 0;
        this.modCount = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.comparator:()Ljava/util/Comparator;");
        this.comparator = priorityQueue.comparator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.initFromPriorityQueue:(Ljava/util/PriorityQueue;)V");
        this.initFromPriorityQueue(priorityQueue);
    }

    public PriorityQueue(SortedSet<? extends E> sortedSet) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractQueue.<init>:()V");
        this.size = 0;
        this.modCount = 0;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.comparator:()Ljava/util/Comparator;");
        this.comparator = sortedSet.comparator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.initElementsFromCollection:(Ljava/util/Collection;)V");
        this.initElementsFromCollection(sortedSet);
    }

    private void initFromPriorityQueue(PriorityQueue<? extends E> priorityQueue) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = priorityQueue.getClass();
        RuntimeCostAccounter.recordJump();
        if (clazz == PriorityQueue.class) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.toArray:()[Ljava/lang/Object;");
            this.queue = priorityQueue.toArray();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.size:()I");
            this.size = priorityQueue.size();
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.initFromCollection:(Ljava/util/Collection;)V");
            this.initFromCollection(priorityQueue);
        }
    }

    private void initElementsFromCollection(Collection<? extends E> collection) {
        Object[] objectArray;
        block7: {
            int n;
            block6: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.toArray:()[Ljava/lang/Object;");
                objectArray = collection.toArray();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                Class<?> clazz = objectArray.getClass();
                RuntimeCostAccounter.recordJump();
                if (clazz != Object[].class) {
                    int n2 = objectArray.length;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
                    objectArray = Arrays.copyOf(objectArray, n2, Object[].class);
                }
                n = objectArray.length;
                RuntimeCostAccounter.recordJump();
                if (n == 1) break block6;
                RuntimeCostAccounter.recordJump();
                if (this.comparator == null) break block7;
            }
            int n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= n) break;
                Object object = objectArray[n3];
                RuntimeCostAccounter.recordJump();
                if (object == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
        }
        this.queue = objectArray;
        this.size = objectArray.length;
    }

    private void initFromCollection(Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.initElementsFromCollection:(Ljava/util/Collection;)V");
        this.initElementsFromCollection(collection);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.heapify:()V");
        this.heapify();
    }

    private void grow(int n) {
        int n2;
        int n3 = this.queue.length;
        RuntimeCostAccounter.recordJump();
        if (n3 < 64) {
            n2 = n3 + 2;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = n3 >> 1;
        }
        int n4 = n3 + n2;
        RuntimeCostAccounter.recordJump();
        if (n4 - 0x7FFFFFF7 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.hugeCapacity:(I)I");
            n4 = PriorityQueue.hugeCapacity(n);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
        this.queue = Arrays.copyOf(this.queue, n4);
    }

    private static int hugeCapacity(int n) {
        int n2;
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/OutOfMemoryError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/OutOfMemoryError.<init>:()V");
            OutOfMemoryError outOfMemoryError = new OutOfMemoryError();
            RuntimeCostAccounter.recordThrow();
            throw outOfMemoryError;
        }
        RuntimeCostAccounter.recordJump();
        if (n > 0x7FFFFFF7) {
            n2 = Integer.MAX_VALUE;
            RuntimeCostAccounter.recordJump();
        } else {
            n2 = 0x7FFFFFF7;
        }
        return n2;
    }

    @Override
    public boolean add(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.offer:(Ljava/lang/Object;)Z");
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        RuntimeCostAccounter.recordJump();
        if (e == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        ++this.modCount;
        int n = this.size;
        int n2 = this.queue.length;
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.grow:(I)V");
            this.grow(n + 1);
        }
        this.size = n + 1;
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            this.queue[0] = e;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.siftUp:(ILjava/lang/Object;)V");
            this.siftUp(n, e);
        }
        return true;
    }

    @Override
    public E peek() {
        Object object;
        RuntimeCostAccounter.recordJump();
        if (this.size == 0) {
            object = null;
            RuntimeCostAccounter.recordJump();
        } else {
            object = this.queue[0];
        }
        return (E)object;
    }

    private int indexOf(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object != null) {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n >= this.size) break;
                Object object2 = this.queue[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.equals:(Ljava/lang/Object;)Z");
                boolean bl = object.equals(object2);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return n;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
        }
        return -1;
    }

    @Override
    public boolean remove(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.indexOf:(Ljava/lang/Object;)I");
        int n = this.indexOf(object);
        RuntimeCostAccounter.recordJump();
        if (n == -1) {
            return false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.removeAt:(I)Ljava/lang/Object;");
        this.removeAt(n);
        return true;
    }

    boolean removeEq(Object object) {
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.size) break;
            Object object2 = this.queue[n];
            RuntimeCostAccounter.recordJump();
            if (object == object2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.removeAt:(I)Ljava/lang/Object;");
                this.removeAt(n);
                return true;
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.indexOf:(Ljava/lang/Object;)I");
        int n = this.indexOf(object);
        RuntimeCostAccounter.recordJump();
        if (n != -1) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public Object[] toArray() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;I)[Ljava/lang/Object;");
        return Arrays.copyOf(this.queue, this.size);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.size;
        int n2 = TArray.length;
        RuntimeCostAccounter.recordJump();
        if (n2 < n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
            Class<?> clazz = TArray.getClass();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOf:([Ljava/lang/Object;ILjava/lang/Class;)[Ljava/lang/Object;");
            return Arrays.copyOf(this.queue, n, clazz);
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.queue, 0, TArray, 0, n);
        int n3 = TArray.length;
        RuntimeCostAccounter.recordJump();
        if (n3 > n) {
            TArray[n] = null;
        }
        return TArray;
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/PriorityQueue$Itr");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue$Itr.<init>:(Ljava/util/PriorityQueue;Ljava/util/PriorityQueue$1;)V");
        return new Itr(this, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        ++this.modCount;
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.size) break;
            this.queue[n] = null;
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        this.size = 0;
    }

    @Override
    public E poll() {
        RuntimeCostAccounter.recordJump();
        if (this.size == 0) {
            return null;
        }
        int n = --this.size;
        ++this.modCount;
        Object object = this.queue[0];
        Object object2 = this.queue[n];
        this.queue[n] = null;
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.siftDown:(ILjava/lang/Object;)V");
            this.siftDown(0, object2);
        }
        return (E)object;
    }

    private E removeAt(int n) {
        ++this.modCount;
        int n2 = --this.size;
        RuntimeCostAccounter.recordJump();
        if (n2 == n) {
            this.queue[n] = null;
            RuntimeCostAccounter.recordJump();
        } else {
            Object object = this.queue[n2];
            this.queue[n2] = null;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.siftDown:(ILjava/lang/Object;)V");
            this.siftDown(n, object);
            Object object2 = this.queue[n];
            RuntimeCostAccounter.recordJump();
            if (object2 == object) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.siftUp:(ILjava/lang/Object;)V");
                this.siftUp(n, object);
                Object object3 = this.queue[n];
                RuntimeCostAccounter.recordJump();
                if (object3 != object) {
                    return (E)object;
                }
            }
        }
        return null;
    }

    private void siftUp(int n, E e) {
        RuntimeCostAccounter.recordJump();
        if (this.comparator != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.siftUpUsingComparator:(ILjava/lang/Object;)V");
            this.siftUpUsingComparator(n, e);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.siftUpComparable:(ILjava/lang/Object;)V");
            this.siftUpComparable(n, e);
        }
    }

    private void siftUpComparable(int n, E e) {
        Comparable comparable = (Comparable)e;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            int n2 = n - 1 >>> 1;
            Object object = this.queue[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
            int n3 = comparable.compareTo(object);
            RuntimeCostAccounter.recordJump();
            if (n3 >= 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            this.queue[n] = object;
            n = n2;
            RuntimeCostAccounter.recordJump();
        }
        this.queue[n] = comparable;
    }

    private void siftUpUsingComparator(int n, E e) {
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n <= 0) break;
            int n2 = n - 1 >>> 1;
            Object object = this.queue[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n3 = this.comparator.compare(e, object);
            RuntimeCostAccounter.recordJump();
            if (n3 >= 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            this.queue[n] = object;
            n = n2;
            RuntimeCostAccounter.recordJump();
        }
        this.queue[n] = e;
    }

    private void siftDown(int n, E e) {
        RuntimeCostAccounter.recordJump();
        if (this.comparator != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.siftDownUsingComparator:(ILjava/lang/Object;)V");
            this.siftDownUsingComparator(n, e);
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.siftDownComparable:(ILjava/lang/Object;)V");
            this.siftDownComparable(n, e);
        }
    }

    private void siftDownComparable(int n, E e) {
        Comparable comparable = (Comparable)e;
        int n2 = this.size >>> 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            int n3 = (n << 1) + 1;
            Object object = this.queue[n3];
            int n4 = n3 + 1;
            RuntimeCostAccounter.recordJump();
            if (n4 < this.size) {
                Comparable comparable2 = (Comparable)object;
                Object object2 = this.queue[n4];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
                int n5 = comparable2.compareTo(object2);
                RuntimeCostAccounter.recordJump();
                if (n5 > 0) {
                    n3 = n4;
                    object = this.queue[n3];
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Comparable.compareTo:(Ljava/lang/Object;)I");
            int n6 = comparable.compareTo(object);
            RuntimeCostAccounter.recordJump();
            if (n6 <= 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            this.queue[n] = object;
            n = n3;
            RuntimeCostAccounter.recordJump();
        }
        this.queue[n] = comparable;
    }

    private void siftDownUsingComparator(int n, E e) {
        int n2 = this.size >>> 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= n2) break;
            int n3 = (n << 1) + 1;
            Object object = this.queue[n3];
            int n4 = n3 + 1;
            RuntimeCostAccounter.recordJump();
            if (n4 < this.size) {
                Object object2 = this.queue[n4];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
                int n5 = this.comparator.compare(object, object2);
                RuntimeCostAccounter.recordJump();
                if (n5 > 0) {
                    n3 = n4;
                    object = this.queue[n3];
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.compare:(Ljava/lang/Object;Ljava/lang/Object;)I");
            int n6 = this.comparator.compare(e, object);
            RuntimeCostAccounter.recordJump();
            if (n6 <= 0) {
                RuntimeCostAccounter.recordJump();
                break;
            }
            this.queue[n] = object;
            n = n3;
            RuntimeCostAccounter.recordJump();
        }
        this.queue[n] = e;
    }

    private void heapify() {
        int n = (this.size >>> 1) - 1;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n < 0) break;
            Object object = this.queue[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.siftDown:(ILjava/lang/Object;)V");
            this.siftDown(n, object);
            --n;
            RuntimeCostAccounter.recordJump();
        }
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.defaultWriteObject:()V");
        objectOutputStream.defaultWriteObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
        int n = Math.max(2, this.size + 1);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeInt:(I)V");
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= this.size) break;
            Object object = this.queue[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeObject:(Ljava/lang/Object;)V");
            objectOutputStream.writeObject(object);
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.defaultReadObject:()V");
        objectInputStream.defaultReadObject();
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readInt:()I");
        objectInputStream.readInt();
        int n = this.size;
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        this.queue = new Object[n];
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= this.size) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectInputStream.readObject:()Ljava/lang/Object;");
            this.queue[n2] = objectInputStream.readObject();
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.heapify:()V");
        this.heapify();
    }

    @Override
    public final Spliterator<E> spliterator() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/PriorityQueue$PriorityQueueSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue$PriorityQueueSpliterator.<init>:(Ljava/util/PriorityQueue;III)V");
        return new PriorityQueueSpliterator(this, 0, -1, 0);
    }

    static /* synthetic */ Object access$200(PriorityQueue priorityQueue, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.removeAt:(I)Ljava/lang/Object;");
        return priorityQueue.removeAt(n);
    }

    static final class PriorityQueueSpliterator<E>
    implements Spliterator<E> {
        private final PriorityQueue<E> pq;
        private int index;
        private int fence;
        private int expectedModCount;

        PriorityQueueSpliterator(PriorityQueue<E> priorityQueue, int n, int n2, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.pq = priorityQueue;
            this.index = n;
            this.fence = n2;
            this.expectedModCount = n3;
        }

        private int getFence() {
            int n = this.fence;
            RuntimeCostAccounter.recordJump();
            if (n < 0) {
                this.expectedModCount = this.pq.modCount;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.access$100:(Ljava/util/PriorityQueue;)I");
                n = this.fence = ((PriorityQueue)this.pq).size;
            }
            return n;
        }

        @Override
        public PriorityQueueSpliterator<E> trySplit() {
            PriorityQueueSpliterator<E> priorityQueueSpliterator;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue$PriorityQueueSpliterator.getFence:()I");
            int n = this.getFence();
            int n2 = this.index;
            int n3 = n2 + n >>> 1;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) {
                priorityQueueSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/PriorityQueue$PriorityQueueSpliterator");
                this.index = n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue$PriorityQueueSpliterator.<init>:(Ljava/util/PriorityQueue;III)V");
                PriorityQueueSpliterator<E> priorityQueueSpliterator2 = new PriorityQueueSpliterator<E>(this.pq, n2, this.index, this.expectedModCount);
                priorityQueueSpliterator = priorityQueueSpliterator2;
            }
            return priorityQueueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            PriorityQueue<E> priorityQueue = this.pq;
            RuntimeCostAccounter.recordJump();
            if (priorityQueue != null) {
                Object[] objectArray = priorityQueue.queue;
                RuntimeCostAccounter.recordJump();
                if (priorityQueue.queue != null) {
                    int n;
                    int n2 = this.fence;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) {
                        n = priorityQueue.modCount;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.access$100:(Ljava/util/PriorityQueue;)I");
                        n2 = ((PriorityQueue)priorityQueue).size;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = this.expectedModCount;
                    }
                    int n3 = this.index;
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= 0) {
                        this.index = n2;
                        int n4 = objectArray.length;
                        RuntimeCostAccounter.recordJump();
                        if (this.index <= n4) {
                            while (true) {
                                Object object;
                                RuntimeCostAccounter.recordJump();
                                if (n3 < n2) {
                                    object = objectArray[n3];
                                    RuntimeCostAccounter.recordJump();
                                    if (object == null) {
                                        RuntimeCostAccounter.recordJump();
                                        break;
                                    }
                                } else {
                                    int n5 = priorityQueue.modCount;
                                    RuntimeCostAccounter.recordJump();
                                    if (n5 != n) {
                                        RuntimeCostAccounter.recordJump();
                                        break;
                                    }
                                    return;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                                consumer.accept(object);
                                RuntimeCostAccounter.recordJump();
                                ++n3;
                                RuntimeCostAccounter.recordJump();
                            }
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
            ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
            RuntimeCostAccounter.recordThrow();
            throw concurrentModificationException;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> consumer) {
            RuntimeCostAccounter.recordJump();
            if (consumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue$PriorityQueueSpliterator.getFence:()I");
            int n = this.getFence();
            int n2 = this.index;
            RuntimeCostAccounter.recordJump();
            if (n2 >= 0) {
                RuntimeCostAccounter.recordJump();
                if (n2 < n) {
                    this.index = n2 + 1;
                    Object object = this.pq.queue[n2];
                    RuntimeCostAccounter.recordJump();
                    if (object == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/Consumer.accept:(Ljava/lang/Object;)V");
                    consumer.accept(object);
                    int n3 = this.pq.modCount;
                    RuntimeCostAccounter.recordJump();
                    if (n3 != this.expectedModCount) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                        RuntimeCostAccounter.recordThrow();
                        throw concurrentModificationException;
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public long estimateSize() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue$PriorityQueueSpliterator.getFence:()I");
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16704;
        }
    }

    private final class Itr
    implements Iterator<E> {
        private int cursor;
        private int lastRet;
        private ArrayDeque<E> forgetMeNot;
        private E lastRetElt;
        private int expectedModCount;
        final /* synthetic */ PriorityQueue this$0;

        private Itr(PriorityQueue priorityQueue) {
            this.this$0 = priorityQueue;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.cursor = 0;
            this.lastRet = -1;
            this.forgetMeNot = null;
            this.lastRetElt = null;
            this.expectedModCount = this.this$0.modCount;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasNext() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.access$100:(Ljava/util/PriorityQueue;)I");
            int n = this.this$0.size;
            RuntimeCostAccounter.recordJump();
            if (this.cursor >= n) {
                RuntimeCostAccounter.recordJump();
                if (this.forgetMeNot == null) return false;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.isEmpty:()Z");
                boolean bl = this.forgetMeNot.isEmpty();
                RuntimeCostAccounter.recordJump();
                if (bl) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        @Override
        public E next() {
            int n = this.this$0.modCount;
            RuntimeCostAccounter.recordJump();
            if (this.expectedModCount != n) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.access$100:(Ljava/util/PriorityQueue;)I");
            int n2 = this.this$0.size;
            RuntimeCostAccounter.recordJump();
            if (this.cursor < n2) {
                this.lastRet = this.cursor++;
                return this.this$0.queue[this.lastRet];
            }
            RuntimeCostAccounter.recordJump();
            if (this.forgetMeNot != null) {
                this.lastRet = -1;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.poll:()Ljava/lang/Object;");
                this.lastRetElt = this.forgetMeNot.poll();
                RuntimeCostAccounter.recordJump();
                if (this.lastRetElt != null) {
                    return this.lastRetElt;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            RuntimeCostAccounter.recordThrow();
            throw noSuchElementException;
        }

        @Override
        public void remove() {
            int n = this.this$0.modCount;
            RuntimeCostAccounter.recordJump();
            if (this.expectedModCount != n) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ConcurrentModificationException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ConcurrentModificationException.<init>:()V");
                ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException();
                RuntimeCostAccounter.recordThrow();
                throw concurrentModificationException;
            }
            RuntimeCostAccounter.recordJump();
            if (this.lastRet != -1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.access$200:(Ljava/util/PriorityQueue;I)Ljava/lang/Object;");
                Object object = PriorityQueue.access$200(this.this$0, this.lastRet);
                this.lastRet = -1;
                RuntimeCostAccounter.recordJump();
                if (object == null) {
                    --this.cursor;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.forgetMeNot == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayDeque");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.<init>:()V");
                        this.forgetMeNot = new ArrayDeque();
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayDeque.add:(Ljava/lang/Object;)Z");
                    this.forgetMeNot.add(object);
                }
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.lastRetElt != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue.removeEq:(Ljava/lang/Object;)Z");
                    this.this$0.removeEq(this.lastRetElt);
                    this.lastRetElt = null;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:()V");
                    IllegalStateException illegalStateException = new IllegalStateException();
                    RuntimeCostAccounter.recordThrow();
                    throw illegalStateException;
                }
            }
            this.expectedModCount = this.this$0.modCount;
        }

        /* synthetic */ Itr(PriorityQueue priorityQueue, 1 var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/PriorityQueue$Itr.<init>:(Ljava/util/PriorityQueue;)V");
            this(priorityQueue);
        }
    }
}

