/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.logging;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.logging.Filter;
import sandbox.java.util.logging.Formatter;
import sandbox.java.util.logging.Handler;
import sandbox.java.util.logging.Level;
import sandbox.java.util.logging.LogManager;
import sandbox.java.util.logging.LogRecord;
import sandbox.java.util.logging.SimpleFormatter;

public class MemoryHandler
extends Handler {
    private static final int DEFAULT_SIZE = 1000;
    private volatile Level pushLevel;
    private int size;
    private Handler target;
    private LogRecord[] buffer;
    int start;
    int count;

    private void configure() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
        LogManager logManager = LogManager.getLogManager();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
        String string = clazz.getName();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(".push");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string2 = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLevelProperty:(Ljava/lang/String;Ljava/util/logging/Level;)Ljava/util/logging/Level;");
        this.pushLevel = logManager.getLevelProperty(string2, Level.SEVERE);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder4 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder5 = stringBuilder4.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder6 = stringBuilder5.append(".size");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string3 = stringBuilder6.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getIntProperty:(Ljava/lang/String;I)I");
        this.size = logManager.getIntProperty(string3, 1000);
        RuntimeCostAccounter.recordJump();
        if (this.size <= 0) {
            this.size = 1000;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder7 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder8 = stringBuilder7.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder9 = stringBuilder8.append(".level");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string4 = stringBuilder9.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLevelProperty:(Ljava/lang/String;Ljava/util/logging/Level;)Ljava/util/logging/Level;");
        Level level = logManager.getLevelProperty(string4, Level.ALL);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/MemoryHandler.setLevel:(Ljava/util/logging/Level;)V");
        this.setLevel(level);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder10 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder11 = stringBuilder10.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder12 = stringBuilder11.append(".filter");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string5 = stringBuilder12.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getFilterProperty:(Ljava/lang/String;Ljava/util/logging/Filter;)Ljava/util/logging/Filter;");
        Filter filter = logManager.getFilterProperty(string5, null);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/MemoryHandler.setFilter:(Ljava/util/logging/Filter;)V");
        this.setFilter(filter);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder13 = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder14 = stringBuilder13.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder15 = stringBuilder14.append(".formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string6 = stringBuilder15.toString();
        RuntimeCostAccounter.recordAllocation((String)"java/util/logging/SimpleFormatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/SimpleFormatter.<init>:()V");
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getFormatterProperty:(Ljava/lang/String;Ljava/util/logging/Formatter;)Ljava/util/logging/Formatter;");
        Formatter formatter = logManager.getFormatterProperty(string6, simpleFormatter);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/MemoryHandler.setFormatter:(Ljava/util/logging/Formatter;)V");
        this.setFormatter(formatter);
    }

    public MemoryHandler() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.<init>:()V");
        this.sealed = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/MemoryHandler.configure:()V");
        this.configure();
        this.sealed = true;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getLogManager:()Ljava/util/logging/LogManager;");
        LogManager logManager = LogManager.getLogManager();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getName:()Ljava/lang/String;");
        String string = clazz.getName();
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(".target");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        String string2 = stringBuilder3.toString();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogManager.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
        String string3 = logManager.getProperty(string2);
        RuntimeCostAccounter.recordJump();
        if (string3 == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder4 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append("The handler ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(" does not specify a target");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string4 = stringBuilder7.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.<init>:(Ljava/lang/String;)V");
            RuntimeException runtimeException = new RuntimeException(string4);
            RuntimeCostAccounter.recordThrow();
            throw runtimeException;
        }
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.getSystemClassLoader:()Ljava/lang/ClassLoader;");
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ClassLoader.loadClass:(Ljava/lang/String;)Ljava/lang/Class;");
            Class<?> clazz2 = classLoader.loadClass(string3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.newInstance:()Ljava/lang/Object;");
            this.target = (Handler)clazz2.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/RuntimeException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder8 = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append("MemoryHandler can't load handler target \"");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder10 = stringBuilder9.append(string3);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder11 = stringBuilder10.append("\"");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string5 = stringBuilder11.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/RuntimeException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            RuntimeException runtimeException = new RuntimeException(string5, reflectiveOperationException);
            RuntimeCostAccounter.recordThrow();
            throw runtimeException;
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/MemoryHandler.init:()V");
        this.init();
    }

    private void init() {
        int n = this.size;
        RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
        this.buffer = new LogRecord[n];
        this.start = 0;
        this.count = 0;
    }

    public MemoryHandler(Handler handler, int n, Level level) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.<init>:()V");
                RuntimeCostAccounter.recordJump();
                if (handler == null) break block4;
                RuntimeCostAccounter.recordJump();
                if (level != null) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:()V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.sealed = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/MemoryHandler.configure:()V");
        this.configure();
        this.sealed = true;
        this.target = handler;
        this.pushLevel = level;
        this.size = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/MemoryHandler.init:()V");
        this.init();
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/MemoryHandler.isLoggable:(Ljava/util/logging/LogRecord;)Z");
        boolean bl = this.isLoggable(logRecord);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return;
        }
        int n = (this.start + this.count) % this.buffer.length;
        this.buffer[n] = logRecord;
        int n2 = this.buffer.length;
        RuntimeCostAccounter.recordJump();
        if (this.count < n2) {
            ++this.count;
            RuntimeCostAccounter.recordJump();
        } else {
            ++this.start;
            this.start %= this.buffer.length;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/LogRecord.getLevel:()Ljava/util/logging/Level;");
        Level level = logRecord.getLevel();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.intValue:()I");
        int n3 = level.intValue();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Level.intValue:()I");
        int n4 = this.pushLevel.intValue();
        RuntimeCostAccounter.recordJump();
        if (n3 >= n4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/MemoryHandler.push:()V");
            this.push();
        }
    }

    public synchronized void push() {
        int n = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n >= this.count) break;
            int n2 = (this.start + n) % this.buffer.length;
            LogRecord logRecord = this.buffer[n2];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.publish:(Ljava/util/logging/LogRecord;)V");
            this.target.publish(logRecord);
            ++n;
            RuntimeCostAccounter.recordJump();
        }
        this.start = 0;
        this.count = 0;
    }

    @Override
    public void flush() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.flush:()V");
        this.target.flush();
    }

    @Override
    public void close() throws SecurityException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.close:()V");
        this.target.close();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/MemoryHandler.setLevel:(Ljava/util/logging/Level;)V");
        this.setLevel(Level.OFF);
    }

    public synchronized void setPushLevel(Level level) throws SecurityException {
        RuntimeCostAccounter.recordJump();
        if (level == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/MemoryHandler.checkPermission:()V");
        this.checkPermission();
        this.pushLevel = level;
    }

    public Level getPushLevel() {
        return this.pushLevel;
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/logging/Handler.isLoggable:(Ljava/util/logging/LogRecord;)Z");
        return super.isLoggable(logRecord);
    }
}

