/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.Arrays;
import sandbox.java.util.LongSummaryStatistics;
import sandbox.java.util.Objects;
import sandbox.java.util.OptionalDouble;
import sandbox.java.util.OptionalLong;
import sandbox.java.util.PrimitiveIterator;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.function.BiConsumer;
import sandbox.java.util.function.LongBinaryOperator;
import sandbox.java.util.function.LongConsumer;
import sandbox.java.util.function.LongFunction;
import sandbox.java.util.function.LongPredicate;
import sandbox.java.util.function.LongSupplier;
import sandbox.java.util.function.LongToDoubleFunction;
import sandbox.java.util.function.LongToIntFunction;
import sandbox.java.util.function.LongUnaryOperator;
import sandbox.java.util.function.ObjLongConsumer;
import sandbox.java.util.function.Supplier;
import sandbox.java.util.stream.BaseStream;
import sandbox.java.util.stream.DoubleStream;
import sandbox.java.util.stream.IntStream;
import sandbox.java.util.stream.Stream;
import sandbox.java.util.stream.StreamSpliterators;
import sandbox.java.util.stream.StreamSupport;
import sandbox.java.util.stream.Streams;

public interface LongStream
extends BaseStream<Long, LongStream> {
    public LongStream filter(LongPredicate var1);

    public LongStream map(LongUnaryOperator var1);

    public <U> Stream<U> mapToObj(LongFunction<? extends U> var1);

    public IntStream mapToInt(LongToIntFunction var1);

    public DoubleStream mapToDouble(LongToDoubleFunction var1);

    public LongStream flatMap(LongFunction<? extends LongStream> var1);

    public LongStream distinct();

    public LongStream sorted();

    public LongStream peek(LongConsumer var1);

    public LongStream limit(long var1);

    public LongStream skip(long var1);

    public void forEach(LongConsumer var1);

    public void forEachOrdered(LongConsumer var1);

    public long[] toArray();

    public long reduce(long var1, LongBinaryOperator var3);

    public OptionalLong reduce(LongBinaryOperator var1);

    public <R> R collect(Supplier<R> var1, ObjLongConsumer<R> var2, BiConsumer<R, R> var3);

    public long sum();

    public OptionalLong min();

    public OptionalLong max();

    public long count();

    public OptionalDouble average();

    public LongSummaryStatistics summaryStatistics();

    public boolean anyMatch(LongPredicate var1);

    public boolean allMatch(LongPredicate var1);

    public boolean noneMatch(LongPredicate var1);

    public OptionalLong findFirst();

    public OptionalLong findAny();

    public DoubleStream asDoubleStream();

    public Stream<Long> boxed();

    @Override
    public LongStream sequential();

    @Override
    public LongStream parallel();

    public PrimitiveIterator.OfLong iterator();

    public Spliterator.OfLong spliterator();

    public static Builder builder() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$LongStreamBuilderImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$LongStreamBuilderImpl.<init>:()V");
        return new Streams.LongStreamBuilderImpl();
    }

    public static LongStream empty() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.emptyLongSpliterator:()Ljava/util/Spliterator$OfLong;");
        Spliterator.OfLong ofLong = Spliterators.emptyLongSpliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(ofLong, false);
    }

    public static LongStream of(long l) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$LongStreamBuilderImpl");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$LongStreamBuilderImpl.<init>:(J)V");
        Streams.LongStreamBuilderImpl longStreamBuilderImpl = new Streams.LongStreamBuilderImpl(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(longStreamBuilderImpl, false);
    }

    public static LongStream of(long ... lArray) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.stream:([J)Ljava/util/stream/LongStream;");
        return Arrays.stream(lArray);
    }

    public static LongStream iterate(final long l, final LongUnaryOperator longUnaryOperator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(longUnaryOperator);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/LongStream$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream$1.<init>:(JLjava/util/function/LongUnaryOperator;)V");
        PrimitiveIterator.OfLong ofLong = new PrimitiveIterator.OfLong(){
            long t;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.t = l;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public long nextLong() {
                long l2 = this.t;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongUnaryOperator.applyAsLong:(J)J");
                this.t = longUnaryOperator.applyAsLong(this.t);
                return l2;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliteratorUnknownSize:(Ljava/util/PrimitiveIterator$OfLong;I)Ljava/util/Spliterator$OfLong;");
        Spliterator.OfLong ofLong2 = Spliterators.spliteratorUnknownSize(ofLong, 1296);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(ofLong2, false);
    }

    public static LongStream generate(LongSupplier longSupplier) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(longSupplier);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/StreamSpliterators$InfiniteSupplyingSpliterator$OfLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSpliterators$InfiniteSupplyingSpliterator$OfLong.<init>:(JLjava/util/function/LongSupplier;)V");
        StreamSpliterators.InfiniteSupplyingSpliterator.OfLong ofLong = new StreamSpliterators.InfiniteSupplyingSpliterator.OfLong(Long.MAX_VALUE, longSupplier);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(ofLong, false);
    }

    public static LongStream range(long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if (l >= l2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.empty:()Ljava/util/stream/LongStream;");
            return LongStream.empty();
        }
        RuntimeCostAccounter.recordJump();
        if (l2 - l < 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.divideUnsigned:(JJ)J");
            long l3 = l + Long.divideUnsigned(l2 - l, 2L) + 1L;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.range:(JJ)Ljava/util/stream/LongStream;");
            LongStream longStream = LongStream.range(l, l3);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.range:(JJ)Ljava/util/stream/LongStream;");
            LongStream longStream2 = LongStream.range(l3, l2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.concat:(Ljava/util/stream/LongStream;Ljava/util/stream/LongStream;)Ljava/util/stream/LongStream;");
            return LongStream.concat(longStream, longStream2);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$RangeLongSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$RangeLongSpliterator.<init>:(JJZ)V");
        Streams.RangeLongSpliterator rangeLongSpliterator = new Streams.RangeLongSpliterator(l, l2, false);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(rangeLongSpliterator, false);
    }

    public static LongStream rangeClosed(long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if (l > l2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.empty:()Ljava/util/stream/LongStream;");
            return LongStream.empty();
        }
        RuntimeCostAccounter.recordJump();
        if (l2 - l + 1L <= 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.divideUnsigned:(JJ)J");
            long l3 = l + Long.divideUnsigned(l2 - l, 2L) + 1L;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.range:(JJ)Ljava/util/stream/LongStream;");
            LongStream longStream = LongStream.range(l, l3);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.rangeClosed:(JJ)Ljava/util/stream/LongStream;");
            LongStream longStream2 = LongStream.rangeClosed(l3, l2);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.concat:(Ljava/util/stream/LongStream;Ljava/util/stream/LongStream;)Ljava/util/stream/LongStream;");
            return LongStream.concat(longStream, longStream2);
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$RangeLongSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$RangeLongSpliterator.<init>:(JJZ)V");
        Streams.RangeLongSpliterator rangeLongSpliterator = new Streams.RangeLongSpliterator(l, l2, true);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(rangeLongSpliterator, false);
    }

    /*
     * Unable to fully structure code
     */
    public static LongStream concat(LongStream var0, LongStream var1_1) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(var0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
        Objects.requireNonNull(var1_1);
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/Streams$ConcatSpliterator$OfLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.spliterator:()Ljava/util/Spliterator$OfLong;");
        v0 = var0.spliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.spliterator:()Ljava/util/Spliterator$OfLong;");
        v1 = var1_1.spliterator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams$ConcatSpliterator$OfLong.<init>:(Ljava/util/Spliterator$OfLong;Ljava/util/Spliterator$OfLong;)V");
        var2_2 = new Streams.ConcatSpliterator.OfLong(v0, v1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.isParallel:()Z");
        v2 = var0.isParallel();
        RuntimeCostAccounter.recordJump();
        if (v2) ** GOTO lbl-1000
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.isParallel:()Z");
        v3 = var1_1.isParallel();
        RuntimeCostAccounter.recordJump();
        if (v3) lbl-1000:
        // 2 sources

        {
            v4 = true;
            RuntimeCostAccounter.recordJump();
        } else {
            v4 = false;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        var3_3 = StreamSupport.longStream(var2_2, v4);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Streams.composedClose:(Ljava/util/stream/BaseStream;Ljava/util/stream/BaseStream;)Ljava/lang/Runnable;");
        v5 = Streams.composedClose(var0, var1_1);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream.onClose:(Ljava/lang/Runnable;)Ljava/util/stream/BaseStream;");
        return (LongStream)var3_3.onClose(v5);
    }

    public static interface Builder
    extends LongConsumer {
        @Override
        public void accept(long var1);

        default public Builder add(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongStream$Builder.accept:(J)V");
            this.accept(l);
            return this;
        }

        public LongStream build();
    }
}

