//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// test numeric_limits

// epsilon()

#include <cuda/std/cassert>
#include <cuda/std/cfloat>
#include <cuda/std/limits>

#include "common.h"
#include "test_macros.h"

template <class T>
__host__ __device__ void test(T expected)
{
  assert(float_eq(cuda::std::numeric_limits<T>::epsilon(), expected));
  assert(float_eq(cuda::std::numeric_limits<const T>::epsilon(), expected));
  assert(float_eq(cuda::std::numeric_limits<volatile T>::epsilon(), expected));
  assert(float_eq(cuda::std::numeric_limits<const volatile T>::epsilon(), expected));
}

int main(int, char**)
{
  test<bool>(false);
  test<char>(0);
  test<signed char>(0);
  test<unsigned char>(0);
  test<wchar_t>(0);
#if TEST_STD_VER > 2017 && defined(__cpp_char8_t)
  test<char8_t>(0);
#endif
#ifndef _LIBCUDACXX_HAS_NO_UNICODE_CHARS
  test<char16_t>(0);
  test<char32_t>(0);
#endif // _LIBCUDACXX_HAS_NO_UNICODE_CHARS
  test<short>(0);
  test<unsigned short>(0);
  test<int>(0);
  test<unsigned int>(0);
  test<long>(0);
  test<unsigned long>(0);
  test<long long>(0);
  test<unsigned long long>(0);
#ifndef _LIBCUDACXX_HAS_NO_INT128
  test<__int128_t>(0);
  test<__uint128_t>(0);
#endif
  test<float>(FLT_EPSILON);
  test<double>(DBL_EPSILON);
#ifndef _LIBCUDACXX_HAS_NO_LONG_DOUBLE
  test<long double>(LDBL_EPSILON);
#endif
#if defined(_CCCL_HAS_NVFP16)
  test<__half>(__double2half(0.0009765625));
#endif // _CCCL_HAS_NVFP16
#if defined(_CCCL_HAS_NVBF16)
  test<__nv_bfloat16>(__double2bfloat16(0.0078125));
#endif // _CCCL_HAS_NVBF16
#if _CCCL_HAS_NVFP8()
  test<__nv_fp8_e4m3>(make_fp8_e4m3(0.125));
  test<__nv_fp8_e5m2>(make_fp8_e5m2(0.25));
#endif // _CCCL_HAS_NVFP8()

  return 0;
}
