/*********************************************************************/
/* Copyright (c) 2015, EPFL/Blue Brain Project                       */
/*                     Raphael Dumusc <raphael.dumusc@epfl.ch>       */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFITS;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of Ecole polytechnique federale de Lausanne.          */
/*********************************************************************/

#ifndef RECTANGLE_H
#define RECTANGLE_H

#include <QObject>
#include <QRectF>

/**
 * Exposes the coordinates of a rectangle as QProperties for QML binding.
 */
class Rectangle : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY( Rectangle )

    Q_PROPERTY( qreal x READ x WRITE setX NOTIFY xChanged )
    Q_PROPERTY( qreal y READ y WRITE setY NOTIFY yChanged )
    Q_PROPERTY( qreal width READ width WRITE setWidth NOTIFY widthChanged )
    Q_PROPERTY( qreal height READ height WRITE setHeight NOTIFY heightChanged )

public:
    Rectangle();
    Rectangle( const QRectF& coordinates );
    virtual ~Rectangle();

    const QRectF& getCoordinates() const;

    qreal x() const;
    qreal y() const;
    qreal width() const;
    qreal height() const;

    QSizeF size() const;
    QPointF center() const;

    void setX( const qreal x );
    void setY( const qreal y );
    void setWidth( const qreal w );
    void setHeight( const qreal h );

    void setCoordinates( const QRectF& coordinates );

signals:
    void xChanged();
    void yChanged();
    void widthChanged();
    void heightChanged();

protected:
    QRectF _coordinates;
};

#endif
