/*********************************************************************/
/* Copyright (c) 2013-2016, EPFL/Blue Brain Project                  */
/*                     Raphael Dumusc <raphael.dumusc@epfl.ch>       */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFITS;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of Ecole polytechnique federale de Lausanne.          */
/*********************************************************************/

#ifndef FOLDERTHUMBNAILGENERATOR_H
#define FOLDERTHUMBNAILGENERATOR_H

#include "ThumbnailGenerator.h"

#include <QFileInfoList>

/**
 * Generate thumbnails for folders.
 */
class FolderThumbnailGenerator : public ThumbnailGenerator
{
public:
    /** @copydoc ThumbnailGenerator::ThumbnailGenerator */
    FolderThumbnailGenerator( const QSize& size );

    /**
     * Generate a thumbnail for a folder.
     *
     * @param filename the path to an existing folder.
     * @return a thumbnail with up to 4 miniatures of supported files from the
     *         folder, or a placeholder image if the filename does not
     *         correspond to a directory or an error occured.
     */
    QImage generate( const QString& filename ) const final;

private:
    QImage _createFolderImage( const QDir& dir, bool generateThumbnails ) const;
    QVector<QRectF> _calculatePlacement( int nX, int nY, float padding,
                                         float totalWidth,
                                         float totalHeight ) const;
    void _paintThumbnailsMosaic( QImage& img,
                                 const QFileInfoList& fileList ) const;
    QFileInfoList _getSupportedFilesInDir( QDir dir ) const;
};

#endif
