/*********************************************************************/
/* Copyright (c) 2013-2017, EPFL/Blue Brain Project                  */
/*                          Daniel Nachbaur <daniel.nachbaur@epfl.ch>*/
/*                          Raphael Dumusc <raphael.dumusc@epfl.ch>  */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFITS;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of Ecole polytechnique federale de Lausanne.          */
/*********************************************************************/

#include "MultitouchListener.h"

#include "log.h"

#include <TUIO/TuioLog.h>

#include <stdexcept>

struct TuioLogInit
{
    TuioLogInit() { TUIO::setLogHandler(tuioMessageLogger); }
};
static TuioLogInit instance;

MultitouchListener::MultitouchListener()
    : TUIO::TuioListener()
{
    if (!_client.socket)
        throw std::runtime_error("TUIO could not start listening on UDP 3333");
    _client.addTuioListener(this);
    _client.connect();
}

MultitouchListener::~MultitouchListener()
{
    _client.removeTuioListener(this);
    _client.disconnect();
}

inline QPointF _getPos(TUIO::TuioCursor* tcur)
{
    return QPointF{tcur->getX(), tcur->getY()};
}

void MultitouchListener::addTuioCursor(TUIO::TuioCursor* tcur)
{
    emit touchPointAdded(tcur->getCursorID(), _getPos(tcur));
}

void MultitouchListener::updateTuioCursor(TUIO::TuioCursor* tcur)
{
    emit touchPointUpdated(tcur->getCursorID(), _getPos(tcur));
}

void MultitouchListener::removeTuioCursor(TUIO::TuioCursor* tcur)
{
    emit touchPointRemoved(tcur->getCursorID(), _getPos(tcur));
}
