---
title: Give Simple Feedback
author: Cumulus Networks
weight: 10
---
You can provide feedback about errors that are easy to fix, such as typographical errors, broken links, or simple grammar mistakes, using one of the following methods:

- Use the **Edit this page** link in any web document
- Post a message on [Cumulus Community Slack channel](http://slack.cumulusnetworks.com)

Details for each are included here. All are easy and quick, so choose the method that is most comfortable for you!

## Use Edit this page Link

This method is convenient when you find an error as you are reading a document.

{{%notice note%}}
You must have a GitHub account to submit your suggestion. If you do not have a GitHub account, you can either create one or use one of the other feedback methods.
{{%/notice%}}

To submit your feedback with this method:

1. Open the document in the [Cumulus Docs site](https://docs.cumulusnetworks.com).

2. Confirm you are displaying the document using one of the layouts with the right navigation column visible. If needed, select an appropriate layout.

3. At the top of that column, click the **Edit this page** link. This takes you to the editor for that page on GitHub.

4. Make your changes in the **Edit file** tab.

5. Click the **Preview changes** tab to see what your changes will look like.

6. When you are satisfied with your changes, scroll down until you see the    **Commit changes** box.

7. Type a summary (top field) and, optionally, a description (bottom field) of the changes you made.

8. Select **Create a new branch for this commit and start a pull request.** and enter the name of your branch.

9. Click **Propose file change**. This opens a new pull request (PR).

10. Select *stage* from the **base** dropdown.

    {{%notice note%}}
Please do not open PRs against the master branch.
    {{%/notice%}}

11. Verify that all of your changes are included in the commit, then click **Create pull request**.

You're done! You have now created a PR for the documentation team to review, and, if approved, they will publish your edits.

## Post a Message on Slack

If you use Slack, you can post your comment on the Cumulus Community Slack channel.

To submit feedback using this method:

1. Add the Cumulus Community Slack channel (http://cumulusnetworks.slack.com) if you have not already done so.

2. Select the **cumulus-content** channel, then enter your comment in the message box. Add this channel if needed.

3. Click **Enter** to post your comment.
